/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.movement;

import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.common.config.NuminaConfig;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IPlayerTickModule;
import net.machinemuse.numina.common.module.IToggleableModule;
import net.machinemuse.powersuits.client.control.PlayerMovementInputWrapper;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.event.MovementManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class SwimAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public SwimAssistModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.ionThruster, (int)1));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solenoid, (int)2));
        this.addTradeoffPropertyDouble("thrust", "swimBoostEnergyCon", 1000.0, "RF");
        this.addTradeoffPropertyDouble("thrust", "underwaterMovBoost", 1.0, "m/s");
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MOVEMENT;
    }

    public String getDataName() {
        return "swimAssist";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (player.func_70090_H() && !player.func_184218_aH()) {
            PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get(player);
            if (playerInput.moveForward != 0.0f || playerInput.moveStrafe != 0.0f || playerInput.jumpKey || playerInput.sneakKey) {
                double moveRatio = 0.0;
                if (playerInput.moveForward != 0.0f) {
                    moveRatio += (double)(playerInput.moveForward * playerInput.moveForward);
                }
                if (playerInput.moveStrafe != 0.0f) {
                    moveRatio += (double)(playerInput.moveStrafe * playerInput.moveStrafe);
                }
                if (playerInput.jumpKey || playerInput.sneakKey) {
                    moveRatio += 0.04000000000000001;
                }
                double swimAssistRate = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "underwaterMovBoost") * 0.05 * moveRatio;
                double swimEnergyConsumption = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "swimBoostEnergyCon");
                if (swimEnergyConsumption < (double)ElectricItemUtils.getPlayerEnergy((EntityPlayer)player)) {
                    if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                        Musique.playerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_SWIM_ASSIST, (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (Float)Float.valueOf(1.0f), (Boolean)true);
                    }
                    MovementManager.thrust(player, swimAssistRate, true);
                } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_SWIM_ASSIST);
                }
            } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_SWIM_ASSIST);
            }
        } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_SWIM_ASSIST);
        }
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_SWIM_ASSIST);
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.swimAssist;
    }
}

