/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.movement;

import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IPlayerTickModule;
import net.machinemuse.numina.common.module.IToggleableModule;
import net.machinemuse.numina.common.player.NuminaPlayerUtils;
import net.machinemuse.powersuits.client.control.PlayerMovementInputWrapper;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.event.MovementManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class JumpAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public JumpAssistModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.servoMotor, (int)4));
        this.addBasePropertyDouble("jumpEnergyCon", 0.0, "RF");
        this.addTradeoffPropertyDouble("power", "jumpEnergyCon", 250.0);
        this.addBasePropertyDouble("jumpBoost", 1.0, "%");
        this.addTradeoffPropertyDouble("power", "jumpBoost", 4.0);
        this.addBasePropertyDouble("jumpEnergyCon", 0.0, "RF");
        this.addTradeoffPropertyDouble("compensation", "jumpEnergyCon", 50.0);
        this.addBasePropertyDouble("jumpExhaustComp", 0.0, "%");
        this.addTradeoffPropertyDouble("compensation", "jumpExhaustComp", 1.0);
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MOVEMENT;
    }

    public String getDataName() {
        return "jumpAssist";
    }

    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get(player);
        if (playerInput.jumpKey) {
            double multiplier = MovementManager.getPlayerJumpMultiplier(player);
            if (multiplier > 0.0) {
                player.field_70181_x += 0.15 * Math.min(multiplier, 1.0);
                MovementManager.setPlayerJumpTicks(player, multiplier - 1.0);
            }
            player.field_70747_aH = player.func_70689_ay() * 0.2f;
        } else {
            MovementManager.setPlayerJumpTicks(player, 0.0);
        }
        NuminaPlayerUtils.resetFloatKickTicks((EntityPlayer)player);
    }

    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.jumpAssist;
    }
}

