/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.machinemuse.numina.client.render.modelspec.EnumSpecType;
import net.machinemuse.numina.client.render.modelspec.ModelPartSpec;
import net.machinemuse.numina.client.render.modelspec.ModelRegistry;
import net.machinemuse.numina.client.render.modelspec.PartSpecBase;
import net.machinemuse.numina.client.render.modelspec.SpecBase;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.common.item.armor.ItemPowerArmor;
import net.machinemuse.powersuits.common.item.tool.ItemPowerFist;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class DefaultModelSpec {
    public static NBTTagCompound makeModelPrefs(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemPowerArmor) {
                return DefaultModelSpec.makeModelPrefs(stack, ((ItemPowerArmor)stack.func_77973_b()).field_77881_a);
            }
            if (stack.func_77973_b() instanceof ItemPowerFist) {
                return DefaultModelSpec.makeModelPrefs(stack, EntityEquipmentSlot.MAINHAND);
            }
        }
        return new NBTTagCompound();
    }

    public static NBTTagCompound makeModelPrefs(@Nonnull ItemStack stack, EntityEquipmentSlot slot) {
        if (stack.func_190926_b()) {
            return new NBTTagCompound();
        }
        ArrayList<NBTTagCompound> prefArray = new ArrayList<NBTTagCompound>();
        NBTTagList specList = new NBTTagList();
        NBTTagCompound texSpecTag = new NBTTagCompound();
        List<Integer> colours = new ArrayList<Integer>();
        for (SpecBase spec : ModelRegistry.getInstance().getSpecs()) {
            if (!spec.isDefault()) continue;
            if (stack.func_77973_b() instanceof ItemPowerFist && spec.getSpecType().equals((Object)EnumSpecType.WIELDABLE)) {
                colours = DefaultModelSpec.addNewColourstoList(colours, spec.getColours());
                for (PartSpecBase partSpec : spec.getPartSpecs()) {
                    if (!(partSpec instanceof ModelPartSpec)) continue;
                    prefArray.add(((ModelPartSpec)partSpec).multiSet(new NBTTagCompound(), Integer.valueOf(DefaultModelSpec.getNewColourIndex(colours, spec.getColours(), partSpec.getDefaultColourtIndex())), Boolean.valueOf(((ModelPartSpec)partSpec).getGlow())));
                }
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemPowerArmor)) continue;
            colours = DefaultModelSpec.addNewColourstoList(colours, spec.getColours());
            if (spec.getSpecType().equals((Object)EnumSpecType.ARMOR_SKIN) && spec.get((Object)slot.func_188450_d()) != null) {
                texSpecTag = ((PartSpecBase)spec.get((Object)slot.func_188450_d())).multiSet(new NBTTagCompound(), Integer.valueOf(DefaultModelSpec.getNewColourIndex(colours, spec.getColours(), ((PartSpecBase)spec.get((Object)slot.func_188450_d())).getDefaultColourtIndex())));
                continue;
            }
            if (!spec.getSpecType().equals((Object)EnumSpecType.ARMOR_MODEL)) continue;
            if (!MPSConfig.INSTANCE.allowHighPollyArmorModels()) continue;
            for (PartSpecBase partSpec : spec.getPartSpecs()) {
                if (partSpec.getBinding().getSlot() != slot) continue;
                prefArray.add(((ModelPartSpec)partSpec).multiSet(new NBTTagCompound(), Integer.valueOf(DefaultModelSpec.getNewColourIndex(colours, spec.getColours(), partSpec.getDefaultColourtIndex())), Boolean.valueOf(((ModelPartSpec)partSpec).getGlow())));
            }
        }
        NBTTagCompound nbt = new NBTTagCompound();
        for (NBTTagCompound elem : prefArray) {
            nbt.func_74782_a(elem.func_74779_i("model") + "." + elem.func_74779_i("part"), (NBTBase)elem);
        }
        if (!specList.func_82582_d()) {
            nbt.func_74782_a("specList", (NBTBase)specList);
        }
        if (!texSpecTag.func_82582_d()) {
            nbt.func_74782_a("texSpec", (NBTBase)texSpecTag);
        }
        nbt.func_74782_a("colours", (NBTBase)new NBTTagIntArray(colours));
        return nbt;
    }

    static List<Integer> addNewColourstoList(List<Integer> colours, List<Integer> coloursToAdd) {
        for (Integer i : coloursToAdd) {
            if (colours.contains(i)) continue;
            colours.add(i);
        }
        return colours;
    }

    public static int getNewColourIndex(List<Integer> colours, List<Integer> oldColours, Integer index) {
        return colours.indexOf(oldColours.get(index != null ? index : 0));
    }
}

