/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AltStackStorage {
    static final byte FLAG_HASMETA = 1;
    static final byte FLAG_HASNBT = 2;
    static final byte FLAG_HASFORGECAPS = 4;
    static final byte FLAG_COUNT_ONE = 8;
    static final byte FLAG_COUNT_SIXTYFOUR = 16;
    static final byte[] EMPTY_ARRAY = new byte[0];
    private static final int mineCraftPrefixLength = "minecraft:".length();

    @Nonnull
    public static byte[] storeData(@Nullable ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return EMPTY_ARRAY;
        }
        NBTTagCompound nbt = stack.func_77955_b(new NBTTagCompound());
        String id = nbt.func_74779_i("id");
        if ("minecraft:air".equals(id)) {
            return EMPTY_ARRAY;
        }
        byte count = nbt.func_74771_c("Count");
        if (count == 0) {
            return EMPTY_ARRAY;
        }
        short damage = nbt.func_74765_d("Damage");
        boolean isVanilla = id.startsWith("minecraft:") && id.indexOf(58, mineCraftPrefixLength) < 0;
        NBTTagCompound tag = nbt.func_74764_b("tag") ? nbt.func_74775_l("tag") : null;
        NBTTagCompound forgeCaps = nbt.func_74764_b("ForgeCaps") ? nbt.func_74775_l("ForgeCaps") : null;
        byte type = 0;
        if (damage != 0) {
            type = (byte)(type | 1);
        }
        if (tag != null) {
            type = (byte)(type | 2);
        }
        if (forgeCaps != null) {
            type = (byte)(type | 4);
        }
        if (count == 1) {
            type = (byte)(type | 8);
        }
        if (count == 64) {
            type = (byte)(type | 0x10);
        }
        ByteBuf data = Unpooled.buffer();
        XUPacketBuffer buffer = new XUPacketBuffer(data);
        data.writeByte((int)type);
        if (isVanilla) {
            buffer.writeSmallString(id.substring(mineCraftPrefixLength));
        } else {
            buffer.writeSmallString(id);
        }
        if (count != 1 && count != 64) {
            buffer.writeByte(count);
        }
        if (damage != 0) {
            buffer.writeShort(damage);
        }
        if (tag != null) {
            buffer.writeNBT(tag);
        }
        if (forgeCaps != null) {
            buffer.writeNBT(forgeCaps);
        }
        int readableBytes = data.readableBytes();
        byte[] b = new byte[readableBytes];
        data.readBytes(b);
        return b;
    }

    @Nullable
    public static ItemStack loadData(@Nonnull byte[] bytes) {
        NBTTagCompound forgeCaps;
        NBTTagCompound tags;
        if (bytes.length == 0) {
            return StackHelper.empty();
        }
        ByteBuf data = Unpooled.wrappedBuffer((byte[])bytes);
        XUPacketBuffer buffer = new XUPacketBuffer(data);
        byte type = buffer.readByte();
        String id = buffer.readSmallString();
        if (id.indexOf(58) < 0) {
            id = "minecraft:" + id;
        }
        byte count = (type & 8) != 0 ? (byte)1 : ((type & 0x10) != 0 ? (byte)64 : (byte)buffer.readByte());
        short damage = (type & 1) != 0 ? buffer.readShort() : (short)0;
        if ((type & 2) != 0) {
            try {
                tags = buffer.readNBTChecked();
            }
            catch (IOException e) {
                return StackHelper.empty();
            }
        } else {
            tags = null;
        }
        if ((type & 4) != 0) {
            try {
                forgeCaps = buffer.readNBTChecked();
            }
            catch (IOException e) {
                return StackHelper.empty();
            }
        } else {
            forgeCaps = null;
        }
        if (data.readableBytes() > 0) {
            return StackHelper.empty();
        }
        NBTTagCompound finalTag = new NBTTagCompound();
        finalTag.func_74778_a("id", id);
        finalTag.func_74774_a("Count", count);
        finalTag.func_74777_a("Damage", damage);
        if (tags != null) {
            finalTag.func_74782_a("tag", (NBTBase)tags);
        }
        if (forgeCaps != null) {
            finalTag.func_74782_a("ForgeCaps", (NBTBase)forgeCaps);
        }
        return StackHelper.loadFromNBT(finalTag);
    }

    public static void test() {
    }
}

