/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.core.world;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import io.github.lxgaming.sledgehammer.util.world.chunk.EmptyChunk;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={World.class})
public abstract class WorldMixin_ChunkUnload {
    private boolean sledgehammer$unloading = false;

    @Redirect(method={"updateEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntity;onChunkUnload()V", remap=false))
    private void onChunkUnload(TileEntity tileEntity) {
        this.sledgehammer$unloading = true;
        tileEntity.onChunkUnload();
        this.sledgehammer$unloading = false;
    }

    @Inject(method={"getChunk(II)Lnet/minecraft/world/chunk/Chunk;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetChunk(int chunkX, int chunkZ, CallbackInfoReturnable<Chunk> callbackInfoReturnable) {
        if (!this.sledgehammer$unloading) {
            return;
        }
        Chunk chunk = Toolbox.getLoadedChunkWithoutMarkingActive((World)this, chunkX, chunkZ);
        if (chunk != null && chunk.func_177410_o() && !chunk.field_189550_d) {
            callbackInfoReturnable.setReturnValue(chunk);
            return;
        }
        Sledgehammer.getInstance().debug("A TileEntity attempted to load a Chunk ({}, {}) during Chunk unload", chunkX, chunkZ);
        callbackInfoReturnable.setReturnValue(new EmptyChunk((World)this, 0, 0));
    }
}

