/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.map.MapProcessor;
import xaero.map.file.export.PNGExportResult;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.MySmallButton;
import xaero.map.settings.ModOptions;

public class ExportScreen
extends GuiSettings {
    private static final ITextComponent EXPORTING_MESSAGE = new TextComponentTranslation("gui.xaero_export_screen_exporting", new Object[0]);
    private final MapProcessor mapProcessor;
    private PNGExportResult result;
    private int stage;
    private final MapTileSelection selection;
    public boolean fullExport;

    public ExportScreen(GuiScreen backScreen, GuiScreen escScreen, MapProcessor mapProcessor, MapTileSelection selection) {
        super(I18n.func_135052_a((String)"gui.xaero_export_screen", (Object[])new Object[0]), backScreen, escScreen);
        this.mapProcessor = mapProcessor;
        this.selection = selection;
        this.entries = new ISettingEntry[]{new ConfigSettingEntry(ModOptions.FULL_EXPORT), new ConfigSettingEntry(ModOptions.MULTIPLE_IMAGES_EXPORT), new ConfigSettingEntry(ModOptions.NIGHT_EXPORT), new ConfigSettingEntry(ModOptions.EXPORT_HIGHLIGHTS), new ConfigSettingEntry(ModOptions.EXPORT_SCALE_DOWN_SQUARE)};
        this.canSearch = false;
        this.shouldAddBackButton = false;
    }

    @Override
    public void func_73866_w_() {
        if (this.stage > 0) {
            return;
        }
        super.func_73866_w_();
        this.func_189646_b(new MySmallButton(201, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.func_189646_b(new MySmallButton(202, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) throws IOException {
        super.func_146284_a(par1GuiButton);
        if (par1GuiButton.field_146127_k == 201) {
            this.stage = 1;
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            return;
        }
        if (par1GuiButton.field_146127_k == 202) {
            this.goBack();
            return;
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.renderEscapeScreen(par1, par2, par3);
        super.func_73863_a(par1, par2, par3);
        if (this.result != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, this.result.getMessage().func_150254_d(), this.field_146294_l / 2, 20, -1);
        }
        if (this.stage > 0) {
            this.func_73732_a(this.field_146297_k.field_71466_p, EXPORTING_MESSAGE.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 6 + 68, -1);
            if (this.stage == 1) {
                this.stage = 2;
                return;
            }
        }
        if (this.stage != 2) {
            return;
        }
        if (this.mapProcessor.getMapSaveLoad().exportPNG(this, this.fullExport ? null : this.selection)) {
            this.stage = 3;
            this.result = null;
            for (GuiButton c : this.field_146292_n) {
                c.field_146124_l = false;
            }
            return;
        }
        this.stage = 0;
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    public void onExportDone(PNGExportResult result) {
        this.result = result;
        this.stage = 0;
    }

    public MapTileSelection getSelection() {
        return this.selection;
    }
}

