/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.controls.ControlsHandler;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.executor.Executor;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.graphics.TextureUploader;
import xaero.map.gui.message.MessageBox;
import xaero.map.gui.message.render.MessageBoxRenderer;
import xaero.map.highlight.HighlighterRegistry;
import xaero.map.highlight.MapRegionHighlightsPreparer;
import xaero.map.misc.CaveStartCalculator;
import xaero.map.radar.tracker.synced.ClientSyncedTrackedPlayerManager;

public class WorldMapSession {
    private ControlsHandler controlsHandler;
    private MapProcessor mapProcessor;
    private MapWriter mapWriter;
    private boolean usable;

    public void init() throws NoSuchFieldException {
        BlockStateShortShapeCache blockStateShortShapeCache = new BlockStateShortShapeCache(this);
        MapSaveLoad mapSaveLoad = new MapSaveLoad(WorldMap.overlayManager, WorldMap.pngExporter, blockStateShortShapeCache);
        TextureUploader textureUploader = new TextureUploader(WorldMap.normalTextureUploadPool, WorldMap.compressedTextureUploadPool, WorldMap.branchUpdatePool, WorldMap.branchUpdateAllocatePool, WorldMap.branchDownloadPool, WorldMap.subsequentNormalTextureUploadPool, WorldMap.textureUploadBenchmark);
        BlockStateColorTypeCache blockStateColorTypeCache = new BlockStateColorTypeCache();
        blockStateColorTypeCache.updateGrassColor();
        BiomeColorCalculator biomeColorCalculator = new BiomeColorCalculator();
        WorldDataReader worldDataReader = new WorldDataReader(WorldMap.overlayManager, blockStateColorTypeCache, blockStateShortShapeCache);
        Executor worldDataRenderExecutor = new Executor("world data render executor", Thread.currentThread());
        WorldDataHandler worldDataHandler = new WorldDataHandler(worldDataReader, worldDataRenderExecutor);
        this.mapWriter = new MapWriter(WorldMap.overlayManager, blockStateColorTypeCache, blockStateShortShapeCache);
        HighlighterRegistry highlightRegistry = new HighlighterRegistry();
        highlightRegistry.end();
        MapRegionHighlightsPreparer mapRegionHighlightsPreparer = new MapRegionHighlightsPreparer();
        ClientSyncedTrackedPlayerManager clientSyncedTrackedPlayerManager = new ClientSyncedTrackedPlayerManager();
        this.mapProcessor = new MapProcessor(mapSaveLoad, this.mapWriter, WorldMap.mapLimiter, WorldMap.bufferDeallocator, WorldMap.tilePool, WorldMap.overlayManager, textureUploader, worldDataHandler, WorldMap.mapBiomes, WorldMap.worldMapClient.branchTextureRenderer, biomeColorCalculator, blockStateColorTypeCache, blockStateShortShapeCache, highlightRegistry, mapRegionHighlightsPreparer, MessageBox.Builder.begin().build(), new MessageBoxRenderer(), new CaveStartCalculator(this.mapWriter), clientSyncedTrackedPlayerManager, new Executor("generic render thread", Thread.currentThread()));
        this.mapWriter.setMapProcessor(this.mapProcessor);
        mapSaveLoad.setMapProcessor(this.mapProcessor);
        worldDataReader.setMapProcessor(this.mapProcessor);
        this.controlsHandler = new ControlsHandler(this.mapProcessor);
        this.mapProcessor.onInit();
        this.usable = true;
        WorldMap.LOGGER.info("New world map session initialized!");
    }

    public void cleanup() {
        try {
            if (this.usable) {
                this.mapProcessor.stop();
                WorldMap.LOGGER.info("Finalizing world map session...");
                WorldMap.mapRunnerThread.interrupt();
                while (!this.mapProcessor.isFinished()) {
                    this.mapProcessor.waitForLoadingToFinish(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
            }
            WorldMap.LOGGER.info("World map session finalized.");
            WorldMap.onSessionFinalized();
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("World map session failed to finalize properly.", t);
        }
        this.usable = false;
    }

    public ControlsHandler getControlsHandler() {
        return this.controlsHandler;
    }

    public MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public static WorldMapSession getCurrentSession() {
        WorldMapSession session = WorldMapSession.getForPlayer(Minecraft.func_71410_x().field_71439_g);
        if (session == null && XaeroWorldMapCore.currentSession != null && XaeroWorldMapCore.currentSession.usable) {
            session = XaeroWorldMapCore.currentSession;
        }
        return session;
    }

    public static WorldMapSession getForPlayer(EntityPlayerSP player) {
        if (player == null || player.field_71174_a == null) {
            return null;
        }
        return ((IWorldMapClientPlayNetHandler)player.field_71174_a).getXaero_worldmapSession();
    }

    public boolean isUsable() {
        return this.usable;
    }
}

