/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class WaypointsManager {
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private Minecraft mc;
    private HashMap<String, WaypointWorldContainer> waypointMap = new HashMap();
    private WaypointSet waypoints = null;
    private List<Waypoint> serverWaypoints = null;
    public static final Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = new Hashtable();
    private String mainContainerID;
    private String containerID = null;
    private String containerIDIgnoreCaseCache;
    private String customContainerID = null;
    private String worldID = null;
    private String customWorldID = null;
    private BlockPos currentSpawn;
    public long setChanged;
    public static final String TELEPORT_ANYWAY_COMMAND = "/xaero_tp_anyway";
    private Waypoint teleportAnywayWP;
    private WaypointWorld teleportAnywayWorld;

    public WaypointsManager(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.mc = Minecraft.func_71410_x();
    }

    public void onLoad() {
        this.mainContainerID = this.getMainContainer();
    }

    public double getDimensionDivision(String worldContainerID) {
        if (worldContainerID == null || Minecraft.func_71410_x().field_71441_e == null) {
            return 1.0;
        }
        String dimPart = worldContainerID.substring(worldContainerID.lastIndexOf(47) + 1);
        Integer dimKey = this.getDimensionForDirectoryName(dimPart);
        if (dimKey != null && (dimKey == -1 || dimKey == 0 || dimKey == 1)) {
            double currentDimDiv = Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p() == DimensionType.NETHER ? 8.0 : 1.0;
            double selectedDimDiv = dimKey == -1 ? 8.0 : 1.0;
            return currentDimDiv / selectedDimDiv;
        }
        return 1.0;
    }

    public String getDimensionDirectoryName(int dim) {
        return "dim%" + dim;
    }

    public DimensionType findDimensionType(String validatedName) {
        DimensionType[] allDimensionTypes;
        for (DimensionType dt : allDimensionTypes = DimensionType.values()) {
            if (!validatedName.equals(dt.func_186065_b().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dt;
        }
        return null;
    }

    public Integer getDimensionForDirectoryName(String dirName) {
        int dimId;
        String dimIdPart = dirName.substring(4);
        if (!dimIdPart.matches("-{0,1}[0-9]+")) {
            return null;
        }
        try {
            dimId = Integer.parseInt(dimIdPart);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return dimId;
    }

    private String getMainContainer() {
        String potentialContainerID;
        if (this.mc.func_71401_C() != null) {
            potentialContainerID = this.mc.func_71401_C().func_71270_I().replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else if (this.mc.func_147104_D() != null) {
            String serverIP;
            String string = serverIP = this.modMain.getSettings().differentiateByServerAddress ? this.mc.func_147104_D().field_78845_b : "Any Address";
            if (serverIP.contains(":")) {
                serverIP = serverIP.substring(0, serverIP.indexOf(":"));
            }
            while (serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            potentialContainerID = "Multiplayer_" + serverIP.replace(":", "\u00a7").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else {
            potentialContainerID = this.mc.func_181540_al() && this.modMain.getEvents().latestRealm != null ? "Realms_" + this.modMain.getEvents().latestRealm.ownerUUID + "." + this.modMain.getEvents().latestRealm.id : "Unknown";
        }
        potentialContainerID = this.ignoreContainerCase(potentialContainerID, null);
        return potentialContainerID;
    }

    public String ignoreContainerCase(String potentialContainerID, String current) {
        if (potentialContainerID.equalsIgnoreCase(current)) {
            return current;
        }
        Set<Map.Entry<String, WaypointWorldContainer>> entries = this.waypointMap.entrySet();
        for (Map.Entry<String, WaypointWorldContainer> e : entries) {
            String containerSearch = e.getValue().getEqualIgnoreCaseSub(potentialContainerID);
            if (containerSearch == null) continue;
            return containerSearch;
        }
        return potentialContainerID;
    }

    public String getNewAutoWorldID(int dimId, boolean useWorldmap) {
        String worldmapMultiworldId;
        if (this.mc.func_71401_C() != null) {
            return "waypoints";
        }
        WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)this.getWorldContainer(this.mainContainerID);
        Object autoIdBase = this.getAutoIdBase(rootContainer);
        String string = worldmapMultiworldId = useWorldmap ? this.modMain.getSupportMods().worldmapSupport.tryToGetMultiworldId((World)this.mc.field_71441_e, dimId) : null;
        if (!(autoIdBase == null || useWorldmap && worldmapMultiworldId == null)) {
            String actualMultiworldId;
            if (autoIdBase instanceof BlockPos) {
                BlockPos pos = (BlockPos)autoIdBase;
                actualMultiworldId = "mw" + (pos.func_177958_n() >> 6) + "," + (pos.func_177956_o() >> 6) + "," + (pos.func_177952_p() >> 6);
                if (!rootContainer.isUsingMultiworldDetection()) {
                    String defaultMultiworldId = rootContainer.getDefaultMultiworldId();
                    if (defaultMultiworldId == null) {
                        rootContainer.setDefaultMultiworldId(actualMultiworldId);
                        rootContainer.saveConfig();
                    } else {
                        actualMultiworldId = defaultMultiworldId;
                    }
                }
            } else {
                actualMultiworldId = "mw$" + autoIdBase;
            }
            if (useWorldmap && !worldmapMultiworldId.equals("minimap")) {
                actualMultiworldId = worldmapMultiworldId;
            }
            return actualMultiworldId;
        }
        return null;
    }

    public String getCurrentContainerAndWorldID() {
        return this.getCurrentContainerAndWorldID(this.containerID, this.worldID);
    }

    public String getCurrentContainerID() {
        return this.getCurrentContainerID(this.containerID);
    }

    public String getCurrentWorldID() {
        return this.getCurrentWorldID(this.worldID);
    }

    public WaypointWorld getCurrentWorld() {
        return this.getCurrentWorld(this.containerID, this.worldID);
    }

    public String getCurrentOriginContainerID() {
        return this.getCurrentOriginContainerID(this.containerID);
    }

    public String getCurrentContainerAndWorldID(String autoContainer, String autoWorldID) {
        return this.getCurrentContainerID(autoContainer) + "_" + this.getCurrentWorldID(autoWorldID);
    }

    public String getCurrentContainerID(String autoContainer) {
        if (this.customContainerID == null) {
            return autoContainer;
        }
        return this.customContainerID;
    }

    public String getCurrentWorldID(String autoWorldID) {
        if (this.customWorldID == null) {
            return autoWorldID;
        }
        return this.customWorldID;
    }

    public WaypointWorld getCurrentWorld(String autoContainer, String autoWorldID) {
        return this.getWorld(this.getCurrentContainerID(autoContainer), this.getCurrentWorldID(autoWorldID));
    }

    public String getCurrentOriginContainerID(String autoContainer) {
        if (this.getCurrentContainerID(autoContainer) == null) {
            return null;
        }
        return this.getCurrentContainerID(autoContainer).split("/")[0];
    }

    public WaypointWorld getAutoWorld() {
        return this.getWorld(this.getAutoContainerID(), this.getAutoWorldID());
    }

    public String getAutoRootContainerID() {
        return this.mainContainerID;
    }

    public String getAutoContainerID() {
        return this.containerID;
    }

    public String getAutoWorldID() {
        return this.worldID;
    }

    public WaypointWorld getWorld(String container, String world) {
        return this.addWorld(container, world);
    }

    public WaypointWorld addWorld(String container, String world) {
        if (container == null) {
            return null;
        }
        WaypointWorldContainer wc = this.addWorldContainer(container);
        return wc.addWorld(world);
    }

    public WaypointWorldContainer getWorldContainer(String id) {
        return this.addWorldContainer(id);
    }

    public WaypointWorldContainer addWorldContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container != null) continue;
                container = new WaypointWorldRootContainer(this.modMain, this.minimapSession, subs[i]);
                this.waypointMap.put(subs[i], container);
                WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)container;
                if (rootContainer.configLoaded) continue;
                rootContainer.loadConfig();
                continue;
            }
            container = container.addSubContainer(subs[i]);
        }
        return container;
    }

    public WaypointWorldContainer getWorldContainerNullable(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            container = i == 0 ? this.waypointMap.get(subs[i]) : container.subContainers.get(subs[i]);
            if (container != null) continue;
            return null;
        }
        return container;
    }

    public void removeContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return;
                }
                if (i != subs.length - 1) continue;
                this.waypointMap.remove(subs[i]);
                return;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    container.deleteSubContainer(subs[i]);
                    return;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return;
        }
    }

    public boolean containerExists(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return false;
                }
                if (i != subs.length - 1) continue;
                return true;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    return true;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return false;
        }
        return false;
    }

    public void updateWorldIds() {
        String oldContainerID = this.containerID;
        String oldWorldID = this.worldID;
        this.containerIDIgnoreCaseCache = this.containerID = this.getPotentialContainerID();
        String potentialWorldID = this.getNewAutoWorldID(this.mc.field_71441_e.field_73011_w.getDimension(), this.modMain.getSupportMods().worldmap());
        if (potentialWorldID == null) {
            this.containerID = oldContainerID;
            this.worldID = oldWorldID;
        } else {
            this.worldID = potentialWorldID;
            if (this.containerID != null && !this.containerID.equals(oldContainerID)) {
                if (oldWorldID != null && oldWorldID.startsWith("plugin")) {
                    WaypointWorldContainer oldContainer = this.getWorldContainer(oldContainerID);
                    ArrayList<WaypointWorld> worlds = new ArrayList<WaypointWorld>(oldContainer.worlds.values());
                    for (int i = 0; i < worlds.size(); ++i) {
                        worlds.get(i).getServerWaypoints().clear();
                    }
                }
                WaypointWorldContainer rootContainer = this.getWorldContainer(this.mainContainerID);
                rootContainer.renameOldContainer(this.containerID);
            }
        }
    }

    private String getPotentialContainerID() {
        return this.ignoreContainerCase(this.mainContainerID + "/" + this.getDimensionDirectoryName(this.mc.field_71441_e.field_73011_w.getDimension()), this.containerIDIgnoreCaseCache);
    }

    public void updateWaypoints() {
        if (this.containerID != null && this.worldID != null) {
            this.addWorld(this.containerID, this.worldID);
            WaypointWorld world = this.getCurrentWorld();
            this.waypoints = world.getCurrentSet();
            this.serverWaypoints = !world.getServerWaypoints().isEmpty() ? new ArrayList<Waypoint>(world.getServerWaypoints().values()) : null;
        }
    }

    public void createDeathpoint(EntityPlayer p) {
        WaypointWorld autoWorld;
        boolean shouldAddToAuto;
        this.updateWorldIds();
        if (this.modMain.getSettings().switchToAutoOnDeath) {
            this.setCustomContainerID(null);
            this.setCustomWorldID(null);
        }
        boolean bl = shouldAddToAuto = (autoWorld = this.getAutoWorld()) != null;
        if (this.modMain.getSupportMods().worldmap()) {
            String realCurrentDimContainerKey = this.getPotentialContainerID();
            boolean containerIsSynced = realCurrentDimContainerKey.equals(this.containerID);
            List<String> allPotentialMWIds = this.modMain.getSupportMods().worldmapSupport.getPotentialMultiworldIds(p.field_70170_p, p.field_70170_p.field_73011_w.getDimension());
            if (allPotentialMWIds != null && !allPotentialMWIds.isEmpty()) {
                for (String mwId : allPotentialMWIds) {
                    WaypointWorld potentialWorld = this.getWorld(realCurrentDimContainerKey, mwId);
                    if (containerIsSynced && potentialWorld == autoWorld) continue;
                    this.createDeathpoint(p, potentialWorld, false);
                }
                boolean bl2 = shouldAddToAuto = shouldAddToAuto && containerIsSynced;
            }
        }
        if (shouldAddToAuto) {
            this.createDeathpoint(p, autoWorld, false);
        }
    }

    private void createDeathpoint(EntityPlayer p, WaypointWorld wpw, boolean temp) {
        boolean disabled = false;
        WaypointSet waypoints = wpw.getCurrentSet();
        if (waypoints == null) {
            return;
        }
        block2: for (WaypointSet set : wpw.getSets().values()) {
            for (int i = 0; i < set.getList().size(); ++i) {
                Waypoint w = set.getList().get(i);
                if (w.getWaypointType() != 1) continue;
                if (set == waypoints) {
                    disabled = w.isDisabled();
                }
                if (!this.modMain.getSettings().getOldDeathpoints()) {
                    set.getList().remove(i);
                    --i;
                    continue block2;
                }
                w.setType(2);
                w.setName("gui.xaero_deathpoint_old");
                continue block2;
            }
        }
        ArrayList<Waypoint> list = waypoints.getList();
        double dimDiv = this.getDimensionDivision(wpw.getContainer().getKey());
        if (this.modMain.getSettings().getDeathpoints()) {
            Waypoint deathpoint = new Waypoint(OptimizedMath.myFloor((double)OptimizedMath.myFloor(p.field_70165_t) * dimDiv), OptimizedMath.myFloor(p.field_70163_u), OptimizedMath.myFloor((double)OptimizedMath.myFloor(p.field_70161_v) * dimDiv), "gui.xaero_deathpoint", "D", 0, 1);
            deathpoint.setDisabled(disabled);
            deathpoint.setTemporary(temp);
            list.add(0, deathpoint);
        }
        try {
            this.modMain.getSettings().saveWaypoints(wpw);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z) {
        this.createTemporaryWaypoints(waypointWorld, x, y, z, true);
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z, boolean yIncluded) {
        if (this.modMain.getSettings().waypointsGUI(this) && waypointWorld != null) {
            double dimDiv = this.getDimensionDivision(this.getCurrentContainerID());
            x = OptimizedMath.myFloor((double)x * dimDiv);
            z = OptimizedMath.myFloor((double)z * dimDiv);
            Waypoint instant = new Waypoint(x, y, z, "Waypoint", "X", (int)(Math.random() * (double)ModSettings.ENCHANT_COLORS.length), 0, true, yIncluded);
            if (!this.modMain.getSettings().waypointsBottom) {
                waypointWorld.getCurrentSet().getList().add(0, instant);
            } else {
                waypointWorld.getCurrentSet().getList().add(instant);
            }
        }
    }

    public boolean canTeleport(boolean displayingTeleportableWorld, WaypointWorld displayedWorld) {
        return (this.modMain.getSettings().allowWrongWorldTeleportation || displayingTeleportableWorld) && displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    public void teleportAnyway() {
        if (this.teleportAnywayWP != null) {
            GuiScreen dummyScreen = new GuiScreen(){};
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution scaledresolution = new ScaledResolution(minecraft);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            dummyScreen.func_146280_a(minecraft, i, j);
            this.teleportToWaypoint(this.teleportAnywayWP, this.teleportAnywayWorld, dummyScreen, false);
        }
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, GuiScreen screen) {
        this.teleportToWaypoint(selected, displayedWorld, screen, true);
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, GuiScreen screen, boolean respectHiddenCoords) {
        boolean displayingTeleportableWorld = this.isWorldTeleportable(displayedWorld);
        if (selected != null && this.canTeleport(displayingTeleportableWorld, displayedWorld)) {
            if (!selected.isYIncluded() && this.mc.field_71442_b.func_78763_f()) {
                TextComponentString messageComponent = new TextComponentString("\u00a7c" + I18n.func_135052_a((String)"gui.xaero_teleport_y_unknown", (Object[])new Object[0]));
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
            } else if (respectHiddenCoords && this.modMain.getSettings().hideWaypointCoordinates && this.mc.field_71474_y.field_74343_n != EntityPlayer.EnumChatVisibility.HIDDEN) {
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString("\u00a7b" + I18n.func_135052_a((String)"gui.xaero_teleport_coordinates_hidden", (Object[])new Object[0])));
                TextComponentString clickableQuestion = new TextComponentString("\u00a7e[" + I18n.func_135052_a((String)"gui.xaero_teleport_anyway", (Object[])new Object[0]) + "]");
                clickableQuestion.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, TELEPORT_ANYWAY_COMMAND)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("\u00a7c" + I18n.func_135052_a((String)"gui.xaero_teleport_shows_coordinates", (Object[])new Object[0]))));
                this.teleportAnywayWP = selected;
                this.teleportAnywayWorld = displayedWorld;
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)clickableQuestion);
            } else {
                String tpCommandPrefix;
                int x = selected.getX();
                int z = selected.getZ();
                double dimDiv = this.getDimensionDivision(displayedWorld.getContainer().getKey());
                if (dimDiv != 1.0) {
                    x = (int)Math.floor((double)x / dimDiv);
                    z = (int)Math.floor((double)z / dimDiv);
                }
                WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
                String serverTpCommand = selected.isRotation() ? rootContainer.getServerTeleportCommandRotationFormat() : rootContainer.getServerTeleportCommandFormat();
                String defaultTpCommand = selected.isRotation() ? this.modMain.getSettings().defaultWaypointTPCommandRotationFormat : this.modMain.getSettings().defaultWaypointTPCommandFormat;
                String string = tpCommandPrefix = rootContainer.isUsingDefaultTeleportCommand() || serverTpCommand == null ? defaultTpCommand : serverTpCommand;
                String yString = !selected.isYIncluded() ? "~" : (this.modMain.getSettings().getPartialYTeleportation() ? (double)selected.getY() + 0.5 + "" : selected.getY() + "");
                tpCommandPrefix = tpCommandPrefix.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z).replace("{name}", selected.getLocalizedName());
                if (selected.isRotation()) {
                    tpCommandPrefix = tpCommandPrefix.replace("{yaw}", "" + selected.getYaw());
                }
                screen.func_175281_b(tpCommandPrefix, false);
            }
            this.mc.func_147108_a(null);
        }
    }

    public boolean isWorldTeleportable(WaypointWorld displayedWorld) {
        return displayedWorld.getContainer().getRootContainer().getKey().equals(this.getAutoRootContainerID()) && displayedWorld == this.getAutoWorld();
    }

    public WaypointSet getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(WaypointSet waypoints) {
        this.waypoints = waypoints;
    }

    public List<Waypoint> getServerWaypoints() {
        return this.serverWaypoints;
    }

    public HashMap<String, WaypointWorldContainer> getWaypointMap() {
        return this.waypointMap;
    }

    public void setCurrentSpawn(BlockPos currentSpawn) {
        this.currentSpawn = currentSpawn;
    }

    public String getCustomContainerID() {
        return this.customContainerID;
    }

    public void setCustomContainerID(String customContainerID) {
        this.customContainerID = customContainerID;
    }

    public String getCustomWorldID() {
        return this.customWorldID;
    }

    public void setCustomWorldID(String customWorldID) {
        this.customWorldID = customWorldID;
    }

    public static Hashtable<Integer, Waypoint> getCustomWaypoints(String modName) {
        Hashtable<Integer, Waypoint> wps = customWaypoints.get(modName);
        if (wps == null) {
            wps = new Hashtable();
            customWaypoints.put(modName, wps);
        }
        return wps;
    }

    public boolean isMultiplayer(String containerId) {
        return containerId.startsWith("Multiplayer_") || containerId.startsWith("Realms_");
    }

    private boolean hasServerLevelId(WaypointWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData.serverLevelId != null && !rootContainer.isIgnoreServerLevelId();
    }

    private Object getAutoIdBase(WaypointWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return this.hasServerLevelId(rootContainer) ? worldData.serverLevelId : this.currentSpawn;
    }

    public void onServerLevelId(int id) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = id;
        MinimapLogs.LOGGER.info("Minimap updated server level id: " + id + " for world " + Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
    }

    @Deprecated
    public boolean divideBy8(String key) {
        return false;
    }
}

