/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.info.render;

import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.render.compile.InfoDisplayCompiler;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.settings.ModSettings;

public final class InfoDisplayRenderer {
    private final InfoDisplayCompiler compiler = new InfoDisplayCompiler();

    public void render(XaeroMinimapSession session, MinimapProcessor processor, MinimapInterface minimapInterface, MinimapRendererHelper helper, int x, int y, int width, int height, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos, int scaledX, int scaledY, float mapScale, ModSettings settings) {
        Iterator iterator = minimapInterface.getInfoDisplayManager().getStream().iterator();
        int interfaceSize = size;
        int scaledHeight = (int)((float)height * mapScale);
        int align = settings.minimapTextAlign;
        boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
        int stringY = scaledY + (under ? interfaceSize : -9);
        int bgOpacityMask = settings.infoDisplayBackgroundOpacity * 255 / 100 << 24;
        while (iterator.hasNext()) {
            InfoDisplay infoDisplay = (InfoDisplay)iterator.next();
            List<ITextComponent> compiledLines = this.compiler.compile(infoDisplay, session, processor, x, y, width, height, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos);
            int textColorIndex = infoDisplay.getTextColor();
            int backgroundColorIndex = infoDisplay.getBackgroundColor();
            int textColor = ModSettings.COLORS[textColorIndex < 0 ? 15 : textColorIndex % ModSettings.COLORS.length];
            int backgroundColor = backgroundColorIndex < 0 ? 0 : bgOpacityMask | ModSettings.COLORS[backgroundColorIndex % ModSettings.COLORS.length] & 0xFFFFFF;
            for (int i = 0; i < compiledLines.size(); ++i) {
                String s = compiledLines.get(i).func_150254_d();
                int stringWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
                int stringX = scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth));
                if (backgroundColor != 0) {
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    helper.drawMyColoredSizedRect(stringX - 1, stringY - 1, stringWidth + 2, 10.0f, backgroundColor);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179098_w();
                }
                Minecraft.func_71410_x().field_71466_p.func_175063_a(s, (float)stringX, (float)stringY, textColor);
                stringY += 10 * (under ? 1 : -1);
            }
            compiledLines.clear();
        }
    }
}

