/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.info;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.Biome;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.InfoDisplayManager;
import xaero.common.minimap.info.codec.InfoDisplayCommonStateCodecs;
import xaero.common.minimap.info.render.compile.InfoDisplayCompiler;
import xaero.common.minimap.info.render.compile.InfoDisplayOnCompile;
import xaero.common.minimap.info.widget.InfoDisplayCommonWidgetFactories;
import xaero.common.minimap.info.widget.InfoDisplayCycleWidgetFactory;
import xaero.common.minimap.waypoints.WaypointsManager;

public class BuiltInInfoDisplays {
    private static List<InfoDisplay<?>> ALL = new ArrayList();
    public static final InfoDisplay<Boolean> COORDINATES = new InfoDisplay<Boolean>("coords", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_coords", new Object[0]), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            int interfaceSize = size;
            String coords = playerBlockX + ", " + playerBlockY + ", " + playerBlockZ;
            if (Minecraft.func_71410_x().field_71466_p.func_78256_a(coords) >= interfaceSize) {
                String stringLevel = "" + playerBlockY;
                coords = playerBlockX + ", " + playerBlockZ;
                compiler.addLine(coords);
                compiler.addLine(stringLevel);
            } else {
                compiler.addLine(coords);
            }
        }
    }, ALL);
    public static final InfoDisplay<Boolean> OVERWORLD_COORDINATES = new InfoDisplay<Boolean>("overworld_coords", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_overworld_coords", new Object[0]), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            double coordinateScale;
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            double d = coordinateScale = mc.field_71441_e.field_73011_w.func_186058_p() == DimensionType.NETHER ? 8.0 : 1.0;
            if (coordinateScale == 1.0) {
                return;
            }
            int overworldPlayerX = MathHelper.func_76128_c((double)((double)playerBlockX * coordinateScale));
            int overworldPlayerZ = MathHelper.func_76128_c((double)((double)playerBlockZ * coordinateScale));
            String coords = "Xo: " + overworldPlayerX + ", Zo: " + overworldPlayerZ;
            compiler.addWords(size, coords);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> CHUNK_COORDINATES = new InfoDisplay<Boolean>("chunk_coords", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_chunk_coords", new Object[0]), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            int chunkX = playerBlockX >> 4;
            int chunkZ = playerBlockZ >> 4;
            int insideX = playerBlockX & 0xF;
            int insideZ = playerBlockZ & 0xF;
            String coords = "C " + chunkX + ", " + chunkZ + " (" + insideX + "; " + insideZ + ")";
            compiler.addWords(size, coords);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> ANGLES = new InfoDisplay<Boolean>("angles", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_angles", new Object[0]), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            compiler.addLine((ITextComponent)new TextComponentString(String.format("%.1f / %.1f", Float.valueOf(MathHelper.func_76142_g((float)mc.func_175606_aa().field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)mc.func_175606_aa().field_70125_A)))));
        }
    }, ALL);
    public static final InfoDisplay<Boolean> DIMENSION = new InfoDisplay<Boolean>("dimension", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_dimension", new Object[0]), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            int dimensionId = mc.field_71441_e.field_73011_w.getDimension();
            DimensionType dimensionType = mc.field_71441_e.field_73011_w.func_186058_p();
            if (dimensionType != null) {
                String dimensionName = String.format("%s (%d)", dimensionType.func_186065_b(), dimensionId);
                compiler.addLine(dimensionName);
            }
        }
    }, ALL);
    public static final InfoDisplay<Boolean> BIOME = new InfoDisplay<Boolean>("biome", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_biome", new Object[0]), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            Biome biome = mc.field_71441_e.func_175726_f(playerPos).func_177411_a(playerPos, mc.field_71441_e.func_72959_q());
            String biomeText = biome == null ? I18n.func_135052_a((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : biome.func_185359_l();
            compiler.addWords(size, biomeText);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> WEATHER = new InfoDisplay<Boolean>("weather", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_weather", new Object[0]), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            if (Minecraft.func_71410_x().field_71441_e.func_72911_I()) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_weather_thundering", new Object[0]));
            } else if (Minecraft.func_71410_x().field_71441_e.func_72896_J()) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_weather_raining", new Object[0]));
            }
        }
    }, ALL);
    public static final InfoDisplay<Integer> LIGHT_LEVEL = new InfoDisplay<Integer>("light_level", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_light_level", new Object[0]), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new ITextComponent[]{new TextComponentTranslation("gui.xaero_off", new Object[0]), new TextComponentTranslation("gui.xaero_light_block", new Object[0]), new TextComponentTranslation("gui.xaero_light_sky", new Object[0]), new TextComponentTranslation("gui.xaero_light_all", new Object[0]), new TextComponentTranslation("gui.xaero_light_both2", new Object[0])})), new InfoDisplayOnCompile<Integer>(){

        @Override
        public void onCompile(InfoDisplay<Integer> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            int skyLight;
            int blockLight;
            int showLightLevel = displayInfo.getState();
            if (showLightLevel == 0) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            int n = blockLight = playerBlockY >= 0 && playerBlockY < 256 ? mc.field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, playerPos) : 0;
            int n2 = playerBlockY >= 256 ? 15 : (skyLight = playerBlockY < 0 ? 0 : mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, playerPos));
            if (showLightLevel == 1) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_block_light_value", new Object[]{blockLight}));
            } else if (showLightLevel == 2) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_sky_light_value", new Object[]{skyLight}));
            } else if (showLightLevel == 3) {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_all_light_value", new Object[]{Math.max(blockLight, skyLight)}));
            } else {
                compiler.addLine((ITextComponent)new TextComponentTranslation("gui.xaero_both_light_value", new Object[]{blockLight, skyLight}));
            }
        }
    }, ALL);
    public static final InfoDisplay<Integer> TIME = new InfoDisplay<Integer>("time", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_time", new Object[0]), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new ITextComponent[]{new TextComponentTranslation("gui.xaero_off", new Object[0]), new TextComponentTranslation("%s+%s", new Object[]{new TextComponentTranslation("gui.xaero_day", new Object[0]), new TextComponentTranslation("gui.xaero_24h", new Object[0])}), new TextComponentTranslation("%s+%s", new Object[]{new TextComponentTranslation("gui.xaero_day", new Object[0]), new TextComponentTranslation("gui.xaero_12h", new Object[0])}), new TextComponentTranslation("gui.xaero_24h", new Object[0]), new TextComponentTranslation("gui.xaero_12h", new Object[0])})), new InfoDisplayOnCompile<Integer>(){

        @Override
        public void onCompile(InfoDisplay<Integer> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            int showTime = displayInfo.getState();
            if (showTime <= 0) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            long totalTime = 6000L + mc.field_71441_e.func_72820_D();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((showTime - 1) % 2 == 0) {
                if (showTime < 3) {
                    compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
                } else {
                    compiler.addWords(size, String.format("%02d:%02d", timeHours, minutes));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (showTime < 3) {
                    compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
                } else {
                    compiler.addWords(size, String.format("%02d:%02d %s", timeHours, minutes, half));
                }
            }
        }
    }, ALL);
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final InfoDisplay<Integer> REAL_TIME = new InfoDisplay<Integer>("real_time", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_real_time", new Object[0]), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2}), Lists.newArrayList((Object[])new ITextComponent[]{new TextComponentTranslation("gui.xaero_off", new Object[0]), new TextComponentTranslation("gui.xaero_24h", new Object[0]), new TextComponentTranslation("gui.xaero_12h", new Object[0])})), new InfoDisplayOnCompile<Integer>(){

        @Override
        public void onCompile(InfoDisplay<Integer> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            int showTime = displayInfo.getState();
            if (showTime <= 0) {
                return;
            }
            CALENDAR.setTimeInMillis(System.currentTimeMillis());
            int timeHours = CALENDAR.get(11);
            int minutes = CALENDAR.get(12);
            if (showTime == 1) {
                compiler.addWords(size, String.format("%02d:%02d IRL", timeHours, minutes));
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                compiler.addWords(size, String.format("%02d:%02d %s IRL", timeHours, minutes, half));
            }
        }
    }, ALL);
    public static final InfoDisplay<Boolean> HIGHLIGHTS = new InfoDisplay<Boolean>("highlights", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_highlights", new Object[0]), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            if (processor.getMinimapWriter().getDimensionHighlightHandler() != null) {
                processor.getMinimapWriter().getDimensionHighlightHandler().addBlockHighlightTooltips(compiler, playerBlockX, playerBlockZ, size, true);
            }
        }
    }, ALL);
    public static final InfoDisplay<Boolean> LIGHT_OVERLAY_INDICATOR = new InfoDisplay<Boolean>("light_overlay_indicator", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_light_overlay_indicator", new Object[0]), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            if (session.getModMain().getSettings().lightOverlayType > 0) {
                compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
            }
        }
    }, ALL);
    public static final InfoDisplay<Boolean> MANUAL_CAVE_MODE_INDICATOR = new InfoDisplay<Boolean>("manual_cave_mode_indicator", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_manual_cave_mode_indicator", new Object[0]), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            if (processor.isManualCaveMode()) {
                compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_manual_cave_mode", (Object[])new Object[0]));
            }
        }
    }, ALL);
    public static final InfoDisplay<Boolean> CUSTOM_SUB_WORLD = new InfoDisplay<Boolean>("custom_sub_world", (ITextComponent)new TextComponentTranslation("gui.xaero_infodisplay_custom_sub_world", new Object[0]), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, new InfoDisplayOnCompile<Boolean>(){

        @Override
        public void onCompile(InfoDisplay<Boolean> displayInfo, InfoDisplayCompiler compiler, XaeroMinimapSession session, MinimapProcessor processor, int x, int y, int w, int h, double scale, int size, int playerBlockX, int playerBlockY, int playerBlockZ, BlockPos playerPos) {
            if (!displayInfo.getState().booleanValue()) {
                return;
            }
            WaypointsManager waypointsManager = session.getWaypointsManager();
            if (waypointsManager.getCurrentWorld() != null && waypointsManager.getAutoWorld() != waypointsManager.getCurrentWorld()) {
                compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_using_custom_subworld", (Object[])new Object[]{waypointsManager.getCurrentWorld().getContainer().getSubName()}));
            }
        }
    }, ALL);

    public static void addToManager(final InfoDisplayManager manager) {
        ALL.forEach(new Consumer<InfoDisplay<?>>(){

            @Override
            public void accept(InfoDisplay<?> id) {
                manager.add(id);
            }
        });
    }
}

