/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.element.render.map;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.element.render.MinimapElementReader;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.element.render.MinimapElementRendererHandler;
import xaero.common.minimap.render.MinimapRendererHelper;

public final class MinimapElementMapRendererHandler
extends MinimapElementRendererHandler {
    private float halfWView;

    protected MinimapElementMapRendererHandler(List<MinimapElementRenderer<?, ?>> renderers) {
        super(renderers, 0);
    }

    public void render(Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, double ps, double pc, double zoom, boolean cave, float partialTicks, Framebuffer framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, FontRenderer font, ScaledResolution scaledRes, float halfWView) {
        this.halfWView = halfWView;
        super.render(renderEntity, player, renderX, renderY, renderZ, ps, pc, zoom, cave, partialTicks, framebuffer, modMain, helper, font, scaledRes);
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(RR renderer, FontRenderer font, Framebuffer framebuffer, MinimapRendererHelper helper, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, double ps, double pc, double zoom, boolean cave, float partialTicks, int elementIndex, double optionalDepth, E element, MinimapElementReader<E, RRC> elementReader, RRC context, ScaledResolution scaledRes) {
        double offx = elementReader.getRenderX(element, context, partialTicks) - renderX;
        double offz = elementReader.getRenderZ(element, context, partialTicks) - renderZ;
        GlStateManager.func_179094_E();
        double zoomedOffX = offx * zoom;
        double zoomedOffZ = offz * zoom;
        double translateX = ps * zoomedOffX - pc * zoomedOffZ;
        double translateY = pc * zoomedOffX + ps * zoomedOffZ;
        int roundedX = (int)Math.round(translateX);
        int roundedY = (int)Math.round(translateY);
        boolean outOfBounds = (float)Math.abs(roundedX) > this.halfWView || Math.abs(renderY) > (double)this.halfWView;
        double partialX = translateX - (double)roundedX;
        double partialY = translateY - (double)roundedY;
        GlStateManager.func_179109_b((float)roundedX, (float)roundedY, (float)0.0f);
        boolean result = renderer.renderElement(this.location, false, outOfBounds, font, framebuffer, helper, renderEntity, player, renderX, renderY, renderZ, elementIndex, optionalDepth, 1.0f, element, partialX, partialY, cave, partialTicks, scaledRes);
        GlStateManager.func_179121_F();
        return result;
    }

    @Override
    protected int getIndexLimit() {
        return 19490;
    }

    @Override
    protected void beforeRender() {
    }

    @Override
    protected void afterRender() {
    }

    public static final class Builder
    extends MinimapElementRendererHandler.Builder {
        @Override
        public MinimapElementMapRendererHandler build() {
            return (MinimapElementMapRendererHandler)super.build();
        }

        @Override
        protected MinimapElementMapRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> renderers) {
            return new MinimapElementMapRendererHandler(renderers);
        }

        @Override
        protected Builder setDefault() {
            super.setDefault();
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

