/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.gui.dropdown.IDropDownWidgetCallback;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.InfoDisplayManager;
import xaero.common.settings.ModSettings;

public class GuiInfoDisplayEdit
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 30;
    private static final int FRAME_BOTTOM_SIZE = 61;
    private static final int SELECTION_ITEM_HEIGHT = 24;
    private static final TextComponentTranslation HELP_COMPONENT = new TextComponentTranslation("gui.xaero_minimap_info_display_manager_help", new Object[0]);
    private SelectionList selectionList;
    private final InfoDisplayManager manager;
    private List<String> currentOrder;
    private int selected;
    private final Map<String, MoveableEntry> moveableEntries;
    private ITextComponent title;
    private GuiButton doneButton;

    protected GuiInfoDisplayEdit(IXaeroMinimap modMain, GuiScreen parent, GuiScreen escape) {
        super(modMain, parent, escape);
        this.manager = modMain.getInterfaces().getMinimapInterface().getInfoDisplayManager();
        this.currentOrder = new ArrayList<String>();
        this.manager.getStream().forEach(new Consumer<InfoDisplay<?>>(){

            @Override
            public void accept(InfoDisplay<?> info) {
                GuiInfoDisplayEdit.this.currentOrder.add(info.getId());
            }
        });
        this.moveableEntries = new HashMap<String, MoveableEntry>();
        this.selected = -1;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.title = new TextComponentTranslation("gui.xaero_minimap_info_display_manager", new Object[0]);
        this.selectionList = new SelectionList();
        this.doneButton = new GuiButton(-1, this.field_146294_l / 2 - 100, this.field_146295_m - 34, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.func_189646_b(this.doneButton);
        this.moveableEntries.clear();
        for (String id : this.currentOrder) {
            InfoDisplay<?> infoDisplay = this.manager.get(id);
            MoveableEntry moveable = new MoveableEntry();
            this.addSubElements(moveable, infoDisplay);
            this.moveableEntries.put(id, moveable);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.doneButton) {
            this.goBack();
        }
    }

    public String[] createColorOptions(String symbol, boolean noneOption) {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (noneOption ? 1 : 0)];
        if (noneOption) {
            options[0] = "\u25a1\u25a1";
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (noneOption ? 1 : 0)] = "\u00a7" + ModSettings.ENCHANT_COLORS[i] + symbol;
        }
        return options;
    }

    private <T> void addSubElements(MoveableEntry moveable, final InfoDisplay<T> infoDisplay) {
        GuiButton stateWidget = infoDisplay.getWidgetFactory().create(this.field_146294_l / 2 + 150 - 102, 0, 100, 20, infoDisplay, this.modMain.getSettings());
        if (stateWidget != null) {
            moveable.addSubElement(stateWidget);
        }
        DropDownWidget textColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("Aa", false)).setX(this.field_146294_l / 2 - 147).setW(20).setSelected(infoDisplay.getTextColor() % ModSettings.ENCHANT_COLOR_NAMES.length).setContainer(this).setCallback(new IDropDownWidgetCallback(){

            @Override
            public boolean onSelected(DropDownWidget menu, int index) {
                infoDisplay.setTextColor(index);
                try {
                    GuiInfoDisplayEdit.this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }).setNarrationTitle(I18n.func_135052_a((String)"gui.xaero_dropdown_info_display_text_color", (Object[])new Object[0])).build();
        moveable.addSubElement(textColorWidget);
        int currentBackgroundIndex = infoDisplay.getBackgroundColor();
        DropDownWidget backgroundColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("\u25a0\u25a0", true)).setX(this.field_146294_l / 2 - 124).setW(20).setSelected(currentBackgroundIndex < 0 ? 0 : currentBackgroundIndex % ModSettings.ENCHANT_COLOR_NAMES.length + 1).setContainer(this).setCallback(new IDropDownWidgetCallback(){

            @Override
            public boolean onSelected(DropDownWidget menu, int index) {
                infoDisplay.setBackgroundColor(index - 1);
                try {
                    GuiInfoDisplayEdit.this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }).setNarrationTitle(I18n.func_135052_a((String)"gui.xaero_dropdown_info_display_background_color", (Object[])new Object[0])).build();
        moveable.addSubElement(backgroundColorWidget);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.handledMouseInput) {
            return;
        }
        if (this.selectionList != null) {
            this.selectionList.func_178039_p();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (this.handledMouseInput) {
            return;
        }
        if (this.selectionList != null && this.selectionList.mouseClicked(mouseX, mouseY, button)) {
            this.handledMouseInput = true;
            return;
        }
    }

    @Override
    protected void func_146286_b(int d, int e, int i) {
        if (this.selectionList != null) {
            this.selectionList.releaseDrag();
            if (this.selectionList.mouseReleased(d, e, i)) {
                this.handledMouseInput = true;
                return;
            }
        }
        if (this.handledMouseInput) {
            return;
        }
        super.func_146286_b(d, e, i);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.selectionList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title.func_150254_d(), this.field_146294_l / 2, 5, -1);
        this.func_73732_a(this.field_146289_q, HELP_COMPONENT.func_150254_d(), this.field_146294_l / 2, this.field_146295_m - 52, -1);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    class SelectionList
    extends GuiSlot {
        private List<Entry> entries;
        private boolean dragging;
        private int dragStartX;
        private int dragStartY;
        private int dragged;
        private int draggedOffsetX;
        private int draggedOffsetY;

        public SelectionList() {
            super(GuiInfoDisplayEdit.this.field_146297_k, GuiInfoDisplayEdit.this.field_146294_l, GuiInfoDisplayEdit.this.field_146295_m, 30, GuiInfoDisplayEdit.this.field_146295_m - 61, 24);
            this.entries = new ArrayList<Entry>();
            this.createEntries();
            if (GuiInfoDisplayEdit.this.selected != -1) {
                this.setSelected(GuiInfoDisplayEdit.this.selected);
            }
            this.dragged = -1;
        }

        private void addEntry(Entry entry) {
            this.entries.add(entry);
        }

        private Entry getEntry(int index) {
            if (index < 0 || index >= this.entries.size()) {
                return null;
            }
            return this.entries.get(index);
        }

        private Entry getSelected() {
            return this.getEntry(GuiInfoDisplayEdit.this.selected);
        }

        public void setSelected(int index) {
            Entry entry = this.getEntry(index);
            GuiInfoDisplayEdit.this.selected = entry == null ? -1 : entry.index;
        }

        private void createEntries() {
            for (int i = 0; i < GuiInfoDisplayEdit.this.manager.getCount(); ++i) {
                Entry entry = new Entry(i);
                this.addEntry(entry);
            }
        }

        private void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
        }

        protected int func_148137_d() {
            return this.field_148155_a / 2 + 164;
        }

        public int func_148139_c() {
            return 300;
        }

        public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
            super.func_148128_a(mouseXIn, mouseYIn, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                Entry draggedEntry = this.getEntry(this.dragged);
                draggedEntry.renderNonInteractable(this.field_148150_g + this.draggedOffsetX, this.field_148162_h + this.draggedOffsetY);
                Entry hoveredEntry = this.getEntry(this.func_148124_c(this.field_148150_g, this.field_148162_h));
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        GuiInfoDisplayEdit.this.currentOrder.set(i, GuiInfoDisplayEdit.this.currentOrder.get(i - slideDirection));
                    }
                    GuiInfoDisplayEdit.this.currentOrder.set(hoveredIndex, draggedId);
                    GuiInfoDisplayEdit.this.manager.setOrder(GuiInfoDisplayEdit.this.currentOrder);
                    this.dragged = hoveredIndex;
                    try {
                        GuiInfoDisplayEdit.this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.dragged != -1 && (Math.abs(this.field_148150_g - this.dragStartX) > 5 || Math.abs(this.field_148162_h - this.dragStartY) > 5)) {
                this.dragging = true;
                this.setSelected(-1);
            }
        }

        protected void func_192637_a(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
            this.getEntry(slotIndex).render(slotIndex, yPos, xPos, mouseXIn, mouseYIn, partialTicks);
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
            Entry e;
            int slotIndex;
            return this.func_148141_e(mouseY) && (slotIndex = this.func_148124_c(mouseX, mouseY)) >= 0 && slotIndex < this.entries.size() && (e = this.entries.get(slotIndex)).mouseClicked(mouseX, mouseY, mouseButton);
        }

        protected boolean func_148131_a(int slotIndex) {
            return GuiInfoDisplayEdit.this.selected == slotIndex;
        }

        protected void func_148123_a() {
            GuiInfoDisplayEdit.this.func_146276_q_();
        }

        public boolean mouseReleased(int d, int e, int i) {
            Entry entry = this.getEntry(this.func_148124_c(d, e));
            if (entry == null) {
                return false;
            }
            MoveableEntry moveableEntry = entry.getMoveable();
            for (GuiButton subElement : moveableEntry.subElements) {
                subElement.func_146118_a(d, e);
            }
            return false;
        }

        public boolean func_148125_i() {
            if (this.dragging) {
                return false;
            }
            return super.func_148125_i();
        }

        public class Entry {
            private final int index;
            private int lastRenderX;
            private int lastRenderY;

            public Entry(int index) {
                this.index = index;
            }

            private void renderNonInteractable(int x, int y) {
                String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                GuiInfoDisplayEdit.this.func_73731_b(GuiInfoDisplayEdit.this.field_146289_q, infoDisplay.getName().func_150254_d(), x + 48, y + 6, -1);
            }

            private MoveableEntry getMoveable() {
                String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                return (MoveableEntry)GuiInfoDisplayEdit.this.moveableEntries.get(infoDisplayId);
            }

            public void render(int index, int y, int x, int mouseX, int mouseY, float partialTicks) {
                this.lastRenderX = x;
                this.lastRenderY = y;
                if (SelectionList.this.dragging && SelectionList.this.dragged == index) {
                    return;
                }
                this.renderNonInteractable(x, y);
                MoveableEntry moveableEntry = this.getMoveable();
                for (GuiButton subElement : moveableEntry.subElements) {
                    subElement.field_146129_i = y - 2 + 12 - subElement.field_146121_g / 2;
                    if (subElement instanceof DropDownWidget) {
                        --subElement.field_146129_i;
                    }
                    subElement.func_191745_a(SelectionList.this.field_148161_k, mouseX, mouseY, partialTicks);
                }
            }

            public boolean mouseClicked(double d, double e, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (GuiButton subElement : moveableEntry.subElements) {
                    if (!subElement.func_146115_a() || !subElement.func_146116_c(SelectionList.this.field_148161_k, (int)d, (int)e)) continue;
                    subElement.func_146113_a(SelectionList.this.field_148161_k.func_147118_V());
                    return true;
                }
                if (i == 0) {
                    SelectionList.this.setSelected(this.index);
                    SelectionList.this.dragging = false;
                    SelectionList.this.dragged = this.index;
                    SelectionList.this.draggedOffsetX = (int)((double)this.lastRenderX - d);
                    SelectionList.this.draggedOffsetY = (int)((double)this.lastRenderY - e);
                    SelectionList.this.dragStartX = (int)d;
                    SelectionList.this.dragStartY = (int)e;
                } else {
                    SelectionList.this.setSelected(-1);
                }
                return false;
            }

            public boolean mouseReleased(int d, int e, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (GuiButton subElement : moveableEntry.subElements) {
                    subElement.func_146118_a(d, e);
                }
                return false;
            }
        }
    }

    class MoveableEntry {
        private final List<GuiButton> subElements = new ArrayList<GuiButton>();

        public void addSubElement(GuiButton widget) {
            this.subElements.add(widget);
        }
    }
}

