/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.client.Client;
import ht.treechop.client.gui.screen.ClientSettingsScreen;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="treechop", value={Side.CLIENT})
public class KeyBindings {
    public static final String CATEGORY = "HT's TreeChop";
    public static ActionableKeyBinding toggleChopping;
    public static List<ActionableKeyBinding> allKeyBindings;

    public static void init() {
        KeyBindings.registerKeyBinding("toggle_chopping", KeyBindings.getKey(0), Client::toggleChopping);
        KeyBindings.registerKeyBinding("toggle_felling", KeyBindings.getKey(0), Client::toggleFelling);
        KeyBindings.registerKeyBinding("cycle_sneak_behavior", KeyBindings.getKey(0), Client::cycleSneakBehavior);
        KeyBindings.registerKeyBinding("open_settings_overlay", KeyBindings.getKey(49), Client::toggleSettingsOverlay);
    }

    private static ActionableKeyBinding registerKeyBinding(String name, int defaultKey, Runnable callback) {
        ActionableKeyBinding keyBinding = new ActionableKeyBinding(String.format("%s.key.%s", "treechop", name), defaultKey, callback);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        allKeyBindings.add(keyBinding);
        return keyBinding;
    }

    static int getKey(int key) {
        return key;
    }

    @SubscribeEvent
    public static void buttonPressed(InputEvent.KeyInputEvent event) {
        if (!event.isCanceled()) {
            KeyBindings.buttonPressed();
        }
    }

    public static void buttonPressed() {
        if (Minecraft.func_71410_x().field_71441_e == null || !Keyboard.getEventKeyState() || Keyboard.isRepeatEvent() || Keyboard.getEventKey() == 0) {
            return;
        }
        for (ActionableKeyBinding keyBinding : allKeyBindings) {
            if (Keyboard.getEventKey() != keyBinding.func_151463_i()) continue;
            keyBinding.onPress();
            return;
        }
    }

    static {
        allKeyBindings = new LinkedList<ActionableKeyBinding>();
    }

    private static class ActionableKeyBinding
    extends KeyBinding {
        private final Runnable callback = () -> {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen == null || screen instanceof ClientSettingsScreen) {
                callback.run();
            }
        };

        public ActionableKeyBinding(String resourceName, int inputByCode, Runnable callback) {
            super(resourceName, (IKeyConflictContext)KeyConflictContext.GUI, inputByCode, KeyBindings.CATEGORY);
        }

        public void onPress() {
            this.callback.run();
        }
    }
}

