/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.frame;

import net.machinemuse.numina.client.gui.IDrawable;
import net.machinemuse.numina.client.gui.frame.IGuiFrame;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.numina.common.math.MuseMathUtils;
import org.lwjgl.opengl.GL11;

public interface IScrollable
extends IGuiFrame {
    public void setTotalSize(int var1);

    public int getButtonSize();

    public void setButtonSize(int var1);

    public int getTotalSize();

    public double getCurrentScrollPixels();

    public void setCurrentScrollPixels(double var1);

    default public double getMaxScrollPixels() {
        return Math.max((double)this.getTotalSize() - this.height(), 0.0);
    }

    default public double getScrollAmount() {
        return 8.0;
    }

    default public void setScrollAmount(double scrollAmount) {
        this.setCurrentScrollPixels((int)MuseMathUtils.clampDouble(scrollAmount, 0.0, this.getMaxScrollPixels()));
    }

    @Override
    default public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.containsPoint(mouseX, mouseY)) {
            this.setCurrentScrollPixels(MuseMathUtils.clampDouble(this.getCurrentScrollPixels() - dWheel * this.getScrollAmount(), 0.0, this.getMaxScrollPixels()));
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseClicked(double x, double y, int button) {
        if (this.isVisible() && this.containsPoint(x, y) && button == 0) {
            double dscroll = 0.0;
            if (y - this.top() < (double)this.getButtonSize() && this.getCurrentScrollPixels() > 0.0) {
                dscroll -= this.getScrollAmount();
            } else if (this.bottom() - y < (double)this.getButtonSize()) {
                dscroll += this.getScrollAmount();
            }
            if (dscroll != 0.0) {
                this.setCurrentScrollPixels(MuseMathUtils.clampDouble(this.getCurrentScrollPixels() + dscroll, 0.0, this.getMaxScrollPixels()));
            }
            return true;
        }
        return false;
    }

    default public void preRender(double mouseX, double mouseY, float partialTicks) {
        if (this.getRect() instanceof IDrawable) {
            ((IDrawable)this.getRect()).render(mouseX, mouseY, partialTicks);
        }
        RenderState.glowOn();
        RenderState.texturelessOn();
        GL11.glBegin((int)4);
        Colour.LIGHTBLUE.doGL();
        this.setCurrentScrollPixels(Math.min(this.getCurrentScrollPixels(), this.getMaxScrollPixels()));
        if (this.getCurrentScrollPixels() + this.height() < (double)this.getTotalSize()) {
            GL11.glVertex3d((double)(this.left() + this.width() / 2.0), (double)this.bottom(), (double)1.0);
            GL11.glVertex3d((double)(this.left() + this.width() / 2.0 + 2.0), (double)(this.bottom() - 4.0), (double)1.0);
            GL11.glVertex3d((double)(this.left() + this.width() / 2.0 - 2.0), (double)(this.bottom() - 4.0), (double)1.0);
        }
        if (this.getCurrentScrollPixels() > 0.0) {
            GL11.glVertex3d((double)(this.left() + this.width() / 2.0), (double)this.top(), (double)1.0);
            GL11.glVertex3d((double)(this.left() + this.width() / 2.0 - 2.0), (double)(this.top() + 4.0), (double)1.0);
            GL11.glVertex3d((double)(this.left() + this.width() / 2.0 + 2.0), (double)(this.top() + 4.0), (double)1.0);
        }
        Colour.WHITE.doGL();
        GL11.glEnd();
        RenderState.texturelessOff();
        RenderState.scissorsOn(this.left() + 4.0, this.top() + 4.0, this.width() - 8.0, this.height() - 8.0);
    }

    default public void postRender(double mouseX, double mouseY, float partialTicks) {
        if (this.isVisible()) {
            RenderState.scissorsOff();
            RenderState.glowOff();
        }
    }
}

