/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.worldgen;

import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import pegbeard.dungeontactics.handlers.DTWorldGen;

public class DTTemplates
extends WorldGenerator {
    private int minYLevel = 1;
    private boolean isVoid = false;
    private static final ResourceLocation WAGGON = new ResourceLocation("dungeontactics", "travellers_waggon");
    private static final ResourceLocation MINIBUNKER = new ResourceLocation("dungeontactics", "minibunker");
    private static final ResourceLocation SHIP = new ResourceLocation("dungeontactics", "pirateship");
    private static final ResourceLocation TOWER = new ResourceLocation("dungeontactics", "wizardtower");

    public boolean func_180709_b(World world, Random rand, BlockPos start) {
        DTWorldGen.printLocation("Attempting", "Ship", start);
        if (world.func_180495_p(start.func_177977_b()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(start.func_177977_b()).func_177230_c() == Blocks.field_150432_aD) {
            Random random = world.func_175726_f(start).func_76617_a(987234911L);
            MinecraftServer minecraftserver = world.func_73046_m();
            Rotation[] arotation = Rotation.values();
            Rotation rotation = arotation[random.nextInt(arotation.length)];
            TemplateManager templatemanager = world.func_72860_G().func_186340_h();
            Template template = templatemanager.func_186237_a(minecraftserver, SHIP);
            ChunkPos chunkpos = new ChunkPos(start);
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(chunkpos.func_180334_c() - 8, 0, chunkpos.func_180333_d() - 8, chunkpos.func_180332_e() + 8, world.func_72800_K(), chunkpos.func_180330_f() + 8);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
            DTWorldGen.printLocation("Complete", "Ship", start);
            if (rotation == Rotation.NONE) {
                template.func_189962_a(world, start.func_177982_a(-14, -3, -5), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.CLOCKWISE_90) {
                template.func_189962_a(world, start.func_177982_a(5, -3, -14), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                template.func_189962_a(world, start.func_177982_a(14, -3, 5), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                template.func_189962_a(world, start.func_177982_a(-5, -3, 14), placementsettings, 20);
                return true;
            }
        }
        DTWorldGen.printLocation("Failed", "Ship", start);
        return false;
    }

    public boolean generateTower(World world, Random rand, BlockPos start) {
        this.isVoid = world.field_73011_w.getBiomeForCoords(start) == Biomes.field_185440_P;
        start = DTWorldGen.settle(world, start, this.minYLevel, this.isVoid);
        DTWorldGen.printLocation("Attempting", "Wizard Tower", start);
        if (!(world.func_180495_p(start.func_177977_b()).func_177230_c() instanceof BlockLiquid)) {
            Random random = world.func_175726_f(start).func_76617_a(987234911L);
            MinecraftServer minecraftserver = world.func_73046_m();
            Rotation[] arotation = Rotation.values();
            Rotation rotation = arotation[random.nextInt(arotation.length)];
            TemplateManager templatemanager = world.func_72860_G().func_186340_h();
            Template template = templatemanager.func_186237_a(minecraftserver, TOWER);
            ChunkPos chunkpos = new ChunkPos(start);
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(chunkpos.func_180334_c(), 0, chunkpos.func_180333_d(), chunkpos.func_180332_e(), world.func_72800_K(), chunkpos.func_180330_f());
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
            DTWorldGen.printLocation("Completed", "Wizard Tower", start);
            if (rotation == Rotation.NONE) {
                template.func_189962_a(world, start.func_177982_a(-8, -1, -8), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.CLOCKWISE_90) {
                template.func_189962_a(world, start.func_177982_a(7, -1, -8), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                template.func_189962_a(world, start.func_177982_a(7, -1, 7), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                template.func_189962_a(world, start.func_177982_a(-8, -1, 7), placementsettings, 20);
                return true;
            }
        }
        DTWorldGen.printLocation("Failed", "Wizard Tower", start);
        return false;
    }

    public boolean generateWaggon(World world, Random rand, BlockPos start) {
        this.isVoid = world.field_73011_w.getBiomeForCoords(start) == Biomes.field_185440_P;
        start = DTWorldGen.settle(world, start, this.minYLevel, this.isVoid);
        DTWorldGen.printLocation("Attempting", "Waggon", start);
        if (!(world.func_180495_p(start.func_177977_b()).func_177230_c() instanceof BlockLiquid)) {
            Random random = world.func_175726_f(start).func_76617_a(987234911L);
            MinecraftServer minecraftserver = world.func_73046_m();
            Rotation[] arotation = Rotation.values();
            Rotation rotation = arotation[random.nextInt(arotation.length)];
            TemplateManager templatemanager = world.func_72860_G().func_186340_h();
            Template template = templatemanager.func_186237_a(minecraftserver, WAGGON);
            ChunkPos chunkpos = new ChunkPos(start);
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(chunkpos.func_180334_c(), 0, chunkpos.func_180333_d(), chunkpos.func_180332_e(), world.func_72800_K(), chunkpos.func_180330_f());
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
            DTWorldGen.printLocation("Completed", "Waggon", start);
            if (rotation == Rotation.NONE) {
                template.func_189962_a(world, start.func_177982_a(-5, 1, -3), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.CLOCKWISE_90) {
                template.func_189962_a(world, start.func_177982_a(3, 1, -5), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                template.func_189962_a(world, start.func_177982_a(5, 1, 3), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                template.func_189962_a(world, start.func_177982_a(-3, 1, 5), placementsettings, 20);
                return true;
            }
        }
        DTWorldGen.printLocation("Failed", "Waggon", start);
        return false;
    }

    public boolean generateMiniBunker(World world, Random rand, BlockPos start) {
        this.isVoid = world.field_73011_w.getBiomeForCoords(start) == Biomes.field_185440_P;
        start = DTWorldGen.settle(world, start, this.minYLevel, this.isVoid);
        DTWorldGen.printLocation("Attempting", "Mini Bunker", start);
        if (!(world.func_180495_p(start.func_177977_b()).func_177230_c() instanceof BlockLiquid)) {
            Random random = world.func_175726_f(start).func_76617_a(987234911L);
            MinecraftServer minecraftserver = world.func_73046_m();
            Rotation[] arotation = Rotation.values();
            Rotation rotation = arotation[random.nextInt(arotation.length)];
            TemplateManager templatemanager = world.func_72860_G().func_186340_h();
            Template template = templatemanager.func_186237_a(minecraftserver, MINIBUNKER);
            ChunkPos chunkpos = new ChunkPos(start);
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(chunkpos.func_180334_c(), 0, chunkpos.func_180333_d(), chunkpos.func_180332_e(), world.func_72800_K(), chunkpos.func_180330_f());
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
            DTWorldGen.printLocation("Completed", "Mini Bunker", start);
            if (rotation == Rotation.NONE) {
                template.func_189962_a(world, start.func_177982_a(-5, -6, -3), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.CLOCKWISE_90) {
                template.func_189962_a(world, start.func_177982_a(3, -6, -5), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                template.func_189962_a(world, start.func_177982_a(5, -6, 3), placementsettings, 20);
                return true;
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                template.func_189962_a(world, start.func_177982_a(-3, -6, 5), placementsettings, 20);
                return true;
            }
        }
        DTWorldGen.printLocation("Failed", "Mini Bunker", start);
        return false;
    }
}

