/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.DTLogHelper;
import pegbeard.dungeontactics.handlers.dispenserbehavior.DTDispenseAutomation;
import pegbeard.dungeontactics.handlers.dispenserbehavior.DTDispenseBlocks;
import pegbeard.dungeontactics.handlers.dispenserbehavior.DTDispenseMelee;
import pegbeard.dungeontactics.handlers.dispenserbehavior.DTDispensePowderKeg;
import pegbeard.dungeontactics.handlers.dispenserbehavior.DTDispenseThrowable;
import pegbeard.dungeontactics.handlers.dispenserbehavior.DTDispenseTunneler;

public class DTDispenserBehaviours {
    public static void Init() {
        if (DTConfigHandler.configuration.get("1-Feature", "Dispensers use some tools", true).getBoolean(true)) {
            DTDispenserBehaviours.add(Item.func_150898_a((Block)DTBlocks.POWDERKEG), new DTDispensePowderKeg());
            DTDispenserBehaviours.add(Items.field_151129_at, new DTDispenseAutomation());
            DTDispenserBehaviours.add(Items.field_151131_as, new DTDispenseAutomation());
            DTDispenserBehaviours.add(Items.field_151133_ar, new DTDispenseAutomation());
            DTDispenserBehaviours.add(Items.field_151054_z, new DTDispenseAutomation());
            DTDispenserBehaviours.add((Item)Items.field_151097_aZ, new DTDispenseAutomation());
            DTDispenserBehaviours.add(DTItems.FIRESTARTER, new DTDispenseAutomation());
            DTDispenserBehaviours.add(DTItems.TUNNELER, new DTDispenseTunneler());
            DTDispenserBehaviours.searchSpoons(new DTDispenseAutomation());
        }
        if (DTConfigHandler.configuration.get("1-Feature", "Dispensers use weapons", true).getBoolean(true)) {
            DTDispenserBehaviours.add(DTItems.THROWINGKNIFE, new DTDispenseThrowable());
            DTDispenserBehaviours.add(DTItems.SLOWNESSKNIFE, new DTDispenseThrowable());
            DTDispenserBehaviours.add(DTItems.WEAKNESSKNIFE, new DTDispenseThrowable());
            DTDispenserBehaviours.add(DTItems.POISONKNIFE, new DTDispenseThrowable());
            DTDispenserBehaviours.add(DTItems.CAUSTICKNIFE, new DTDispenseThrowable());
            DTDispenserBehaviours.add(DTItems.BOMB_FRAG, new DTDispenseThrowable(false, false, false, false));
            DTDispenserBehaviours.add(DTItems.BOMB_FRAG_CLUSTER, new DTDispenseThrowable(true, false, false, false));
            DTDispenserBehaviours.add(DTItems.BOMB_PYRO, new DTDispenseThrowable(false, true, false, false));
            DTDispenserBehaviours.add(DTItems.BOMB_PYRO_CLUSTER, new DTDispenseThrowable(true, true, false, false));
            DTDispenserBehaviours.add(DTItems.BOMB_PORTING, new DTDispenseThrowable(false, false, true, false));
            DTDispenserBehaviours.add(DTItems.BOMB_PORTING_CLUSTER, new DTDispenseThrowable(true, false, true, false));
            DTDispenserBehaviours.add(DTItems.BOMB_CRYO, new DTDispenseThrowable(false, false, false, true));
            DTDispenserBehaviours.add(DTItems.BOMB_CRYO_CLUSTER, new DTDispenseThrowable(true, false, false, true));
            DTDispenserBehaviours.searchSwords(new DTDispenseMelee());
        }
        if (DTConfigHandler.configuration.get("1-Feature", "Dispensers place blocks", true).getBoolean(true)) {
            DTDispenserBehaviours.searchBlocks();
        }
    }

    public static void searchBlocks() {
        for (ResourceLocation r : Block.field_149771_c.func_148742_b()) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)r);
            Item item = Item.func_150898_a((Block)block);
            if (block == null || item == null || !(item instanceof ItemBlock) || BlockDispenser.field_149943_a.func_148741_d((Object)item)) continue;
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)new DTDispenseBlocks((ItemBlock)item, block));
        }
    }

    public static void searchSwords(IBehaviorDispenseItem behaviour) {
        for (Item item : ForgeRegistries.ITEMS) {
            if (item == null || !(item instanceof ItemSword)) continue;
            try {
                DTDispenserBehaviours.add(item, behaviour);
            }
            catch (Exception e) {
                DTLogHelper.logInfo("Couldn't add %s to weapon registry", item.getRegistryName());
            }
        }
    }

    public static void searchSpoons(IBehaviorDispenseItem behaviour) {
        for (Item item : ForgeRegistries.ITEMS) {
            if (item == null || !(item instanceof ItemSpade)) continue;
            try {
                DTDispenserBehaviours.add(item, behaviour);
            }
            catch (Exception e) {
                DTLogHelper.logInfo("Couldn't add %s to weapon registry", item.getRegistryName());
            }
        }
    }

    public static void add(Item item, IBehaviorDispenseItem behaviour) {
        BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)behaviour);
    }
}

