/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import vazkii.botania.api.lexicon.multiblock.IMultiblockRenderHook;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MultiblockRenderHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.model.ModelPylonGaia;
import vazkii.botania.client.model.ModelPylonMana;
import vazkii.botania.client.model.ModelPylonNatura;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TilePylon;

public class RenderTilePylon
extends TileEntitySpecialRenderer<TilePylon>
implements IMultiblockRenderHook {
    private static final ResourceLocation MANA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_mana.png");
    private static final ResourceLocation NATURA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_natura.png");
    private static final ResourceLocation GAIA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_gaia.png");
    private final ModelPylonMana manaModel = new ModelPylonMana();
    private final ModelPylonNatura naturaModel = new ModelPylonNatura();
    private final ModelPylonGaia gaiaModel = new ModelPylonGaia();
    private static PylonVariant forceVariant = PylonVariant.MANA;

    public void render(@Nonnull TilePylon pylon, double d0, double d1, double d2, float pticks, int digProgress, float unused) {
        boolean renderingItem;
        boolean bl = renderingItem = pylon == ForwardingTEISR.DUMMY;
        if (!(renderingItem || pylon.func_145831_w().func_175668_a(pylon.func_174877_v(), false) && pylon.func_145831_w().func_180495_p(pylon.func_174877_v()).func_177230_c() == ModBlocks.pylon)) {
            return;
        }
        this.renderPylon(pylon, d0, d1, d2, pticks, renderingItem);
    }

    private void renderPylon(@Nonnull TilePylon pylon, double d0, double d1, double d2, float pticks, boolean renderingItem) {
        ModelBase model;
        PylonVariant type = renderingItem ? forceVariant : (PylonVariant)((Object)ModBlocks.pylon.func_176203_a(pylon.func_145832_p()).func_177229_b(BotaniaStateProps.PYLON_VARIANT));
        switch (type) {
            default: {
                model = this.manaModel;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(MANA_TEXTURE);
                break;
            }
            case NATURA: {
                model = this.naturaModel;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(NATURA_TEXTURE);
                break;
            }
            case GAIA: {
                model = this.gaiaModel;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(GAIA_TEXTURE);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        float a = MultiblockRenderHandler.rendering ? 0.6f : 1.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        double worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += renderingItem ? 0.0 : (double)new Random(pylon.func_174877_v().hashCode()).nextInt(360);
        GlStateManager.func_179137_b((double)d0, (double)(d1 + (renderingItem ? 1.35 : 1.5)), (double)d2);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)-0.5f);
        if (!renderingItem) {
            GlStateManager.func_179114_b((float)((float)worldTime * 1.5f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        model.renderRing();
        if (!renderingItem) {
            GlStateManager.func_179137_b((double)0.0, (double)(Math.sin(worldTime / 20.0) / 20.0 - 0.025), (double)0.0);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        if (!renderingItem) {
            GlStateManager.func_179137_b((double)0.0, (double)(Math.sin(worldTime / 20.0) / 17.5), (double)0.0);
        }
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)-0.5f);
        if (!renderingItem) {
            GlStateManager.func_179114_b((float)((float)(-worldTime)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179118_c();
        if (!renderingItem) {
            ShaderHelper.useShader(ShaderHelper.pylonGlow);
        }
        model.renderCrystal();
        if (!renderingItem) {
            ShaderHelper.releaseShader();
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179091_B();
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderBlockForMultiblock(IBlockAccess world, Multiblock mb, IBlockState state, MultiblockComponent comp) {
        forceVariant = (PylonVariant)((Object)state.func_177229_b(BotaniaStateProps.PYLON_VARIANT));
        GlStateManager.func_179137_b((double)-0.5, (double)-0.25, (double)-0.5);
        this.renderPylon((TilePylon)comp.getTileEntity(), 0.0, 0.0, 0.0, 0.0f, true);
        forceVariant = PylonVariant.MANA;
    }

    @Override
    public boolean needsTranslate(IBlockState state) {
        return true;
    }

    public static class ForwardingTEISR
    extends TileEntityItemStackRenderer {
        private static final TilePylon DUMMY = new TilePylon();
        private final TileEntityItemStackRenderer compose;

        public ForwardingTEISR(TileEntityItemStackRenderer compose) {
            this.compose = compose;
        }

        public void func_192838_a(ItemStack stack, float partialTicks) {
            if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.pylon)) {
                forceVariant = PylonVariant.values()[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)PylonVariant.values().length)];
                TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)DUMMY, 0.0, 0.0, 0.0, partialTicks);
            } else {
                this.compose.func_192838_a(stack, partialTicks);
            }
        }
    }
}

