/*
 * Decompiled with CFR 0.152.
 */
package io.dogboy.serializationisbad.core;

import io.dogboy.serializationisbad.core.ClassFilteringObjectInputStream;
import io.dogboy.serializationisbad.core.SerializationIsBad;
import io.dogboy.serializationisbad.core.config.PatchModule;
import io.dogboy.serializationisbad.shadow.asm.ClassReader;
import io.dogboy.serializationisbad.shadow.asm.ClassWriter;
import io.dogboy.serializationisbad.shadow.asm.tree.AbstractInsnNode;
import io.dogboy.serializationisbad.shadow.asm.tree.ClassNode;
import io.dogboy.serializationisbad.shadow.asm.tree.InsnList;
import io.dogboy.serializationisbad.shadow.asm.tree.LdcInsnNode;
import io.dogboy.serializationisbad.shadow.asm.tree.MethodInsnNode;
import io.dogboy.serializationisbad.shadow.asm.tree.MethodNode;
import io.dogboy.serializationisbad.shadow.asm.tree.TypeInsnNode;
import io.dogboy.serializationisbad.shadow.asm.tree.VarInsnNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class Patches {
    public static PatchModule getPatchModuleForClass(String className) {
        for (PatchModule patchModule : SerializationIsBad.getInstance().getConfig().getPatchModules()) {
            if (!patchModule.getClassesToPatch().contains(className) && !patchModule.getCustomOISClasses().contains(className)) continue;
            return patchModule;
        }
        return null;
    }

    private static ClassNode readClassNode(byte[] classBytecode) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytecode);
        classReader.accept(classNode, 0);
        return classNode;
    }

    private static byte[] writeClassNode(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(1);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    private static void applyPatches(String className, ClassNode classNode, boolean passClassLoader) {
        SerializationIsBad.logger.info("Applying patches to " + className);
        PatchModule patchModule = Patches.getPatchModuleForClass(className);
        if (patchModule == null) {
            SerializationIsBad.logger.info("  No patches to apply");
            return;
        }
        if (patchModule.getCustomOISClasses().contains(className) && "java/io/ObjectInputStream".equals(classNode.superName)) {
            for (MethodNode methodNode : classNode.methods) {
                if (!"resolveClass".equals(methodNode.name)) continue;
                InsnList additionalInstructions = new InsnList();
                additionalInstructions.add(new VarInsnNode(25, 1));
                additionalInstructions.add(new LdcInsnNode(className));
                additionalInstructions.add(new MethodInsnNode(184, "io/dogboy/serializationisbad/core/Patches", "getPatchModuleForClass", "(Ljava/lang/String;)Lio/dogboy/serializationisbad/core/config/PatchModule;", false));
                additionalInstructions.add(new MethodInsnNode(184, "io/dogboy/serializationisbad/core/ClassFilteringObjectInputStream", "resolveClassPrecheck", "(Ljava/io/ObjectStreamClass;Lio/dogboy/serializationisbad/core/config/PatchModule;)V", false));
                methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), additionalInstructions);
                SerializationIsBad.logger.info("  Injecting resolveClass precheck in method " + methodNode.name);
                break;
            }
            return;
        }
        for (MethodNode methodNode : classNode.methods) {
            InsnList instructions = methodNode.instructions;
            for (int i = 0; i < instructions.size(); ++i) {
                InsnList additionalInstructions;
                AbstractInsnNode instruction = instructions.get(i);
                if (instruction.getOpcode() == 187 && instruction instanceof TypeInsnNode && "java/io/ObjectInputStream".equals(((TypeInsnNode)instruction).desc)) {
                    ((TypeInsnNode)instruction).desc = "io/dogboy/serializationisbad/core/ClassFilteringObjectInputStream";
                    SerializationIsBad.logger.info("  (1/2) Redirecting ObjectInputStream to ClassFilteringObjectInputStream in method " + methodNode.name);
                    continue;
                }
                if (instruction.getOpcode() == 183 && instruction instanceof MethodInsnNode && "java/io/ObjectInputStream".equals(((MethodInsnNode)instruction).owner) && "<init>".equals(((MethodInsnNode)instruction).name)) {
                    ((MethodInsnNode)instruction).owner = "io/dogboy/serializationisbad/core/ClassFilteringObjectInputStream";
                    ((MethodInsnNode)instruction).desc = "(Ljava/io/InputStream;Lio/dogboy/serializationisbad/core/config/PatchModule;)V";
                    if (passClassLoader) {
                        ((MethodInsnNode)instruction).desc = "(Ljava/io/InputStream;Lio/dogboy/serializationisbad/core/config/PatchModule;Ljava/lang/ClassLoader;)V";
                    }
                    additionalInstructions = new InsnList();
                    additionalInstructions.add(new LdcInsnNode(className));
                    additionalInstructions.add(new MethodInsnNode(184, "io/dogboy/serializationisbad/core/Patches", "getPatchModuleForClass", "(Ljava/lang/String;)Lio/dogboy/serializationisbad/core/config/PatchModule;", false));
                    if (passClassLoader) {
                        additionalInstructions.add(new VarInsnNode(25, 0));
                        additionalInstructions.add(new MethodInsnNode(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false));
                        additionalInstructions.add(new MethodInsnNode(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;", false));
                    }
                    instructions.insertBefore(instruction, additionalInstructions);
                    SerializationIsBad.logger.info("  (2/2) Redirecting ObjectInputStream to ClassFilteringObjectInputStream in method " + methodNode.name);
                    continue;
                }
                if (instruction.getOpcode() != 184 || !(instruction instanceof MethodInsnNode) || !"org/apache/commons/lang3/SerializationUtils".equals(((MethodInsnNode)instruction).owner) || !"deserialize".equals(((MethodInsnNode)instruction).name)) continue;
                ((MethodInsnNode)instruction).owner = "io/dogboy/serializationisbad/core/Patches";
                if ("(Ljava/io/InputStream;)Ljava/lang/Object;".equals(((MethodInsnNode)instruction).desc)) {
                    ((MethodInsnNode)instruction).desc = "(Ljava/io/InputStream;Lio/dogboy/serializationisbad/core/config/PatchModule;)Ljava/lang/Object;";
                } else if ("([B)Ljava/lang/Object;".equals(((MethodInsnNode)instruction).desc)) {
                    ((MethodInsnNode)instruction).desc = "([BLio/dogboy/serializationisbad/core/config/PatchModule;)Ljava/lang/Object;";
                } else {
                    throw new RuntimeException("Unknown desc for SerializationUtils.deserialize: " + ((MethodInsnNode)instruction).desc);
                }
                additionalInstructions = new InsnList();
                additionalInstructions.add(new LdcInsnNode(className));
                additionalInstructions.add(new MethodInsnNode(184, "io/dogboy/serializationisbad/core/Patches", "getPatchModuleForClass", "(Ljava/lang/String;)Lio/dogboy/serializationisbad/core/config/PatchModule;", false));
                instructions.insertBefore(instruction, additionalInstructions);
                SerializationIsBad.logger.info("  Redirecting SerializationUtils.deserialize to Patches in method " + methodNode.name);
            }
        }
    }

    public static byte[] patchClass(byte[] classBytes, String className, boolean passClassLoader) {
        ClassNode classNode = Patches.readClassNode(classBytes);
        Patches.applyPatches(className, classNode, passClassLoader);
        return Patches.writeClassNode(classNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream, PatchModule patchModule) {
        try (ClassFilteringObjectInputStream objectInputStream = new ClassFilteringObjectInputStream(inputStream, patchModule);){
            Object object = objectInputStream.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserialize(byte[] objectData, PatchModule patchModule) {
        return Patches.deserialize(new ByteArrayInputStream(objectData), patchModule);
    }
}

