/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseTileBlock;
import appeng.helpers.ICustomCollision;
import appeng.tile.misc.TileSkyCompass;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;

public class BlockSkyCompass
extends AEBaseTileBlock
implements ICustomCollision {
    public static final PropertyFloat ROTATION = new PropertyFloat("rotation");

    public BlockSkyCompass() {
        super(Material.field_151594_q);
        this.func_149713_g(0);
        this.setFullSize(false);
        this.setOpaque(false);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, this.getAEStates(), new IUnlistedProperty[]{FORWARD, UP, ROTATION});
    }

    @Override
    public boolean isValidOrientation(World w, BlockPos pos, EnumFacing forward, EnumFacing up) {
        TileSkyCompass sc = (TileSkyCompass)this.getTileEntity((IBlockAccess)w, pos);
        if (sc != null) {
            return false;
        }
        return this.canPlaceAt(w, pos, forward.func_176734_d());
    }

    private boolean canPlaceAt(World w, BlockPos pos, EnumFacing dir) {
        return w.isSideSolid(pos.func_177972_a(dir), dir.func_176734_d(), false);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileSkyCompass sc = (TileSkyCompass)this.getTileEntity((IBlockAccess)world, pos);
        EnumFacing forward = sc.getForward();
        if (!this.canPlaceAt(world, pos, forward.func_176734_d())) {
            this.dropTorch(world, pos);
        }
    }

    private void dropTorch(World w, BlockPos pos) {
        IBlockState prev = w.func_180495_p(pos);
        w.func_175655_b(pos, true);
        w.func_184138_a(pos, prev, w.func_180495_p(pos), 3);
    }

    public boolean func_176196_c(World w, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.canPlaceAt(w, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, BlockPos pos, Entity thePlayer, boolean b) {
        TileSkyCompass tile = (TileSkyCompass)this.getTileEntity((IBlockAccess)w, pos);
        if (tile != null) {
            EnumFacing forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 1.0;
                    minY = 0.875;
                    break;
                }
                case EAST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 0.125;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 1.0;
                    minZ = 0.875;
                    break;
                }
                case SOUTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 0.125;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 0.125;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 1.0;
                    minX = 0.875;
                    break;
                }
            }
            return Collections.singletonList(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        }
        return Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public void addCollidingBlockToList(World w, BlockPos pos, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }
}

