/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnderCap;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IExternalConnectionContainer;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.IFilterContainer;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.filter.network.IOpenFilterRemoteExec;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.capability.CapabilityUpgradeHolder;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import crazypants.enderio.conduits.gui.InventoryUpgrades;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.network.PacketSlotVisibility;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ExternalConnectionContainer
extends ContainerEnderCap<InventoryUpgrades, TileConduitBundle>
implements IExternalConnectionContainer,
IOpenFilterRemoteExec.Container,
IFilterContainer {
    @Nonnull
    private final Slot slotFunctionUpgrade;
    @Nonnull
    private final Slot slotInputFilter;
    @Nonnull
    private final Slot slotOutputFilter;
    @Nonnull
    private final EnumFacing dir;
    @Nonnull
    private final EntityPlayer player;
    private IConduit currentCon;
    private int guiId = -1;

    public ExternalConnectionContainer(@Nonnull InventoryPlayer playerInv, @Nonnull EnumFacing dir, @Nonnull TileConduitBundle bundle) {
        super(playerInv, (IItemHandler)new InventoryUpgrades(dir), (TileEntity)bundle, true);
        this.dir = dir;
        this.player = playerInv.field_70458_d;
        this.slotInputFilter = new FilterSlot(this.getItemHandler(), 3, 23, 71);
        this.slotOutputFilter = new FilterSlot(this.getItemHandler(), 2, 113, 71);
        this.slotFunctionUpgrade = new SlotItemHandler(this.getItemHandler(), 0, 131, 71){

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return ((InventoryUpgrades)ExternalConnectionContainer.this.getItemHandler()).isItemValidForSlot(0, itemStack, ExternalConnectionContainer.this.currentCon);
            }

            public int func_75219_a() {
                return ((InventoryUpgrades)ExternalConnectionContainer.this.getItemHandler()).getSlotLimit(0);
            }

            public int func_178170_b(@Nonnull ItemStack stack) {
                return ((InventoryUpgrades)ExternalConnectionContainer.this.getItemHandler()).getSlotLimit(0, stack);
            }
        };
    }

    protected void addSlots() {
        this.func_75146_a(this.slotInputFilter);
        this.func_75146_a(this.slotOutputFilter);
        this.func_75146_a(this.slotFunctionUpgrade);
    }

    @Override
    public void createGhostSlots(@Nonnull NNList<GhostSlot> ghostSlots) {
        NNList filtersAll = new NNList((Object[])new ItemStack[]{new ItemStack(ModObject.itemBasicItemFilter.getItemNN())});
        NNList upgrades = new NNList((Object[])new ItemStack[]{new ItemStack(ConduitObject.item_extract_speed_upgrade.getItemNN()), new ItemStack(ConduitObject.item_extract_speed_downgrade.getItemNN())});
        this.createGhostSlots(ghostSlots, (NNList<ItemStack>)filtersAll, (NNList<ItemStack>)filtersAll, (NNList<ItemStack>)upgrades);
    }

    @Override
    public void createGhostSlots(@Nonnull NNList<GhostSlot> ghostSlots, @Nonnull NNList<ItemStack> filters, @Nonnull NNList<ItemStack> upgrades) {
        this.createGhostSlots(ghostSlots, filters, filters, upgrades);
    }

    @Override
    public void createGhostSlots(@Nonnull NNList<GhostSlot> ghostSlots, @Nonnull NNList<ItemStack> filtersIn, @Nonnull NNList<ItemStack> filtersOut, @Nonnull NNList<ItemStack> upgrades) {
        ghostSlots.add((Object)new GhostBackgroundItemSlot(filtersIn, this.slotInputFilter));
        ghostSlots.add((Object)new GhostBackgroundItemSlot(filtersOut, this.slotOutputFilter));
        ghostSlots.add((Object)new GhostBackgroundItemSlot(upgrades, this.slotFunctionUpgrade));
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(23, 113);
    }

    @Override
    public boolean hasFunctionUpgrade() {
        return this.slotFunctionUpgrade.func_75216_d();
    }

    @Override
    public boolean hasFilter(boolean input) {
        return (input ? this.slotInputFilter : this.slotOutputFilter).func_75216_d();
    }

    @Override
    public void setInOutSlotsVisible(boolean filterVisible, boolean upgradeVisible, @Nonnull IConduit conduit) {
        World world = ((TileConduitBundle)this.getTileEntityNN()).getBundleworld();
        boolean hasFilterHolder = false;
        boolean hasUpgradeHolder = false;
        this.currentCon = conduit;
        if (filterVisible || upgradeVisible) {
            hasFilterHolder = conduit.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir);
            hasUpgradeHolder = conduit.hasInternalCapability(CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY, this.dir);
            if (hasFilterHolder) {
                ((InventoryUpgrades)this.getItemHandler()).setFilterHolder(conduit.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir));
            }
            if (hasUpgradeHolder) {
                ((InventoryUpgrades)this.getItemHandler()).setUpgradeHolder(conduit.getInternalCapability(CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY, this.dir));
            }
        }
        this.setSlotsVisible(filterVisible && hasFilterHolder, upgradeVisible && hasUpgradeHolder);
        if (world.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSlotVisibility(conduit, filterVisible, upgradeVisible));
        }
    }

    private void setSlotsVisible(boolean filterVisible, boolean upgradeVisible) {
        Slot inFilter = this.func_75139_a(1);
        Slot outFilter = this.func_75139_a(0);
        Slot funcUpgrade = this.func_75139_a(2);
        if (filterVisible) {
            this.slotInputFilter.field_75223_e = ((Point)this.slotLocations.get((Object)this.slotInputFilter)).x;
            this.slotInputFilter.field_75221_f = ((Point)this.slotLocations.get((Object)this.slotInputFilter)).y;
            this.slotOutputFilter.field_75223_e = ((Point)this.slotLocations.get((Object)this.slotOutputFilter)).x;
            this.slotOutputFilter.field_75221_f = ((Point)this.slotLocations.get((Object)this.slotOutputFilter)).y;
            inFilter.field_75223_e = ((Point)this.slotLocations.get((Object)inFilter)).x;
            inFilter.field_75221_f = ((Point)this.slotLocations.get((Object)inFilter)).y;
            outFilter.field_75223_e = ((Point)this.slotLocations.get((Object)outFilter)).x;
            outFilter.field_75221_f = ((Point)this.slotLocations.get((Object)outFilter)).y;
        } else {
            this.slotInputFilter.field_75223_e = -3000;
            this.slotInputFilter.field_75221_f = -3000;
            this.slotOutputFilter.field_75223_e = -3000;
            this.slotOutputFilter.field_75221_f = -3000;
            inFilter.field_75223_e = -3000;
            inFilter.field_75221_f = -3000;
            outFilter.field_75223_e = -3000;
            outFilter.field_75221_f = -3000;
        }
        if (upgradeVisible) {
            this.slotFunctionUpgrade.field_75223_e = ((Point)this.slotLocations.get((Object)this.slotFunctionUpgrade)).x;
            this.slotFunctionUpgrade.field_75221_f = ((Point)this.slotLocations.get((Object)this.slotFunctionUpgrade)).y;
            funcUpgrade.field_75223_e = ((Point)this.slotLocations.get((Object)funcUpgrade)).x;
            funcUpgrade.field_75221_f = ((Point)this.slotLocations.get((Object)funcUpgrade)).y;
        } else {
            this.slotFunctionUpgrade.field_75223_e = -3000;
            this.slotFunctionUpgrade.field_75221_f = -3000;
            funcUpgrade.field_75223_e = -3000;
            funcUpgrade.field_75221_f = -3000;
        }
    }

    @Override
    public void setGuiID(int id) {
        this.guiId = id;
    }

    @Override
    public int getGuiID() {
        return this.guiId;
    }

    @Override
    public IMessage doOpenFilterGui(int filterIndex) {
        if (this.currentCon.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir)) {
            IFilterHolder filterHolder = this.currentCon.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir);
            int param1 = this.dir.ordinal();
            if (filterHolder != null) {
                filterHolder.getFilter(filterIndex, param1).openGui(this.player, filterHolder.getFilterStack(filterIndex, EnumFacing.func_82600_a((int)param1)), ((TileConduitBundle)this.getTileEntityNN()).getBundleworld(), ((TileConduitBundle)this.getTileEntityNN()).func_174877_v(), this.dir, filterIndex);
            }
        }
        return null;
    }

    @Nonnull
    public IFilter getFilter(int filterIndex) {
        if (this.currentCon.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir)) {
            IFilterHolder filterHolder = this.currentCon.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, this.dir);
            int param1 = this.dir.ordinal();
            if (filterHolder != null) {
                return filterHolder.getFilter(filterIndex, param1);
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public List<String> getFunctionUpgradeToolTipText() {
        return ((InventoryUpgrades)this.getItemHandler()).getFunctionUpgradeToolTipText();
    }

    private class FilterSlot
    extends SlotItemHandler {
        public FilterSlot(IItemHandler handler, int index, int x, int y) {
            super(handler, index, x, y);
        }

        public int func_75219_a() {
            return 1;
        }

        public int func_178170_b(@Nonnull ItemStack stack) {
            return Math.min(super.func_178170_b(stack), this.func_75219_a());
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return ((InventoryUpgrades)ExternalConnectionContainer.this.getItemHandler()).isItemValidForSlot(this.getSlotIndex(), stack, ExternalConnectionContainer.this.currentCon);
        }
    }
}

