/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class SaddleItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    protected ItemStack itemStack = ItemStack.field_190927_a;

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        ItemStack oldStack = this.itemStack;
        this.itemStack = stack;
        if (!oldStack.func_190926_b() || !stack.func_190926_b()) {
            this.onStackChanged();
        }
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.itemStack.func_190926_b()) {
            if (simulate) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
            }
            this.itemStack = stack.func_77979_a(1);
        }
        this.onStackChanged();
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.itemStack, (int)amount);
        }
        ItemStack outStack = this.itemStack.func_77979_a(amount);
        this.onStackChanged();
        return outStack;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public NBTTagCompound serializeNBT() {
        return this.itemStack.func_77955_b(new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.itemStack = new ItemStack(nbt);
        this.onStackChanged();
    }

    protected abstract void onStackChanged();
}

