/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus;

import java.io.File;
import net.darkhax.bookshelf.util.RegistryUtils;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.eplus.EnchantingPlus;
import net.darkhax.eplus.api.Blacklist;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public final class ConfigurationHandler {
    public static Configuration config;
    public static float costFactor;
    public static float treasureFactor;
    public static float curseFactor;
    public static int baseCost;
    public static float floatingBookBonus;
    private static String[] blacklistedItems;
    private static String[] blacklistedEnchantments;

    public static void initConfig(File configFile) {
        config = new Configuration(configFile);
        baseCost = config.getInt("baseCost", "general", 45, 1, 1024, "The base cost to use for the enchantment formula. ");
        costFactor = config.getFloat("costFactor", "general", 1.0f, 0.0f, 1024.0f, "A number used when calculated enchantment cost. This number is treated as a % based factor. 0.30 = 30% of the original cost. 1.5 = 150% of the original cost.");
        treasureFactor = config.getFloat("treasureFactor", "general", 4.0f, 0.0f, 1024.0f, "A factor used to make treasure enchantments like mending cost more to apply. By default they cost 4X more.");
        curseFactor = config.getFloat("curseFactor", "general", 3.0f, 0.0f, 1024.0f, "A factor used to make curse enchantments like vanishing cost more to apply. By default they cost 3X more.");
        floatingBookBonus = config.getFloat("floatingBookPower", "general", 1.0f, 0.0f, 1024.0f, "The amount of enchantment power a floating book should give. Bookshelfs have 1 power.");
        blacklistedItems = config.getStringList("blacklistedItems", "blacklist", new String[0], "A blacklist of items that can't be enchanted with this mod. Format is itemid#meta");
        blacklistedEnchantments = config.getStringList("blacklistedEnchantments", "blacklist", new String[0], "A blacklist of enchantments that are not available in E+. Format is just enchantmentid.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void buildBlacklist() {
        for (String itemString : blacklistedItems) {
            ItemStack stack = StackUtils.createStackFromString((String)itemString);
            if (stack != null && !stack.func_190926_b()) {
                Blacklist.blacklist(stack);
                continue;
            }
            EnchantingPlus.LOG.error("Tried to blacklist item {0} but it does not exist.", new Object[]{itemString});
        }
        for (String enchString : blacklistedEnchantments) {
            Enchantment ench = RegistryUtils.getEnchantment((String)enchString);
            if (ench != null) {
                Blacklist.blacklist(ench);
                continue;
            }
            EnchantingPlus.LOG.error("Tried to blacklist enchantment {} but it does not exist.", new Object[]{enchString});
        }
    }

    static {
        costFactor = 1.5f;
        treasureFactor = 4.0f;
        curseFactor = 3.0f;
        baseCost = 45;
        floatingBookBonus = 1.0f;
        blacklistedItems = new String[0];
        blacklistedEnchantments = new String[0];
    }
}

