/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.Slot;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyHandler {
    private final Map<KeyBinding, Action> keyBindingMap = Stream.of(Action.values()).map(a -> new AbstractMap.SimpleEntry<Action, 1>((Action)((Object)a), new KeyBinding(a.getKeyBindingName(), (IKeyConflictContext)KeyConflictContext.GUI, a.getDefaultKeyCode(), "keygroup.inventorysorter"){

        @Nonnull
        public String getDisplayName() {
            if (this.func_151463_i() == -200) {
                return I18n.func_135052_a((String)"key.inventorysorter.mousewheelup", (Object[])new Object[0]);
            }
            if (this.func_151463_i() == -201) {
                return I18n.func_135052_a((String)"key.inventorysorter.mousewheeldown", (Object[])new Object[0]);
            }
            return super.getDisplayName();
        }
    })).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));

    KeyHandler() {
        Minecraft.func_71410_x().field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])Minecraft.func_71410_x().field_71474_y.field_74324_K, (Object[])this.keyBindingMap.keySet().toArray(new KeyBinding[this.keyBindingMap.size()]));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKey(GuiScreenEvent.KeyboardInputEvent.Pre evt) {
        this.onInputEvent((GuiScreenEvent)evt, this::tryKeys);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouse(GuiScreenEvent.MouseInputEvent.Pre evt) {
        this.onInputEvent((GuiScreenEvent)evt, this::tryMouseButtons);
    }

    private void onInputEvent(GuiScreenEvent evt, Supplier<Action> actionSupplier) {
        GuiScreen gui = evt.getGui();
        if (!(gui instanceof GuiContainer) || gui instanceof GuiContainerCreative) {
            return;
        }
        GuiContainer guiContainer = (GuiContainer)gui;
        Slot slot = guiContainer.getSlotUnderMouse();
        if (!ContainerContext.validSlot(slot)) {
            InventorySorter.INSTANCE.log.log(Level.DEBUG, "Skipping action handling for blacklisted slot");
            return;
        }
        Action triggered = actionSupplier.get();
        if (triggered == null) {
            return;
        }
        if (triggered.isActive() && guiContainer.field_147002_h != null && guiContainer.field_147002_h.field_75151_b != null && guiContainer.field_147002_h.field_75151_b.contains(slot)) {
            InventorySorter.INSTANCE.log.log(Level.DEBUG, "Sending action {} slot {}", (Object)triggered, (Object)slot.field_75222_d);
            InventorySorter.INSTANCE.channel.sendToServer((IMessage)triggered.message(slot));
            evt.setCanceled(true);
        }
    }

    private Action tryMouseButtons() {
        int mouse = Mouse.getEventButton() - 100;
        if (mouse == -101) {
            int mwheel = Mouse.getDWheel();
            mouse = mwheel > 0 ? -201 : (mwheel < 0 ? -200 : -101);
        } else if (!Mouse.getEventButtonState()) {
            return null;
        }
        Action triggered = null;
        for (Map.Entry<KeyBinding, Action> entry : this.keyBindingMap.entrySet()) {
            if (!entry.getKey().isActiveAndMatches(mouse)) continue;
            triggered = entry.getValue();
            break;
        }
        return triggered;
    }

    private Action tryKeys() {
        if (!Keyboard.getEventKeyState()) {
            return null;
        }
        int key = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
        Action triggered = null;
        if (key != 0 && !Keyboard.isRepeatEvent()) {
            for (Map.Entry<KeyBinding, Action> entry : this.keyBindingMap.entrySet()) {
                if (!entry.getKey().isActiveAndMatches(key)) continue;
                triggered = entry.getValue();
                break;
            }
        }
        return triggered;
    }
}

