/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.capabilities.shield.ShieldCapabilityHandler;
import twilightforest.capabilities.shield.ShieldCapabilityStorage;

public class CapabilityList {
    @CapabilityInject(value=IShieldCapability.class)
    public static final Capability<IShieldCapability> SHIELDS = null;

    public static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(IShieldCapability.class, (Capability.IStorage)new ShieldCapabilityStorage(), ShieldCapabilityHandler::new);
        MinecraftForge.EVENT_BUS.register(CapabilityList.class);
    }

    @SubscribeEvent
    public static void attachEntityCapability(final AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityLivingBase) {
            e.addCapability(IShieldCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IShieldCapability inst = (IShieldCapability)SHIELDS.getDefaultInstance();
                {
                    this.inst.setEntity((EntityLivingBase)e.getObject());
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == SHIELDS;
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == SHIELDS ? SHIELDS.cast((Object)this.inst) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)SHIELDS.getStorage().writeNBT(SHIELDS, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    SHIELDS.getStorage().readNBT(SHIELDS, (Object)this.inst, null, (NBTBase)nbt);
                }
            });
        }
    }
}

