/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.fastmap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.util.EnumFacing;

public abstract class PropertyIndexer<T extends Comparable<T>> {
    private static final Map<IProperty<?>, PropertyIndexer<?>> KNOWN_INDEXERS = new Object2ObjectOpenCustomHashMap(new Hash.Strategy<IProperty<?>>(){

        public int hashCode(IProperty<?> o) {
            return System.identityHashCode(o);
        }

        public boolean equals(IProperty<?> a, IProperty<?> b) {
            return a == b;
        }
    });
    private final IProperty<T> property;
    private final int numValues;
    protected final T[] valuesInOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>> PropertyIndexer<T> makeIndexer(IProperty<T> prop) {
        Map<IProperty<?>, PropertyIndexer<?>> map = KNOWN_INDEXERS;
        synchronized (map) {
            PropertyIndexer unchecked = KNOWN_INDEXERS.computeIfAbsent(prop, propInner -> {
                PropertyIndexer result = null;
                if (propInner instanceof PropertyBool) {
                    result = new BoolIndexer((PropertyBool)propInner);
                } else if (propInner instanceof PropertyInteger) {
                    result = new IntIndexer((PropertyInteger)propInner);
                } else if (WeirdVanillaDirectionIndexer.isApplicable(propInner)) {
                    result = new WeirdVanillaDirectionIndexer((IProperty<EnumFacing>)propInner);
                } else if (propInner instanceof PropertyEnum) {
                    result = new EnumIndexer((PropertyEnum)propInner);
                }
                if (result == null || !result.isValid()) {
                    return new GenericIndexer(propInner);
                }
                return result;
            });
            return unchecked;
        }
    }

    protected PropertyIndexer(IProperty<T> property, T[] valuesInOrder) {
        this.property = property;
        this.numValues = property.func_177700_c().size();
        this.valuesInOrder = valuesInOrder;
    }

    public IProperty<T> getProperty() {
        return this.property;
    }

    public int numValues() {
        return this.numValues;
    }

    @Nullable
    public final T byIndex(int index) {
        if (index >= 0 && index < this.valuesInOrder.length) {
            return this.valuesInOrder[index];
        }
        return null;
    }

    public abstract int toIndex(T var1);

    protected boolean isValid() {
        Collection allowed = this.getProperty().func_177700_c();
        int index = 0;
        for (Comparable val : allowed) {
            if (this.toIndex(val) != index || !val.equals(this.byIndex(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static class GenericIndexer<T extends Comparable<T>>
    extends PropertyIndexer<T> {
        private final Map<Comparable<?>, Integer> toValueIndex;

        protected GenericIndexer(IProperty<T> property) {
            super(property, property.func_177700_c().toArray(new Comparable[0]));
            LinkedHashMap<Comparable, Integer> tempMap = new LinkedHashMap<Comparable, Integer>();
            for (int i = 0; i < this.valuesInOrder.length; ++i) {
                tempMap.put(this.valuesInOrder[i], i);
            }
            this.toValueIndex = ImmutableMap.copyOf(tempMap);
        }

        @Override
        public int toIndex(T value) {
            return this.toValueIndex.getOrDefault(value, -1);
        }
    }

    private static class WeirdVanillaDirectionIndexer
    extends PropertyIndexer<EnumFacing> {
        private static final EnumFacing[] ORDER = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};

        public WeirdVanillaDirectionIndexer(IProperty<EnumFacing> prop) {
            super(prop, (Comparable[])ORDER);
            Preconditions.checkState((boolean)this.isValid());
        }

        static boolean isApplicable(IProperty<?> prop) {
            Collection values = prop.func_177700_c();
            if (values.size() != ORDER.length) {
                return false;
            }
            return Arrays.equals(ORDER, values.toArray());
        }

        @Override
        public int toIndex(EnumFacing value) {
            switch (value) {
                case NORTH: {
                    return 0;
                }
                case EAST: {
                    return 1;
                }
                case SOUTH: {
                    return 2;
                }
                case WEST: {
                    return 3;
                }
                case UP: {
                    return 4;
                }
            }
            return 5;
        }
    }

    private static class EnumIndexer<E extends Enum<E>>
    extends PropertyIndexer<E> {
        private final int ordinalOffset;

        protected EnumIndexer(PropertyEnum<E> property) {
            super(property, (Comparable[])property.func_177700_c().toArray(new Enum[0]));
            this.ordinalOffset = property.func_177700_c().stream().mapToInt(rec$ -> ((Enum)rec$).ordinal()).min().orElse(0);
        }

        @Override
        public int toIndex(E value) {
            return ((Enum)value).ordinal() - this.ordinalOffset;
        }
    }

    private static class IntIndexer
    extends PropertyIndexer<Integer> {
        private final int min;

        protected IntIndexer(PropertyInteger property) {
            super((IProperty)property, (Comparable[])property.func_177700_c().toArray(new Integer[0]));
            this.min = property.func_177700_c().stream().min(Comparator.naturalOrder()).orElse(0);
        }

        @Override
        public int toIndex(Integer value) {
            return value - this.min;
        }
    }

    private static class BoolIndexer
    extends PropertyIndexer<Boolean> {
        private static final Boolean[] VALUES = new Boolean[]{true, false};

        protected BoolIndexer(PropertyBool property) {
            super((IProperty)property, (Comparable[])VALUES);
        }

        @Override
        public int toIndex(Boolean value) {
            return value != false ? 0 : 1;
        }
    }
}

