/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tileentity;

import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.client.render.world.TileEntityRenderManager;
import com.creativemd.littletiles.common.api.te.ILittleTileTE;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.directional.StructureDirectionalField;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxReturnedVolume;
import com.creativemd.littletiles.common.tile.math.box.face.LittleBoxFace;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.parent.ParentTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tile.parent.TileList;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesRendered;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesTicking;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTilesTickingRendered;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.outdated.identifier.LittleIdentifierRelative;
import com.creativemd.littletiles.common.util.vec.LittleBlockTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLittleTiles
extends TileEntityCreative
implements ILittleTileTE,
IGridBased {
    protected final TileEntityInteractor interactor = new TileEntityInteractor();
    protected TileList tiles;
    private boolean unloaded = false;
    private boolean preventUnload = false;
    protected LittleGridContext context = LittleGridContext.getMin();
    private boolean hasLoaded = false;
    public final SideSolidCache sideCache = new SideSolidCache();
    @SideOnly(value=Side.CLIENT)
    public TileEntityRenderManager render;

    protected void assign(TileEntityLittleTiles te) {
        try {
            for (Field field : TileEntityLittleTiles.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                field.set(this, field.get(te));
            }
            this.func_145834_a(te.func_145831_w());
            this.tiles.te = this;
            if (this.isClientSide()) {
                this.render.setTe(this);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.tiles = new TileList(this, this.isClientSide());
        if (this.isClientSide()) {
            this.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.render = new TileEntityRenderManager(this);
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        if (this.tiles == null) {
            this.init();
        }
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        if (this.tiles == null) {
            this.init();
        }
    }

    public Iterable<LittleStructure> ticking() {
        return this.tiles.loadedStructures(1024);
    }

    @SideOnly(value=Side.CLIENT)
    public Iterable<LittleStructure> rendering() {
        return this.tiles.loadedStructures(2048);
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertToSmallest() {
        int size = LittleGridContext.minSize;
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            size = Math.max(size, ((LittleTile)pair.value).getSmallestContext(this.context));
        }
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    @Override
    public void convertTo(LittleGridContext newContext) {
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            ((LittleTile)pair.value).convertTo(this.context, newContext);
        }
        this.context = newContext;
    }

    public boolean contains(LittleTile tile) {
        return this.tiles.contains(tile);
    }

    public int tilesCount() {
        return this.tiles.size();
    }

    public boolean hasLoaded() {
        return this.hasLoaded && this.field_145850_b != null && this.tiles != null;
    }

    public void setLoaded() {
        this.hasLoaded = true;
    }

    public boolean shouldCheckForCollision() {
        return this.tiles.hasCollisionListener();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateQuadCache(Object chunk) {
        if (this.tiles == null) {
            return;
        }
        this.render.chunkUpdate(chunk);
    }

    public void updateLighting() {
        this.field_145850_b.func_175664_x(this.func_174877_v());
    }

    public TileEntityLittleTiles forceSupportAttribute(int attribute) {
        boolean rendered = this.tiles.hasRendered() | LittleStructureAttribute.tickRendering(attribute);
        boolean ticking = this.tiles.hasTicking() | LittleStructureAttribute.ticking(attribute);
        if (ticking != this.isTicking() || rendered != this.isRendered()) {
            TileEntityLittleTiles newTe = rendered ? (ticking ? new TileEntityLittleTilesTickingRendered() : new TileEntityLittleTilesRendered()) : (ticking ? new TileEntityLittleTilesTicking() : new TileEntityLittleTiles());
            newTe.assign(this);
            newTe.tiles.te = newTe;
            this.preventUnload = true;
            this.field_145850_b.func_180501_a(this.field_174879_c, BlockTile.getState(ticking, rendered), 20);
            this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)newTe);
            this.func_145843_s();
            return newTe;
        }
        return this;
    }

    protected void customTilesUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean rendered = this.tiles.hasRendered();
        boolean ticking = this.tiles.hasTicking();
        if (ticking != this.isTicking() || rendered != this.isRendered()) {
            TileEntityLittleTiles newTe = rendered ? (ticking ? new TileEntityLittleTilesTickingRendered() : new TileEntityLittleTilesRendered()) : (ticking ? new TileEntityLittleTilesTicking() : new TileEntityLittleTiles());
            newTe.assign(this);
            newTe.tiles.te = newTe;
            this.preventUnload = true;
            this.field_145850_b.func_180501_a(this.field_174879_c, BlockTile.getState(ticking, rendered), 2);
            this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)newTe);
            this.func_145843_s();
        }
    }

    public void onNeighbourChanged() {
        if (this.isClientSide()) {
            this.render.neighborChanged();
        }
        this.notifyStructure();
    }

    public void notifyStructure() {
        for (LittleStructure structure : this.tiles.loadedStructures(65536)) {
            structure.neighbourChanged();
        }
    }

    public void updateTiles() {
        this.updateTiles(true);
    }

    public void updateTiles(boolean updateNeighbour) {
        this.tiles.removeEmptyLists();
        this.notifyStructure();
        this.sideCache.reset();
        if (this.field_145850_b != null) {
            this.updateBlock();
            if (updateNeighbour) {
                this.updateNeighbour();
            }
            this.updateLighting();
        }
        if (this.isClientSide()) {
            this.render.tilesChanged();
        }
        if (!this.field_145850_b.field_72995_K && this.tiles.isCompletelyEmpty()) {
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
        if (this.field_145850_b instanceof CreativeWorld) {
            ((CreativeWorld)this.field_145850_b).hasChanged = true;
        }
        this.customTilesUpdate();
    }

    public void updateTiles(Consumer<TileEntityInteractor> action) {
        action.accept(this.interactor);
        this.updateTiles();
    }

    public void updateTilesSecretly(Consumer<TileEntityInteractor> action) {
        action.accept(this.interactor);
    }

    public boolean convertBlockToVanilla() {
        LittleTile firstTile = null;
        if (this.tiles.isCompletelyEmpty()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            return true;
        }
        if (this.field_145850_b instanceof IOrientatedWorld || this.tiles.countStructures() > 0) {
            return false;
        }
        if (this.tiles.size() == 1) {
            if (!this.tiles.first().canBeConvertedToVanilla() || !this.tiles.first().doesFillEntireBlock(this.context)) {
                return false;
            }
            firstTile = this.tiles.first();
        } else {
            boolean[][][] filled = new boolean[this.context.size][this.context.size][this.context.size];
            for (LittleTile tile : this.tiles) {
                if (firstTile == null) {
                    if (!tile.canBeConvertedToVanilla()) {
                        return false;
                    }
                    firstTile = tile;
                } else if (!firstTile.canBeCombined(tile) || !tile.canBeCombined(firstTile)) {
                    return false;
                }
                tile.fillInSpace(filled);
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return false;
                    }
                }
            }
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, firstTile.getBlockState());
        return true;
    }

    public boolean isBoxFilled(LittleBox box) {
        LittleVec size = box.getSize();
        boolean[][][] filled = new boolean[size.x][size.y][size.z];
        for (LittleTile tile : this.tiles) {
            tile.fillInSpace(box, filled);
        }
        for (int x = 0; x < filled.length; ++x) {
            for (int y = 0; y < filled[x].length; ++y) {
                for (int z = 0; z < filled[x][y].length; ++z) {
                    if (filled[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void updateNeighbour() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && this.tiles != null && this.tiles.hasRendered();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return this.render.getMaxRenderDistanceSquared();
    }

    public boolean hasFastRenderer() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.hasLoaded()) {
            return super.getRenderBoundingBox();
        }
        return this.render.getRenderBoundingBox();
    }

    public AxisAlignedBB getSelectionBox() {
        int minX = this.context.size;
        int minY = this.context.size;
        int minZ = this.context.size;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            LittleBox box = ((LittleTile)pair.value).getCompleteBox();
            minX = Math.min(box.minX, minX);
            minY = Math.min(box.minY, minY);
            minZ = Math.min(box.minZ, minZ);
            maxX = Math.max(box.maxX, maxX);
            maxY = Math.max(box.maxY, maxY);
            maxZ = Math.max(box.maxZ, maxZ);
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ).getBox(this.context, this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing facing, LittleBoxFace face, LittleTile rendered) {
        face.ensureContext(this.context);
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            if (((IParentTileList)pair.key).isStructure() && LittleStructureAttribute.noCollision(((IParentTileList)pair.key).getAttribute()) || pair.value == rendered || !((LittleTile)pair.value).doesProvideSolidFace(facing) && !((LittleTile)pair.value).canBeRenderCombined(rendered)) continue;
            ((LittleTile)pair.value).fillFace(face, this.context);
        }
        return !face.isFilled(rendered.isTranslucent());
    }

    public List<LittleBox> cutOut(LittleBox box, List<LittleBox> cutout, @Nullable LittleBoxReturnedVolume volume) {
        ArrayList<LittleBox> cutting = new ArrayList<LittleBox>();
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            ((LittleTile)pair.value).getIntersectingBox(box, cutting);
        }
        return box.cutOut(cutting, cutout, volume);
    }

    public Pair<IParentTileList, LittleTile> intersectingTile(LittleBox box) {
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            if (!((LittleTile)pair.value).intersectsWith(box)) continue;
            return pair;
        }
        return null;
    }

    public boolean isSpaceForLittleTile(LittleBox box, BiPredicate<IParentTileList, LittleTile> predicate) {
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            if (predicate != null && !predicate.test((IParentTileList)pair.key, (LittleTile)pair.value) || !((LittleTile)pair.value).intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceForLittleTile(LittleBox box, Predicate<LittleTile> predicate) {
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            if (predicate != null && !predicate.test((LittleTile)pair.value) || !((LittleTile)pair.value).intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceForLittleTile(LittleBox box) {
        return this.isSpaceForLittleTile(box, (Predicate<LittleTile>)null);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.tiles == null) {
            this.init();
        }
        if (!this.tiles.isCompletelyEmpty()) {
            this.tiles.clearEverything();
        }
        this.context = LittleGridContext.get(nbt);
        if (nbt.func_74764_b("tilesCount")) {
            int count = nbt.func_74762_e("tilesCount");
            HashMap<LittleIdentifierRelative, StructureTileList> structures = new HashMap<LittleIdentifierRelative, StructureTileList>();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound tileNBT = new NBTTagCompound();
                tileNBT = nbt.func_74775_l("t" + i);
                this.sortOldTiles(tileNBT, structures);
            }
            for (StructureTileList child : structures.values()) {
                this.tiles.addStructure(child.getIndex(), child);
            }
        } else if (nbt.func_74764_b("tiles")) {
            NBTTagList list = nbt.func_150295_c("tiles", 10);
            HashMap<LittleIdentifierRelative, StructureTileList> structures = new HashMap<LittleIdentifierRelative, StructureTileList>();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound ltNBT = list.func_150305_b(i);
                if (ltNBT.func_74764_b("boxes")) {
                    LittleTile create = LittleTileRegistry.getTypeFromNBT(ltNBT).createTile();
                    if (create == null) continue;
                    List<NBTTagCompound> nbts = create.extractNBTFromGroup(ltNBT);
                    for (int j = 0; j < nbts.size(); ++j) {
                        this.sortOldTiles(nbts.get(j), structures);
                    }
                    continue;
                }
                this.sortOldTiles(ltNBT, structures);
            }
            for (StructureTileList child : structures.values()) {
                StructureTileList.updateStatus(child);
                this.tiles.addStructure(child.getIndex(), child);
            }
        } else {
            this.tiles.read(nbt.func_74775_l("content"));
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.updateBlock();
            this.customTilesUpdate();
        }
        this.deleteTempWorld();
    }

    protected int[] getIdentifier(LittleBox box) {
        return new int[]{box.minX, box.minY, box.minZ};
    }

    protected void sortOldTiles(NBTTagCompound nbt, HashMap<LittleIdentifierRelative, StructureTileList> structures) {
        LittleTile tile = LittleTileRegistry.loadTile(nbt);
        LittleIdentifierRelative identifier = null;
        NBTTagCompound structureNBT = null;
        int attribute = 0;
        if (nbt.func_150297_b("structure", 10)) {
            NBTTagCompound temp = nbt.func_74775_l("structure");
            if (temp.func_74767_n("main")) {
                structureNBT = temp;
                identifier = new LittleIdentifierRelative(0, 0, 0, this.context, this.getIdentifier(tile.getBox()));
                attribute = LittleStructureRegistry.getStructureType((String)temp.func_74779_i((String)"id")).attribute;
            } else {
                identifier = new LittleIdentifierRelative(temp);
                attribute = temp.func_74764_b("attr") ? LittleStructureAttribute.loadOld(temp.func_74762_e("attr")) : temp.func_74762_e("type");
            }
        } else if (nbt.func_74767_n("isStructure")) {
            if (nbt.func_74767_n("main")) {
                structureNBT = nbt;
                identifier = new LittleIdentifierRelative(0, 0, 0, this.context, this.getIdentifier(tile.getBox()));
            } else if (nbt.func_74764_b("coX")) {
                LittleTile.LittleTilePosition pos = new LittleTile.LittleTilePosition(nbt);
                identifier = new LittleIdentifierRelative(this.func_174877_v().func_177958_n() - pos.coord.func_177958_n(), this.func_174877_v().func_177956_o() - pos.coord.func_177956_o(), this.func_174877_v().func_177952_p() - pos.coord.func_177952_p(), this.context, new int[]{pos.position.x, pos.position.y, pos.position.z});
                System.out.println("Converting old positioning to new relative coordinates " + pos + " to " + identifier);
            } else {
                identifier = new LittleIdentifierRelative(nbt);
            }
        }
        if (identifier == null) {
            this.tiles.add(tile);
        } else {
            StructureTileList structureList = structures.get(identifier);
            if (structureList == null) {
                structureList = new StructureTileList(this.tiles, identifier.generateIndex(this.field_174879_c), attribute);
                structures.put(identifier, structureList);
                StructureTileList.setRelativePos(structureList, identifier.coord);
            }
            if (structureNBT != null) {
                LittleStructure structure = structureList.setStructureNBT(structureNBT);
                LittleVec vec = tile.getMinVec();
                for (StructureDirectionalField field : structure.type.directional) {
                    field.move(field.get(structure), this.context, vec);
                }
            }
            structureList.add(tile);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.context.set(nbt);
        nbt.func_74782_a("content", (NBTBase)this.tiles.write());
        return nbt;
    }

    public void handleUpdate(NBTTagCompound nbt, boolean chunkUpdate) {
        if (this.isClientSide()) {
            this.render.beforeClientReceivesUpdate();
        }
        this.func_145839_a(nbt);
        if (!chunkUpdate) {
            this.updateTiles(false);
        }
        if (this.isClientSide()) {
            this.render.afterClientReceivesUpdate();
        }
    }

    public RayTraceResult rayTrace(EntityPlayer player) {
        Object hit = null;
        Vec3d pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        return this.rayTrace(pos, vec32);
    }

    public RayTraceResult rayTrace(Vec3d pos, Vec3d look) {
        RayTraceResult hit = null;
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            RayTraceResult Temphit = ((LittleTile)pair.value).rayTrace(this.context, this.func_174877_v(), pos, look);
            if (Temphit == null || hit != null && !(hit.field_72307_f.func_72438_d(pos) > Temphit.field_72307_f.func_72438_d(pos))) continue;
            hit = Temphit;
        }
        return hit;
    }

    public Pair<IParentTileList, LittleTile> getFocusedTile(EntityPlayer player, float partialTickTime) {
        if (!this.isClientSide()) {
            return null;
        }
        Vec3d pos = player.func_174824_e(partialTickTime);
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(partialTickTime);
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        if (this.field_145850_b != player.field_70170_p && this.field_145850_b instanceof CreativeWorld) {
            pos = ((CreativeWorld)this.field_145850_b).getOrigin().transformPointToFakeWorld(pos);
            vec32 = ((CreativeWorld)this.field_145850_b).getOrigin().transformPointToFakeWorld(vec32);
        }
        return this.getFocusedTile(pos, vec32);
    }

    public Pair<IParentTileList, LittleTile> getFocusedTile(Vec3d pos, Vec3d look) {
        IParentTileList parent = null;
        LittleTile tileFocus = null;
        RayTraceResult hit = null;
        double distance = 0.0;
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            RayTraceResult Temphit = ((LittleTile)pair.value).rayTrace(this.context, this.func_174877_v(), pos, look);
            if (Temphit == null || hit != null && !(distance > Temphit.field_72307_f.func_72438_d(pos))) continue;
            distance = Temphit.field_72307_f.func_72438_d(pos);
            hit = Temphit;
            parent = (IParentTileList)pair.key;
            tileFocus = (LittleTile)pair.value;
        }
        return new Pair(parent, tileFocus);
    }

    public void onLoad() {
        this.setLoaded();
    }

    public boolean isTicking() {
        return false;
    }

    public boolean isRendered() {
        return false;
    }

    public IBlockState getBlockTileState() {
        return BlockTile.getState(this);
    }

    public boolean combineTiles(int structureIndex) {
        if (this.getStructure(structureIndex) == null) {
            return false;
        }
        boolean changed = BasicCombiner.combine((StructureTileList)this.getStructure(structureIndex));
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    public boolean combineTilesSecretly(int structureIndex) {
        if (this.getStructure(structureIndex) == null) {
            return false;
        }
        boolean changed = BasicCombiner.combine((StructureTileList)this.getStructure(structureIndex));
        this.convertToSmallest();
        return changed;
    }

    public boolean combineTiles() {
        boolean changed = BasicCombiner.combine(this.tiles);
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    public boolean combineTilesSecretly() {
        boolean changed = BasicCombiner.combine(this.tiles);
        this.convertToSmallest();
        return changed;
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public Object getVoxelBlob(boolean force) throws Exception {
        return ChiselsAndBitsManager.getVoxelBlob(this, force);
    }

    @Override
    @Nullable
    public IBlockState getState(AxisAlignedBB box, boolean realistic) {
        if (this.tiles == null) {
            return null;
        }
        if (realistic) {
            box = box.func_72321_a(0.0, -this.context.pixelSize, 0.0);
            for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
                LittleBox tileBox = ((LittleTile)pair.value).getCollisionBox();
                if (tileBox == null || !tileBox.getBox(this.context, this.field_174879_c).func_72326_a(box)) continue;
                return ((LittleTile)pair.value).getBlockState();
            }
            return null;
        }
        box = box.func_72321_a(0.0, -1.0, 0.0);
        LittleTile highest = null;
        for (Pair<IParentTileList, LittleTile> pair : this.tiles.allTiles()) {
            if (((LittleTile)pair.value).getCollisionBox() == null || highest != null && (((LittleTile)pair.value).getMaxY() <= highest.getMaxY() || !((LittleTile)pair.value).getCollisionBox().getBox(this.context, this.field_174879_c).func_72326_a(box))) continue;
            highest = (LittleTile)pair.value;
        }
        return highest != null ? highest.getBlockState() : null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isRenderingEmpty() {
        return this.tiles.isCompletelyEmpty() && !this.render.hasAdditional();
    }

    public boolean isEmpty() {
        return this.tiles.isCompletelyEmpty();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.preventUnload) {
            this.tiles.unload();
        }
    }

    public boolean unloaded() {
        return this.unloaded;
    }

    public void onChunkUnload() {
        this.unloaded = true;
        super.onChunkUnload();
        this.tiles.unload();
        if (this.field_145850_b.field_72995_K) {
            this.tiles = null;
            this.render.chunkUnload();
        }
    }

    public void func_189667_a(Rotation rotationIn) {
        LittleBlockTransformer.rotateTE(this, RotationUtils.getRotation((Rotation)rotationIn), RotationUtils.getRotationCount((Rotation)rotationIn));
        this.updateTiles();
    }

    public void func_189668_a(Mirror mirrorIn) {
        LittleBlockTransformer.flipTE(this, RotationUtils.getMirrorAxis((Mirror)mirrorIn));
        this.updateTiles();
    }

    public String toString() {
        return this.field_174879_c.toString();
    }

    public void tick() {
        for (LittleStructure structure : this.ticking()) {
            structure.tick();
        }
    }

    public Iterable<IParentTileList> groups() {
        return this.tiles.groups();
    }

    public IParentTileList noneStructureTiles() {
        return this.tiles;
    }

    public Iterable<Pair<IParentTileList, LittleTile>> allTiles() {
        return this.tiles.allTiles();
    }

    public IStructureTileList getStructure(int index) {
        return this.tiles.getStructure(index);
    }

    public Iterable<LittleStructure> loadedStructures() {
        return this.tiles.loadedStructures();
    }

    public Iterable<LittleStructure> loadedStructures(int attribute) {
        return this.tiles.loadedStructures(attribute);
    }

    public Iterable<IStructureTileList> structures() {
        return this.tiles.structures();
    }

    public void fillUsedIds(BitSet usedIds) {
        this.tiles.fillUsedIds(usedIds);
    }

    public class SideSolidCache {
        SideState DOWN;
        SideState UP;
        SideState NORTH;
        SideState SOUTH;
        SideState WEST;
        SideState EAST;

        public void reset() {
            this.DOWN = null;
            this.UP = null;
            this.NORTH = null;
            this.SOUTH = null;
            this.WEST = null;
            this.EAST = null;
        }

        protected SideState calculate(EnumFacing facing) {
            LittleBox box;
            switch (facing) {
                case EAST: {
                    box = new LittleBox(TileEntityLittleTiles.this.context.size - 1, 0, 0, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case WEST: {
                    box = new LittleBox(0, 0, 0, 1, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case UP: {
                    box = new LittleBox(0, TileEntityLittleTiles.this.context.size - 1, 0, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case DOWN: {
                    box = new LittleBox(0, 0, 0, TileEntityLittleTiles.this.context.size, 1, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case SOUTH: {
                    box = new LittleBox(0, 0, TileEntityLittleTiles.this.context.size - 1, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size);
                    break;
                }
                case NORTH: {
                    box = new LittleBox(0, 0, 0, TileEntityLittleTiles.this.context.size, TileEntityLittleTiles.this.context.size, 1);
                    break;
                }
                default: {
                    box = null;
                }
            }
            return this.calculateState(facing, box);
        }

        protected SideState calculateState(EnumFacing facing, LittleBox box) {
            LittleVec size = box.getSize();
            boolean[][][] filled = new boolean[size.x][size.y][size.z];
            boolean translucent = false;
            boolean noclip = false;
            for (Pair<IParentTileList, LittleTile> pair : TileEntityLittleTiles.this.tiles.allTiles()) {
                if (!((LittleTile)pair.value).fillInSpaceInaccurate(box, filled)) continue;
                if (!((LittleTile)pair.value).doesProvideSolidFace(facing)) {
                    translucent = true;
                }
                if (!LittleStructureAttribute.noCollision(((IParentTileList)pair.key).getAttribute()) && !((LittleTile)pair.value).hasNoCollision()) continue;
                noclip = true;
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return SideState.EMPTY;
                    }
                }
            }
            return SideState.getState(false, noclip, translucent);
        }

        public SideState get(EnumFacing facing) {
            SideState result;
            switch (facing) {
                case DOWN: {
                    result = this.DOWN;
                    break;
                }
                case UP: {
                    result = this.UP;
                    break;
                }
                case NORTH: {
                    result = this.NORTH;
                    break;
                }
                case SOUTH: {
                    result = this.SOUTH;
                    break;
                }
                case WEST: {
                    result = this.WEST;
                    break;
                }
                case EAST: {
                    result = this.EAST;
                    break;
                }
                default: {
                    result = SideState.EMPTY;
                }
            }
            if (result == null) {
                result = this.calculate(facing);
                this.set(facing, result);
            }
            return result;
        }

        public void set(EnumFacing facing, SideState value) {
            switch (facing) {
                case DOWN: {
                    this.DOWN = value;
                    break;
                }
                case UP: {
                    this.UP = value;
                    break;
                }
                case NORTH: {
                    this.NORTH = value;
                    break;
                }
                case SOUTH: {
                    this.SOUTH = value;
                    break;
                }
                case WEST: {
                    this.WEST = value;
                    break;
                }
                case EAST: {
                    this.EAST = value;
                }
            }
        }
    }

    public static enum SideState {
        EMPTY{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return false;
            }
        }
        ,
        SEETHROUGH{

            @Override
            public boolean doesBlockCollision() {
                return true;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        NOCLIP{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return true;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        SEETHROUGH_NOCLIP{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        SOLID{

            @Override
            public boolean doesBlockCollision() {
                return true;
            }

            @Override
            public boolean doesBlockLight() {
                return true;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        };


        public abstract boolean isFilled();

        public abstract boolean doesBlockCollision();

        public abstract boolean doesBlockLight();

        public static SideState getState(boolean empty, boolean noclip, boolean translucent) {
            if (empty) {
                return EMPTY;
            }
            if (noclip && translucent) {
                return SEETHROUGH_NOCLIP;
            }
            if (noclip) {
                return NOCLIP;
            }
            if (translucent) {
                return SEETHROUGH;
            }
            return SOLID;
        }
    }

    public class TileEntityInteractor {
        public Iterable<ParentTileList> groups() {
            return new Iterable<ParentTileList>(){

                @Override
                public Iterator<ParentTileList> iterator() {
                    return new Iterator<ParentTileList>(){
                        ParentTileList current;
                        Iterator<StructureTileList> children;
                        {
                            this.current = TileEntityLittleTiles.this.tiles;
                            this.children = TileEntityInteractor.this.structures().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.current != null) {
                                return true;
                            }
                            if (!this.children.hasNext()) {
                                return false;
                            }
                            this.current = this.children.next();
                            return true;
                        }

                        @Override
                        public ParentTileList next() {
                            ParentTileList result = this.current;
                            this.current = null;
                            return result;
                        }
                    };
                }
            };
        }

        public ParentTileList get(IParentTileList list) {
            return (ParentTileList)list;
        }

        public StructureTileList get(IStructureTileList list) {
            return (StructureTileList)list;
        }

        public ParentTileList noneStructureTiles() {
            return TileEntityLittleTiles.this.tiles;
        }

        public Iterable<StructureTileList> structures() {
            return TileEntityLittleTiles.this.tiles.structuresReal();
        }

        public StructureTileList getStructure(int index) {
            return TileEntityLittleTiles.this.tiles.getStructure(index);
        }

        public boolean removeStructure(int index) {
            return TileEntityLittleTiles.this.tiles.removeStructure(index);
        }

        public StructureTileList addStructure(int index, int attribute) {
            return TileEntityLittleTiles.this.tiles.addStructure(index, attribute);
        }

        public void clearEverything() {
            TileEntityLittleTiles.this.tiles.clearEverything();
        }
    }
}

