/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class LittleActivateDoorPacket
extends CreativeCorePacket {
    public StructureLocation location;
    public LittleDoor.DoorActivator activator;
    public UUID uuid;

    public LittleActivateDoorPacket(LittleDoor.DoorActivator activator, StructureLocation location, UUID uuid) {
        this.location = location;
        this.activator = activator;
        this.uuid = uuid;
    }

    public LittleActivateDoorPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeStructureLocation(this.location, buf);
        LittleActivateDoorPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        buf.writeInt(this.activator.ordinal());
    }

    public void readBytes(ByteBuf buf) {
        this.location = LittleAction.readStructureLocation(buf);
        this.uuid = UUID.fromString(LittleActivateDoorPacket.readString((ByteBuf)buf));
        this.activator = LittleDoor.DoorActivator.values()[buf.readInt()];
    }

    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        block4: {
            EntityAnimation animation = null;
            try {
                LittleStructure structure = this.location.find(player.field_70170_p);
                if (structure instanceof LittleDoor && !structure.mainBlock.isRemoved()) {
                    LittleDoor door = (LittleDoor)structure;
                    World world = door.getWorld();
                    if (world instanceof SubWorld) {
                        animation = (EntityAnimation)((SubWorld)world).parent;
                    }
                    door.activate(this.activator, player, this.uuid);
                }
            }
            catch (LittleActionException e) {
                if (e.isHidden()) break block4;
                player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
            }
        }
    }
}

