/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureConnection;
import com.creativemd.littletiles.common.structure.connection.StructureChildConnection;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiStructureOverview
extends SubGui {
    public IStructureTileList list;

    public SubGuiStructureOverview(IStructureTileList list) {
        super(300, 300);
        this.list = list;
    }

    public void createControls() {
        try {
            this.controls.add(new GuiLabel(SubGuiStructureOverview.printStructureTitle((IStructureConnection)((Object)this.list)), 0, 3));
            final LittleStructure structure = this.list.getStructure();
            if (structure.getParent() == null) {
                this.controls.add(new GuiLabel(ChatFormatting.WHITE + "no parent", 0, 20));
            } else {
                this.controls.add(new GuiLabel(ChatFormatting.WHITE + "parent: " + SubGuiStructureOverview.printStructureTitle(structure.getParent()), 0, 20));
                try {
                    structure.getParent().checkConnection();
                    this.controls.add(new GuiButton("open", 260, 17){

                        public void onClicked(int x, int y, int button) {
                            try {
                                LittleStructureGuiHandler.openGui("structureoverview2", new NBTTagCompound(), this.getPlayer(), structure.getParent().getStructure());
                            }
                            catch (CorruptedConnectionException | NotYetConnectedException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    this.controls.add(new GuiButton("connect", 260, 17){

                        public void onClicked(int x, int y, int button) {
                            try {
                                structure.getParent().checkConnection();
                            }
                            catch (CorruptedConnectionException | NotYetConnectedException e) {
                                e.printStackTrace();
                            }
                            SubGuiStructureOverview.this.controls.clear();
                            SubGuiStructureOverview.this.createControls();
                            SubGuiStructureOverview.this.refreshControls();
                        }
                    });
                }
            }
            this.controls.add(new GuiLabel(ChatFormatting.WHITE + "" + structure.countChildren() + " child" + (structure.countChildren() != 1 ? "ren" : ""), 0, 40));
            GuiScrollBox scrollBox = new GuiScrollBox(this.name, 3, 55, 290, 230);
            scrollBox.scaleFactor = 1.0f;
            int i = 0;
            for (final StructureChildConnection child : structure.getChildren()) {
                scrollBox.addControl((GuiControl)new GuiLabel("id:" + child.getChildId() + "," + SubGuiStructureOverview.printStructureTitle(child), 0, 5 + 20 * i));
                try {
                    child.checkConnection();
                    scrollBox.addControl((GuiControl)new GuiButton("open", 248, 2 + 20 * i){

                        public void onClicked(int x, int y, int button) {
                            try {
                                LittleStructureGuiHandler.openGui("structureoverview2", new NBTTagCompound(), this.getPlayer(), child.getStructure());
                            }
                            catch (CorruptedConnectionException | NotYetConnectedException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    scrollBox.addControl((GuiControl)new GuiButton("connect", 235, 2 + 20 * i){

                        public void onClicked(int x, int y, int button) {
                            try {
                                child.checkConnection();
                            }
                            catch (CorruptedConnectionException | NotYetConnectedException e) {
                                e.printStackTrace();
                            }
                            SubGuiStructureOverview.this.controls.clear();
                            SubGuiStructureOverview.this.createControls();
                            SubGuiStructureOverview.this.refreshControls();
                        }
                    });
                }
                ++i;
            }
            this.controls.add(scrollBox);
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            this.controls.add(new GuiLabel(ChatFormatting.WHITE + "status: " + ChatFormatting.YELLOW + e.getLocalizedMessage(), 0, 23));
            this.controls.add(new GuiButton("connect", 200, 0){

                public void onClicked(int x, int y, int button) {
                    try {
                        ((IStructureConnection)((Object)SubGuiStructureOverview.this.list)).checkConnection();
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException e) {
                        e.printStackTrace();
                    }
                    SubGuiStructureOverview.this.controls.clear();
                    SubGuiStructureOverview.this.createControls();
                    SubGuiStructureOverview.this.refreshControls();
                }
            });
        }
    }

    private static String printStructureTitle(IStructureConnection connection) {
        try {
            LittleStructure structure = connection.getStructure();
            return ChatFormatting.WHITE + "i:" + structure.getIndex() + "," + ChatFormatting.WHITE + ChatFormatting.DARK_GREEN + (structure.name != null ? structure.name : structure.type.id) + ChatFormatting.WHITE + ", " + structure.count() + " tile(s)";
        }
        catch (CorruptedConnectionException e) {
            return ChatFormatting.WHITE + "i:" + connection.getIndex() + "-" + connection.getAttribute() + "," + ChatFormatting.RED + " broken";
        }
        catch (NotYetConnectedException e) {
            return ChatFormatting.WHITE + "i:" + connection.getIndex() + "-" + connection.getAttribute() + "," + ChatFormatting.YELLOW + " pending";
        }
    }
}

