/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.latmod.yabba.api.BarrelContentType;
import com.latmod.yabba.tile.BarrelNetwork;
import com.latmod.yabba.tile.IBarrelConnector;
import com.latmod.yabba.tile.ItemBarrel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemBarrelConnector
extends TileBase
implements IItemHandler,
IBarrelConnector {
    private final Comparator<ItemBarrel> BARREL_COMPARATOR = (o1, o2) -> {
        int i = Boolean.compare(o1.type.func_190926_b(), o2.type.func_190926_b());
        i = i == 0 ? Boolean.compare(o2.barrel.isLocked(), o1.barrel.isLocked()) : i;
        return i == 0 ? Double.compare(this.field_174879_c.func_177951_i((Vec3i)((TileEntity)o1.barrel.block).func_174877_v()), this.field_174879_c.func_177951_i((Vec3i)((TileEntity)o2.barrel.block).func_174877_v())) : i;
    };
    public List<ItemBarrel> linkedBarrels = null;

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    public void func_145843_s() {
        if (this.func_145830_o()) {
            BarrelNetwork.get(this.func_145831_w()).refresh();
        }
        super.func_145843_s();
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.func_145830_o()) {
            BarrelNetwork.get(this.func_145831_w()).refresh();
        }
    }

    public void func_70296_d() {
    }

    public boolean notifyBlock() {
        return false;
    }

    private void addToList(HashSet<ItemBarrel> scanned, BlockPos pos, EnumFacing from) {
        IItemHandler itemHandler;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, from) && (itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, from)) instanceof ItemBarrel && scanned.add((ItemBarrel)itemHandler)) {
            for (EnumFacing facing1 : EnumFacing.field_82609_l) {
                if (facing1 == from) continue;
                this.addToList(scanned, pos.func_177972_a(facing1), facing1.func_176734_d());
            }
        }
    }

    @Nullable
    private ItemBarrel getAt(int slot) {
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.linkedBarrels == null) {
            if (this.field_145850_b.field_72995_K) {
                this.linkedBarrels = Collections.emptyList();
                return null;
            }
            HashSet<ItemBarrel> scanned = new HashSet<ItemBarrel>();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.addToList(scanned, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
            }
            this.linkedBarrels = new ArrayList<ItemBarrel>(scanned);
            this.linkedBarrels.sort(this.BARREL_COMPARATOR);
        }
        if (slot <= 0 || slot > this.linkedBarrels.size()) {
            return null;
        }
        ItemBarrel barrel = this.linkedBarrels.get(slot - 1);
        return barrel == null || barrel.barrel.block.isBarrelInvalid() ? null : barrel;
    }

    public int getSlots() {
        this.getAt(0);
        return 1 + this.linkedBarrels.size();
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 0) {
            return ItemStack.field_190927_a;
        }
        ItemBarrel barrel = this.getAt(slot);
        return barrel == null ? ItemStack.field_190927_a : barrel.getStackInSlot(1);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        this.getAt(0);
        for (ItemBarrel barrel : this.linkedBarrels) {
            if (!barrel.isItemValid(0, stack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (slot != 0) {
            return stack;
        }
        this.getAt(0);
        for (ItemBarrel barrel : this.linkedBarrels) {
            if (barrel.isEmpty() || !(stack = barrel.insertItem(0, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        for (ItemBarrel barrel : this.linkedBarrels) {
            if (!barrel.isEmpty() || !(stack = barrel.insertItem(0, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0) {
            return ItemStack.field_190927_a;
        }
        ItemBarrel barrel = this.getAt(slot);
        return barrel == null ? ItemStack.field_190927_a : barrel.extractItem(1, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    @Override
    public BarrelContentType getContentType() {
        return BarrelContentType.ITEM;
    }

    @Override
    public void updateBarrels() {
        this.linkedBarrels = null;
    }
}

