/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.schematic;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.capability.SelectionOwner;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.world.gen.feature.structure.schematics.SchematicFile;
import ivorius.reccomplex.world.gen.feature.structure.schematics.SchematicLoader;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandExportSchematic
extends CommandExpecting {
    public static SchematicFile toSchematic(IvWorldData worldData) {
        SchematicFile schematicFile = new SchematicFile((short)worldData.blockCollection.width, (short)worldData.blockCollection.height, (short)worldData.blockCollection.length);
        for (BlockPos pos : BlockAreas.mutablePositions((BlockArea)worldData.blockCollection.area())) {
            schematicFile.setBlockState(pos, worldData.blockCollection.getBlockState(pos));
        }
        schematicFile.entityCompounds.addAll(worldData.entities);
        schematicFile.tileEntityCompounds.addAll(worldData.tileEntities);
        return schematicFile;
    }

    public static IvWorldData toWorldData(SchematicFile schematicFile) {
        IvWorldData worldData = new IvWorldData(new IvBlockCollection((int)schematicFile.width, (int)schematicFile.height, (int)schematicFile.length), schematicFile.tileEntityCompounds, schematicFile.entityCompounds);
        for (BlockPos pos : schematicFile.area()) {
            worldData.blockCollection.setBlockState(pos, schematicFile.getBlockState(pos));
        }
        return worldData;
    }

    public String func_71517_b() {
        return "export";
    }

    @Override
    public void expect(Expect expect) {
        expect.then(RCE::schematic);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        SelectionOwner selectionOwner = RCCommands.getSelectionOwner(commandSender, null, true);
        BlockArea area = selectionOwner.getSelection();
        RCCommands.assertSize(commandSender, selectionOwner);
        String structureName = parameters.get(0).optional().orElse("NewStructure_" + commandSender.func_130014_f_().field_73012_v.nextInt(1000));
        BlockPos lowerCoord = area.getLowerCorner();
        BlockPos higherCoord = area.getHigherCorner();
        IvWorldData data = IvWorldData.capture((World)commandSender.func_130014_f_(), (BlockArea)new BlockArea(lowerCoord, higherCoord), (boolean)true);
        SchematicFile schematicFile = CommandExportSchematic.toSchematic(data);
        SchematicLoader.writeSchematicByName(schematicFile, structureName);
        commandSender.func_145747_a(RecurrentComplex.translations.format("commands.strucExportSchematic.success", RCTextStyle.visit(SchematicLoader.getValidatedSchematicsFile(), "schematics/" + structureName)));
    }

    public int func_82362_a() {
        return 4;
    }
}

