/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.NeighborIndex;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;

@Deprecated
public class DirectedNeighborIndex<V, E>
implements GraphListener<V, E> {
    private Map<V, NeighborIndex.Neighbors<V>> predecessorMap = new HashMap<V, NeighborIndex.Neighbors<V>>();
    private Map<V, NeighborIndex.Neighbors<V>> successorMap = new HashMap<V, NeighborIndex.Neighbors<V>>();
    private Graph<V, E> graph;

    public DirectedNeighborIndex(Graph<V, E> g) {
        this.graph = GraphTests.requireDirected(g, "Graph must be directed");
    }

    public Set<V> predecessorsOf(V v) {
        return this.getPredecessors(v).getNeighbors();
    }

    public List<V> predecessorListOf(V v) {
        return this.getPredecessors(v).getNeighborList();
    }

    public Set<V> successorsOf(V v) {
        return this.getSuccessors(v).getNeighbors();
    }

    public List<V> successorListOf(V v) {
        return this.getSuccessors(v).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> e) {
        E edge = e.getEdge();
        V source = this.graph.getEdgeSource(edge);
        V target = this.graph.getEdgeTarget(edge);
        if (this.successorMap.containsKey(source)) {
            this.getSuccessors(source).addNeighbor(target);
        } else {
            this.getSuccessors(source);
        }
        if (this.predecessorMap.containsKey(target)) {
            this.getPredecessors(target).addNeighbor(source);
        } else {
            this.getPredecessors(target);
        }
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> e) {
        V source = e.getEdgeSource();
        V target = e.getEdgeTarget();
        if (this.successorMap.containsKey(source)) {
            this.successorMap.get(source).removeNeighbor(target);
        }
        if (this.predecessorMap.containsKey(target)) {
            this.predecessorMap.get(target).removeNeighbor(source);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> e) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> e) {
        this.predecessorMap.remove(e.getVertex());
        this.successorMap.remove(e.getVertex());
    }

    private NeighborIndex.Neighbors<V> getPredecessors(V v) {
        NeighborIndex.Neighbors<V> neighbors = this.predecessorMap.get(v);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors<V>(Graphs.predecessorListOf(this.graph, v));
            this.predecessorMap.put((NeighborIndex.Neighbors<V>)v, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V>>)neighbors);
        }
        return neighbors;
    }

    private NeighborIndex.Neighbors<V> getSuccessors(V v) {
        NeighborIndex.Neighbors<V> neighbors = this.successorMap.get(v);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors<V>(Graphs.successorListOf(this.graph, v));
            this.successorMap.put((NeighborIndex.Neighbors<V>)v, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V>>)neighbors);
        }
        return neighbors;
    }
}

