/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.world.limbo;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.world.ModBiomes;

public class ChunkGeneratorLimbo
implements IChunkGenerator {
    private Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    public NoiseGeneratorOctaves depthNoise;
    double[] mainNoiseRegion;
    double[] minLimitRegion;
    double[] maxLimitRegion;
    private World world;
    private double[] heightMap;
    private Biome[] biomesForGeneration = new Biome[]{ModBiomes.LIMBO};
    double[] depthRegion;

    public ChunkGeneratorLimbo(World world, long seed) {
        this.world = world;
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 80);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.world = world;
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, primer);
        Chunk chunk = new Chunk(this.world, primer, x, z);
        chunk.func_76603_b();
        if (!chunk.func_177419_t()) {
            chunk.func_177446_d(true);
        }
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        Biome biome = this.world.func_180494_b(new BlockPos(x * 16 + 16, 0, z * 16 + 16));
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(x * 16 + 8), (int)(z * 16 + 8), (int)16, (int)16, (Random)this.rand);
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    private double[] generateHeightmap(double[] heightMap, int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize) {
        if (heightMap == null) {
            heightMap = new double[xSize * ySize * zSize];
        }
        double xzScale = 884.412;
        double yScale = 9840.412;
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, xOffset, zOffset, xSize, zSize, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, xOffset, yOffset, zOffset, xSize, ySize, zSize, xzScale / 80.0, yScale / 160.0, xzScale / 80.0);
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, xOffset, yOffset, zOffset, xSize, ySize, zSize, xzScale, yScale, xzScale);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, xOffset, yOffset, zOffset, xSize, ySize, zSize, xzScale, yScale, xzScale);
        int heightMapIndex = 0;
        int depthRegionIndex = 0;
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                float heightVariation = 5.959498f;
                float baseHeight = -1.3523747f;
                heightVariation = heightVariation * 0.9f + 0.1f;
                baseHeight = (baseHeight * 4.0f - 1.0f) / 8.0f;
                double depthOffset = this.depthRegion[depthRegionIndex] / 8000.0;
                if (depthOffset < 0.0) {
                    depthOffset = -depthOffset * 0.3;
                }
                if ((depthOffset = depthOffset * 3.0 - 2.0) < 0.0) {
                    if ((depthOffset /= 2.0) < -1.0) {
                        depthOffset = -1.0;
                    }
                    depthOffset /= 1.4;
                    depthOffset /= 2.0;
                } else {
                    if (depthOffset > 1.0) {
                        depthOffset = 1.0;
                    }
                    depthOffset /= 8.0;
                }
                ++depthRegionIndex;
                for (int y = 0; y < ySize; ++y) {
                    double depth = baseHeight;
                    depth += depthOffset * 0.2;
                    depth = depth * (double)ySize / 16.0;
                    double heightOffset = ((double)y - (depth = (double)ySize / 2.0 + depth * 4.0)) * 12.0 * 128.0 / 128.0 / (double)heightVariation;
                    if (heightOffset < 0.0) {
                        heightOffset *= 4.0;
                    }
                    double minLimit = this.minLimitRegion[heightMapIndex] / 512.0;
                    double maxLimit = this.maxLimitRegion[heightMapIndex] / 512.0;
                    double mainNoise = (this.mainNoiseRegion[heightMapIndex] / 10.0 + 1.0) / 2.0;
                    double height = mainNoise < 0.0 ? minLimit : (mainNoise > 1.0 ? maxLimit : minLimit + (maxLimit - minLimit) * mainNoise);
                    height -= heightOffset;
                    if (y > ySize - 4) {
                        double var40 = (float)(y - (ySize - 4)) / 3.0f;
                        height = height * (1.0 - var40) + -10.0 * var40;
                    }
                    heightMap[heightMapIndex] = height;
                    ++heightMapIndex;
                }
            }
        }
        return heightMap;
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.heightMap = this.generateHeightmap(this.heightMap, x * 4, 0, z * 4, 5, 17, 5);
        int xzSectionCount = 4;
        int xzSectionSize = 4;
        int ySectionCount = 16;
        int ySectionSize = 8;
        double xzScale = 1.0 / (double)xzSectionSize;
        double yScale = 1.0 / (double)ySectionSize;
        for (int sectionX = 0; sectionX < xzSectionCount; ++sectionX) {
            int xSectionPart = sectionX * xzSectionSize;
            int i0__ = sectionX * (xzSectionCount + 1);
            int i1__ = (sectionX + 1) * (xzSectionCount + 1);
            for (int sectionZ = 0; sectionZ < xzSectionCount; ++sectionZ) {
                int zSectionPart = sectionZ * xzSectionSize;
                int i0_0 = (i0__ + sectionZ) * (ySectionCount + 1);
                int i0_1 = (i0__ + sectionZ + 1) * (ySectionCount + 1);
                int i1_0 = (i1__ + sectionZ) * (ySectionCount + 1);
                int i1_1 = (i1__ + sectionZ + 1) * (ySectionCount + 1);
                for (int sectionY = 0; sectionY < ySectionCount; ++sectionY) {
                    int ySectionPart = sectionY * ySectionSize;
                    double v0y0 = this.heightMap[i0_0 + sectionY];
                    double v0y1 = this.heightMap[i0_1 + sectionY];
                    double v1y0 = this.heightMap[i1_0 + sectionY];
                    double v1y1 = this.heightMap[i1_1 + sectionY];
                    double d0y0 = (this.heightMap[i0_0 + sectionY + 1] - v0y0) * yScale;
                    double d0y1 = (this.heightMap[i0_1 + sectionY + 1] - v0y1) * yScale;
                    double d1y0 = (this.heightMap[i1_0 + sectionY + 1] - v1y0) * yScale;
                    double d1y1 = (this.heightMap[i1_1 + sectionY + 1] - v1y1) * yScale;
                    for (int yRel = 0; yRel < ySectionSize; ++yRel) {
                        int yCoord = ySectionPart + yRel;
                        double vxy0 = v0y0;
                        double vxy1 = v0y1;
                        double dxy0 = (v1y0 - v0y0) * xzScale;
                        double dxy1 = (v1y1 - v0y1) * xzScale;
                        for (int xRel = 0; xRel < xzSectionSize; ++xRel) {
                            int xCoord = xSectionPart + xRel;
                            double dxyz = (vxy1 - vxy0) * xzScale;
                            double vxyz = vxy0 - dxyz;
                            for (int zRel = 0; zRel < xzSectionSize; ++zRel) {
                                int zCoord = zSectionPart + zRel;
                                if (vxyz > 0.0) {
                                    primer.func_177855_a(xCoord, yCoord, zCoord, ModBlocks.UNRAVELLED_FABRIC.func_176223_P());
                                    continue;
                                }
                                if (yCoord >= 6) continue;
                                primer.func_177855_a(xCoord, yCoord, zCoord, ModBlocks.ETERNAL_FABRIC.func_176223_P());
                            }
                            vxy0 += dxy0;
                            vxy1 += dxy1;
                        }
                        v0y0 += d0y0;
                        v0y1 += d0y1;
                        v1y0 += d1y0;
                        v1y1 += d1y1;
                    }
                }
            }
        }
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        return false;
    }
}

