/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.world.gateways;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.dimdev.ddutils.schem.Schematic;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.pockets.PocketTemplate;
import org.dimdev.dimdoors.shared.world.gateways.BaseGateway;

public abstract class BaseSchematicGateway
extends BaseGateway {
    private Schematic schematic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseSchematicGateway(String id) {
        String schematicJarDirectory = "/assets/dimdoors/gateways/";
        InputStream schematicStream = DimDoors.class.getResourceAsStream(schematicJarDirectory + id + ".schem");
        DataInputStream schematicDataStream = null;
        boolean streamOpened = false;
        if (schematicStream != null) {
            schematicDataStream = new DataInputStream(schematicStream);
            streamOpened = true;
        } else {
            DimDoors.log.warn("Schematic '" + id + "' was not found in the jar or config directory, neither with the .schem extension, nor with the .schematic extension.");
        }
        this.schematic = null;
        if (streamOpened) {
            try {
                NBTTagCompound schematicNBT = CompressedStreamTools.func_74796_a((InputStream)schematicDataStream);
                this.schematic = Schematic.loadFromNBT(schematicNBT);
                PocketTemplate.replacePlaceholders(this.schematic);
                schematicDataStream.close();
            }
            catch (IOException ex) {
                DimDoors.log.error("Schematic file for " + id + " could not be read as a valid schematic NBT file.", (Throwable)ex);
            }
            finally {
                try {
                    schematicDataStream.close();
                }
                catch (IOException ex) {
                    DimDoors.log.error("Error occured while closing schematicDataStream", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void generate(World world, int x, int y, int z) {
        this.schematic.place(world, x, y, z);
        this.generateRandomBits(world, x, y, z);
    }

    protected void generateRandomBits(World world, int x, int y, int z) {
    }
}

