/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FileUtils;
import org.dimdev.ddutils.schem.Schematic;
import org.dimdev.dimdoors.shared.tools.Initializer;

public final class SchematicProcessor {
    private static boolean schematicChanged = false;
    private static boolean paletteChanged = false;

    public static void main(String ... args) throws IOException {
        boolean testMode = false;
        File schematicDir = new File("schematics/");
        if (args.length > 2) {
            System.err.println("Too many arguments!");
            return;
        }
        if (args.length == 2) {
            testMode = args[0].equals("true");
            schematicDir = new File(args[1]);
            if (!schematicDir.isDirectory()) {
                System.err.print("The directory " + args[0] + " couldn't be found!");
                return;
            }
        } else if (args.length == 1) {
            testMode = args[0].equals("true");
        }
        Initializer.initialize();
        if (testMode) {
            File out = new File("out");
            FileUtils.deleteDirectory((File)out);
            out.mkdir();
        }
        SchematicProcessor.process(schematicDir, testMode);
    }

    private static void process(File file, boolean testMode) throws IOException {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                SchematicProcessor.process(subFile, testMode);
            }
        } else {
            Schematic schematic = Schematic.loadFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
            if ((schematic = SchematicProcessor.runTasks(schematic)) != null) {
                File outputFile;
                File file2 = outputFile = testMode ? new File("out", file.getName()) : file;
                if (!testMode) {
                    outputFile.delete();
                }
                CompressedStreamTools.func_74799_a((NBTTagCompound)schematic.saveToNBT(), (OutputStream)new FileOutputStream(outputFile));
            }
        }
    }

    private static Schematic runTasks(Schematic schematic) {
        if (paletteChanged) {
            schematic = SchematicProcessor.rewriteSchematic(schematic);
            paletteChanged = false;
        }
        return schematicChanged ? schematic : null;
    }

    private static Schematic rewriteSchematic(Schematic schematic) {
        Schematic copy = new Schematic(schematic.name, schematic.author, schematic.width, schematic.height, schematic.length);
        copy.creationDate = schematic.creationDate;
        copy.requiredMods = schematic.requiredMods;
        copy.offset = schematic.offset;
        for (int x = 0; x < schematic.width; ++x) {
            for (int y = 0; y < schematic.height; ++y) {
                for (int z = 0; z < schematic.length; ++z) {
                    copy.setBlockState(x, y, z, schematic.getBlockState(x, y, z));
                }
            }
        }
        copy.tileEntities = schematic.tileEntities;
        copy.entities = schematic.entities;
        return copy;
    }
}

