/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.entities;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.TeleportUtils;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.sound.ModSounds;
import org.dimdev.dimdoors.shared.world.ModDimensions;
import org.dimdev.dimdoors.shared.world.limbo.WorldProviderLimbo;
import org.dimdev.dimdoors.shared.world.pocketdimension.WorldProviderDungeonPocket;

public class EntityMonolith
extends EntityFlying
implements IMob {
    private static final int MAX_AGGRO = 250;
    private static final int MAX_AGGRO_CAP = 100;
    private static final int MIN_AGGRO_CAP = 25;
    private static final int MAX_TEXTURE_STATE = 18;
    private static final int MAX_SOUND_COOLDOWN = 200;
    private static final int MAX_AGGRO_RANGE = 35;
    private static final DataParameter<Integer> AGGRO = EntityDataManager.func_187226_a(EntityMonolith.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final float WIDTH = 3.0f;
    private static final float HEIGHT = 3.0f;
    private static final float EYE_HEIGHT = 1.5f;
    public float pitchLevel;
    private int aggro = 0;
    private int soundTime = 0;
    private final int aggroCap;

    public EntityMonolith(World world) {
        super(world);
        this.func_70105_a(3.0f, 3.0f);
        this.field_70145_X = true;
        this.aggroCap = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)25, (int)100);
        this.func_184224_h(true);
    }

    public boolean isDangerous() {
        return ModConfig.monoliths.monolithTeleportation && (this.field_70170_p.field_73011_w instanceof WorldProviderLimbo || ModConfig.monoliths.dangerousLimboMonoliths);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source != DamageSource.field_76368_d) {
            this.aggro = 250;
        }
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a(57005.0);
    }

    public boolean func_70104_M() {
        return false;
    }

    public float func_70047_e() {
        return 1.5f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGGRO, (Object)0);
    }

    public boolean func_70089_S() {
        return false;
    }

    public void func_70030_z() {
        if (!(this.field_70170_p.field_73011_w instanceof WorldProviderLimbo) && !(this.field_70170_p.field_73011_w instanceof WorldProviderDungeonPocket)) {
            this.func_70106_y();
            super.func_70030_z();
            return;
        }
        super.func_70030_z();
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 35.0);
        boolean visibility = player != null && player.func_70685_l((Entity)this);
        this.updateAggroLevel(player, visibility);
        if (player != null) {
            this.facePlayer(player);
            if (!this.field_70170_p.field_72995_K && this.isDangerous()) {
                this.playSounds(player.func_180425_c());
            }
            if (visibility) {
                if (this.field_70170_p.field_72995_K && this.isDangerous()) {
                    this.spawnParticles(player);
                }
                if (this.aggro >= 250 && !this.field_70170_p.field_72995_K && ModConfig.monoliths.monolithTeleportation && !player.func_184812_l_() && this.isDangerous()) {
                    this.aggro = 0;
                    if (player.field_70170_p.field_73011_w instanceof WorldProviderLimbo && this.field_70170_p.field_73011_w instanceof WorldProviderLimbo) {
                        Location destination = WorldProviderLimbo.getLimboSkySpawn((Entity)player);
                        TeleportUtils.teleport((Entity)player, destination, 0.0f, 0.0f);
                    } else {
                        double x = player.field_70165_t + MathHelper.func_151237_a((double)player.field_70170_p.field_73012_v.nextDouble(), (double)100.0, (double)100.0);
                        double z = player.field_70161_v + MathHelper.func_151237_a((double)player.field_70170_p.field_73012_v.nextDouble(), (double)-100.0, (double)100.0);
                        TeleportUtils.teleport((Entity)player, ModDimensions.getLimboDim(), x, 700.0, z, player.field_70177_z, player.field_70125_A);
                    }
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.CRACK, SoundCategory.HOSTILE, 13.0f, 1.0f);
                }
            }
        }
    }

    private void updateAggroLevel(EntityPlayer player, boolean visibility) {
        if (!this.field_70170_p.field_72995_K) {
            if (visibility) {
                this.aggro = this.field_70170_p.field_73011_w instanceof WorldProviderLimbo ? (this.isDangerous() ? ++this.aggro : (this.aggro += 36)) : (this.aggro += 3);
            } else if (this.isDangerous()) {
                if (this.aggro > this.aggroCap) {
                    --this.aggro;
                } else if (player != null && this.aggro < this.aggroCap) {
                    ++this.aggro;
                }
            } else {
                this.aggro -= 3;
            }
            int maxAggro = this.isDangerous() ? 250 : 180;
            this.aggro = (short)MathHelper.func_76125_a((int)this.aggro, (int)0, (int)maxAggro);
            this.field_70180_af.func_187227_b(AGGRO, (Object)this.aggro);
        } else {
            this.aggro = (Integer)this.field_70180_af.func_187225_a(AGGRO);
        }
    }

    public int getTextureState() {
        return MathHelper.func_76125_a((int)(18 * this.aggro / 250), (int)0, (int)18);
    }

    private void playSounds(BlockPos pos) {
        float aggroPercent = this.getAggroProgress();
        if (this.soundTime <= 0) {
            this.func_184185_a(ModSounds.MONK, 1.0f, 1.0f);
            this.soundTime = 100;
        }
        if ((double)aggroPercent > 0.7 && this.soundTime < 100) {
            this.field_70170_p.func_184133_a(null, pos, ModSounds.TEARING, SoundCategory.HOSTILE, 1.0f, (float)(1.0 + this.field_70146_Z.nextGaussian()));
            this.soundTime = 100 + this.field_70146_Z.nextInt(75);
        }
        if ((double)aggroPercent > 0.8 && this.soundTime < 200) {
            this.field_70170_p.func_184133_a(null, pos, ModSounds.TEARING, SoundCategory.HOSTILE, 7.0f, 1.0f);
            this.soundTime = 250;
        }
        --this.soundTime;
    }

    private void spawnParticles(EntityPlayer player) {
        int count = 10 * this.aggro / 250;
        for (int i = 1; i < count; ++i) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, player.field_70163_u + this.field_70146_Z.nextDouble() * (double)player.field_70131_O - 0.75, player.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)player.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
        }
    }

    public float getAggroProgress() {
        return (float)this.aggro / 250.0f;
    }

    private void facePlayer(EntityPlayer player) {
        double d0 = player.field_70165_t - this.field_70165_t;
        double d1 = player.field_70161_v - this.field_70161_v;
        double d2 = player.field_70163_u + (double)player.func_70047_e() - (this.field_70163_u + 1.5);
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        this.pitchLevel = (float)(-(Math.atan(d2 / d3) * 180.0 / Math.PI));
        this.field_70177_z = f2;
        this.field_70759_as = f2;
        this.field_70761_aq = this.field_70177_z;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Aggro", this.aggro);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.aggro = nbt.func_74762_e("Aggro");
    }
}

