/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client.tesseract;

import com.flowpowered.math.TrigMath;
import com.flowpowered.math.matrix.Matrix4f;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.RGBA;

public class Plane {
    Vector4f[] vectors;

    public Plane(Vector4f vec1, Vector4f vec2, Vector4f vec3, Vector4f vec4) {
        this.vectors = new Vector4f[]{vec1, vec2, vec3, vec4};
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(RGBA color, double radian) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        GlStateManager.func_179131_c((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        Plane.project(worldRenderer, Plane.rotYW(this.vectors[0], radian), 0, 0, color);
        Plane.project(worldRenderer, Plane.rotYW(this.vectors[1], radian), 0, 1, color);
        Plane.project(worldRenderer, Plane.rotYW(this.vectors[2], radian), 1, 1, color);
        Plane.project(worldRenderer, Plane.rotYW(this.vectors[3], radian), 1, 0, color);
        tessellator.func_78381_a();
    }

    private static Vector4f rotXW(Vector4f v, double angle) {
        return Matrix4f.from(TrigMath.cos(angle), 0.0f, 0.0f, TrigMath.sin(angle), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -TrigMath.sin(angle), 0.0f, 0.0f, TrigMath.cos(angle)).transform(v);
    }

    private static Vector4f rotZW(Vector4f v, double angle) {
        return Matrix4f.from(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, TrigMath.cos(angle), -TrigMath.sin(angle), 0.0f, 0.0f, TrigMath.sin(angle), TrigMath.cos(angle)).transform(v);
    }

    private static Vector4f rotYW(Vector4f v, double angle) {
        return Matrix4f.from(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, TrigMath.cos(angle), 0.0f, TrigMath.sin(angle), 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -TrigMath.sin(angle), 0.0f, TrigMath.cos(angle)).transform(v);
    }

    private static Vector4f rotXY(Vector4f v, double angle) {
        return Matrix4f.from(TrigMath.cos(angle), -TrigMath.sin(angle), 0.0f, 0.0f, TrigMath.sin(angle), TrigMath.cos(angle), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).transform(v);
    }

    @SideOnly(value=Side.CLIENT)
    private static void project(BufferBuilder buffer, Vector4f vector, int u, int v, RGBA color) {
        double scalar = 1.0 / (double)(vector.getW() + 1.0f);
        Vector3f vector1 = vector.toVector3().mul(scalar);
        buffer.func_181662_b((double)vector1.getX(), (double)vector1.getY(), (double)vector1.getZ()).func_187315_a((double)u, (double)v).func_181666_a(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }
}

