/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.player;

import ic2.api.classic.event.EnergyUsedEvent;
import ic2.api.classic.event.MachineRecipeEvent;
import ic2.core.IC2;
import ic2.core.inventory.filters.ClassFilter;
import ic2.core.inventory.filters.ListFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.armor.base.ItemArmorElectricJetpackBase;
import ic2.core.item.armor.electric.ItemArmorElectricJetpack;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CraftingHandler {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        IItemTransporter transporter;
        EntityPlayer player = event.player;
        ItemStack stack = event.crafting;
        if (player == null || stack.func_190926_b()) {
            return;
        }
        IC2.achievements.onCrafting(player, stack);
        if (stack.func_77973_b() instanceof ItemArmorElectricJetpackBase && ItemArmorElectricJetpackBase.isArmorRecipe(stack)) {
            transporter = TransporterManager.manager.getTransporter(event.craftMatrix, true);
            ItemStack jetpack = transporter.removeItem(new ClassFilter(ItemArmorElectricJetpackBase.class), null, 1, false);
            ItemStack armor = transporter.removeItem(new ListFilter(ItemArmorElectricJetpackBase.jetpackFilters), null, 1, false);
            if (jetpack != null) {
                ItemStack oldArmor = ItemArmorElectricJetpack.getArmor(jetpack);
                if (oldArmor != null) {
                    player.func_71019_a(oldArmor, false);
                }
                ItemArmorElectricJetpackBase.addJetpackArmor(stack, armor.func_77946_l());
                ItemArmorElectricJetpackBase.addMarkArmorRecipe(stack, false);
                Map map = EnchantmentHelper.func_82781_a((ItemStack)jetpack);
                if (map.size() > 0) {
                    for (Map.Entry entry : map.entrySet()) {
                        stack.func_77966_a((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
                    }
                }
            }
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150343_Z)) {
            transporter = TransporterManager.manager.getTransporter(player, true);
            for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                ItemStack added;
                ItemStack item = event.craftMatrix.func_70301_a(i);
                if (!StackUtil.isStackEqual(item, Ic2Items.waterCell) && !StackUtil.isStackEqual(item, Ic2Items.lavaCell) || !(added = transporter.addItem(Ic2Items.emptyCell.func_77946_l(), null, true)).func_190926_b()) continue;
                player.func_71019_a(Ic2Items.emptyCell.func_77946_l(), true);
            }
        }
    }

    @SubscribeEvent
    public void onFurnaceing(PlayerEvent.ItemSmeltedEvent event) {
        EntityPlayer player = event.player;
        ItemStack stack = event.smelting;
        if (player == null || stack.func_190926_b()) {
            return;
        }
        IC2.achievements.onSmelting(player, stack, false);
    }

    @SubscribeEvent
    public void onSmelting(MachineRecipeEvent.ItemSmeltedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getOutput();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        if (event.isAutomated()) {
            IC2.achievements.issueStat(player, "itemAutoSmelted", stack.func_190916_E());
            IC2.achievements.onSmelting(player, stack, true);
        }
    }

    @SubscribeEvent
    public void onMacerated(MachineRecipeEvent.ItemMaceratedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getOutput();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        IC2.achievements.issueStat(player, event.isAutomated() ? "itemAutoMacerated" : "itemMacerated", stack.func_190916_E());
    }

    @SubscribeEvent
    public void onExtracted(MachineRecipeEvent.ItemExtractedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getOutput();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        IC2.achievements.issueStat(player, event.isAutomated() ? "itemAutoExtracted" : "itemExtracted", stack.func_190916_E());
        IC2.achievements.onExtract(player, stack, event.isAutomated());
    }

    @SubscribeEvent
    public void onCompressed(MachineRecipeEvent.ItemCompressedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getOutput();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        IC2.achievements.issueStat(player, event.isAutomated() ? "itemAutoCompressed" : "itemCompressed", stack.func_190916_E());
    }

    @SubscribeEvent
    public void onRecycled(MachineRecipeEvent.ItemRecycledEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getOutput();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        IC2.achievements.issueStat(player, event.isAutomated() ? "itemAutoRecycled" : "itemRecycled", stack.func_190916_E());
    }

    @SubscribeEvent
    public void onEnergyUsed(EnergyUsedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItem();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        IC2.achievements.issueStat(player, "itemEnergyUsed", event.getUsedEU());
    }

    @SubscribeEvent
    public void onMatterCreated(MachineRecipeEvent.MatterCreatedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getOutput();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        IC2.achievements.issueStat(player, "uuMatterProduced", stack.func_190916_E());
    }
}

