/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.crop;

import ic2.core.IC2;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2People;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemTea
extends ItemIC2
implements IBootable {
    public ItemTea() {
        this.func_77627_a(true);
        this.setTranslationKey(Ic2ItemLang.teaItem);
        this.func_77625_d(16);
    }

    @Override
    public void onLoad() {
        Ic2Items.coldTea = new ItemStack((Item)this, 1, 0);
        Ic2Items.blackTea = new ItemStack((Item)this, 1, 1);
        Ic2Items.tea = new ItemStack((Item)this, 1, 2);
        Ic2Items.iceTea = new ItemStack((Item)this, 1, 3);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.teaCold;
            }
            case 1: {
                return Ic2ItemLang.teaBlack;
            }
            case 2: {
                return Ic2ItemLang.tea;
            }
            case 3: {
                return Ic2ItemLang.teaIce;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 188 + meta;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77960_j() > 0) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            IC2.achievements.issueStat(player, "teaLover");
            this.decreaseEffect(MobEffects.field_76419_f, player, 600);
            this.decreaseEffect(MobEffects.field_76421_d, player, 600);
            this.decreaseEffect(MobEffects.field_76431_k, player, 1200);
            this.decreaseEffect(MobEffects.field_76438_s, player, 2400);
            switch (stack.func_77960_j()) {
                case 1: {
                    this.applyPotionEffect(MobEffects.field_76424_c, 100, 1200, 0, player);
                    this.applyPotionEffect(MobEffects.field_76422_e, 100, 1200, 0, player);
                    break;
                }
                case 2: {
                    this.applyPotionEffect(MobEffects.field_76424_c, 200, 1200, 0, player);
                    this.applyPotionEffect(MobEffects.field_76422_e, 200, 1200, 0, player);
                    this.applyPotionEffect(MobEffects.field_76428_l, 150, 300, 0, player);
                    break;
                }
                case 3: {
                    if (player.func_110124_au().equals(Ic2People.minesasha)) {
                        this.applyPotionEffect(MobEffects.field_76424_c, 1200, 3600, 3, player);
                        this.applyPotionEffect(MobEffects.field_76422_e, 1200, 3600, 3, player);
                        break;
                    }
                    this.applyPotionEffect(MobEffects.field_76424_c, 600, 1200, 1, player);
                    this.applyPotionEffect(MobEffects.field_76422_e, 600, 1200, 1, player);
                }
            }
            stack.func_190918_g(1);
            if (!player.field_71071_by.func_70441_a(Ic2Items.emptyMug.func_77946_l())) {
                player.func_71019_a(Ic2Items.emptyMug.func_77946_l(), false);
            } else {
                player.field_71070_bA.func_75142_b();
            }
        }
        return stack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public void applyPotionEffect(Potion potion, int inc, int max, int amp, EntityPlayer player) {
        PotionEffect ef = player.func_70660_b(potion);
        if (ef == null) {
            ef = new PotionEffect(potion, inc, amp);
            player.func_70690_d(ef);
            return;
        }
        if (ef.func_76458_c() > amp) {
            return;
        }
        int maxTime = Math.min(max, ef.func_76459_b() + inc);
        ef = new PotionEffect(potion, maxTime, amp);
        player.func_70690_d(ef);
    }

    public void decreaseEffect(Potion id, EntityPlayer par1, int amount) {
        if (par1.func_70644_a(id)) {
            PotionEffect ef = par1.func_70660_b(id);
            if (ef.func_76459_b() <= amount) {
                par1.func_184589_d(id);
                return;
            }
            ef = new PotionEffect(ef.func_188419_a(), ef.func_76459_b() - amount, ef.func_76458_c(), ef.func_82720_e(), ef.func_188418_e());
            par1.func_184589_d(id);
            par1.func_70690_d(ef);
        }
    }
}

