/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.base;

import ic2.api.classic.tile.machine.IEUStorage;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GeneratorChargeComp
extends GuiComponent {
    IEUStorage storage;
    Vec2i texPos;

    public GeneratorChargeComp(IEUStorage tile, Box2D box, Vec2i pos) {
        super(box);
        this.storage = tile;
        this.texPos = pos;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        int eu = this.storage.getStoredEU();
        if (eu > 0) {
            Box2D box;
            int maxY;
            int lvl;
            int x = gui.getXOffset();
            int y = gui.getYOffset();
            float per = (float)eu / (float)this.storage.getMaxEU();
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * (float)(maxY = (box = this.getPosition()).getLenght()))) <= 0) {
                return;
            }
            gui.func_73729_b(x + box.getX(), y + box.getY(), this.texPos.getX(), this.texPos.getY(), lvl, 17);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY) && PlayerHandler.getClientPlayerHandler().hasEUReader()) {
            tooltips.add(Ic2InfoLang.euStorage.getLocalizedFormatted(this.storage.getStoredEU(), this.storage.getMaxEU()));
        }
    }
}

