/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity.misc;

import ic2.api.event.LaserEvent;
import ic2.core.IC2;
import ic2.core.entity.explosion.ExplosionIC2;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityMiningLaser
extends Entity
implements IThrowableEntity {
    EntityLivingBase shooter;
    public float range = 0.0f;
    public float power = 0.0f;
    public int blockBreaks = 0;
    public boolean explosive = false;
    public static Set<Block> unmineableBlocks = new HashSet<Block>(Arrays.asList(Blocks.field_150336_V, Blocks.field_150343_Z, Blocks.field_150353_l, Blocks.field_150356_k, Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150357_h));
    public static final double laserSpeed = 1.0;
    public boolean headingSet = false;
    public boolean smelt = false;
    private int ticksInAir = 0;

    public EntityMiningLaser(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive) {
        this(world, entityliving, range, power, blockBreaks, explosive, entityliving.field_70177_z, entityliving.field_70125_A);
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive, boolean isSmelt) {
        this(world, entityliving, range, power, blockBreaks, explosive, entityliving.field_70177_z, entityliving.field_70125_A);
        this.smelt = isSmelt;
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float range, float power, int blockBreaks, boolean explosive, double yawDeg, double pitchDeg) {
        this(world, entityliving, range, power, blockBreaks, explosive, yawDeg, pitchDeg, entityliving.field_70163_u + (double)entityliving.func_70047_e() - 0.1);
    }

    public EntityMiningLaser(World world, EntityLivingBase entityliving, float flyRange, float laserPower, int blockBreaklimit, boolean isExplosive, double yawDeg, double pitchDeg, double y) {
        super(world);
        this.shooter = entityliving;
        this.func_70105_a(0.8f, 0.8f);
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double x = entityliving.field_70165_t - Math.cos(yaw) * 0.16;
        double z = entityliving.field_70161_v - Math.sin(yaw) * 0.16;
        double startMotionX = -Math.sin(yaw) * Math.cos(pitch);
        double startMotionY = -Math.sin(pitch);
        double startMotionZ = Math.cos(yaw) * Math.cos(pitch);
        this.func_70107_b(x, y, z);
        this.setLaserHeading(startMotionX, startMotionY, startMotionZ, 1.0);
        this.setThrower((Entity)entityliving);
        this.range = flyRange;
        this.power = laserPower;
        this.blockBreaks = blockBreaklimit;
        this.explosive = isExplosive;
    }

    public void setLaserHeading(double newMotionX, double newMotionY, double newMotionZ, double speed) {
        double currentSpeed = MathHelper.func_76133_a((double)(newMotionX * newMotionX + newMotionY * newMotionY + newMotionZ * newMotionZ));
        this.field_70159_w = newMotionX / currentSpeed * speed;
        this.field_70181_x = newMotionY / currentSpeed * speed;
        this.field_70179_y = newMotionZ / currentSpeed * speed;
        this.field_70126_B = this.field_70177_z = (float)Math.toDegrees(Math.atan2(this.field_70159_w, this.field_70179_y));
        this.field_70127_C = this.field_70125_A = (float)Math.toDegrees(Math.atan2(this.field_70181_x, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))));
        this.headingSet = true;
    }

    public Entity getThrower() {
        return this.shooter;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.shooter = (EntityLivingBase)entity;
        }
    }

    public void clearThrower() {
        this.shooter = null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean isServer = IC2.platform.isSimulating();
        if (isServer && (this.range < 1.0f || this.power <= 0.0f || this.blockBreaks <= 0)) {
            if (this.explosive) {
                this.explode();
            }
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        Vec3d oldPosition = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d newPosition = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceResult = this.field_70170_p.func_147447_a(oldPosition, newPosition, false, true, false);
        oldPosition = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        newPosition = raytraceResult != null ? new Vec3d(raytraceResult.field_72307_f.field_72450_a, raytraceResult.field_72307_f.field_72448_b, raytraceResult.field_72307_f.field_72449_c) : new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(this.field_70159_w, this.field_70181_x, this.field_70179_y));
        Entity target = null;
        if (list.size() > 0) {
            double shortestDistance = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double distance;
                AxisAlignedBB box;
                RayTraceResult result;
                Entity check = (Entity)list.get(i);
                if (!check.func_70067_L() || check == this.shooter && this.ticksInAir < 5 || (result = (box = check.func_174813_aQ().func_186662_g(0.3)).func_72327_a(oldPosition, newPosition)) == null || !((distance = oldPosition.func_72438_d(result.field_72307_f)) < shortestDistance) && shortestDistance != 0.0) continue;
                target = check;
                shortestDistance = distance;
            }
        }
        if (target != null) {
            raytraceResult = new RayTraceResult(target);
        }
        if (raytraceResult != null && isServer) {
            if (this.explosive) {
                if (!this.canHitPlayer(raytraceResult)) {
                    this.func_70106_y();
                    return;
                }
                this.explode();
                this.func_70106_y();
                return;
            }
            if (raytraceResult.field_72308_g != null) {
                LaserEvent.LaserHitsEntityEvent tEvent = new LaserEvent.LaserHitsEntityEvent(this.field_70170_p, this, this.shooter, this.range, this.power, this.blockBreaks, this.explosive, this.smelt, raytraceResult.field_72308_g);
                MinecraftForge.EVENT_BUS.post((Event)tEvent);
                if (this.takeDataFromEvent(tEvent)) {
                    int damage = (int)this.power;
                    if (damage > 0 && this.canHitPlayer(raytraceResult)) {
                        EntityDragon dragon;
                        Entity entity;
                        if (target != null) {
                            target.func_70015_d(damage * (this.smelt ? 2 : 1));
                        }
                        if ((entity = tEvent.hitEntity) instanceof EntityEnderman) {
                            entity.func_70097_a(new EntityDamageSource("arrow", (Entity)this).func_76349_b(), (float)damage);
                        } else if (tEvent.hitEntity.func_70097_a(new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this.shooter).func_76349_b(), (float)damage) && this.shooter instanceof EntityPlayer && (dragon = this.getDragon(tEvent.hitEntity)) != null && dragon.func_110143_aJ() <= 1.0f) {
                            IC2.achievements.issueStat((EntityPlayer)this.shooter, "dragonsLasered");
                        }
                        if (!tEvent.hitEntity.func_70089_S() && this.shooter instanceof EntityPlayer) {
                            IC2.achievements.issueStat((EntityPlayer)this.shooter, "laserKills");
                        }
                    }
                    this.func_70106_y();
                }
            } else {
                LaserEvent.LaserHitsBlockEvent tEvent = new LaserEvent.LaserHitsBlockEvent(this.field_70170_p, this, this.shooter, this.range, this.power, this.blockBreaks, this.explosive, this.smelt, raytraceResult.func_178782_a(), raytraceResult.field_178784_b, 0.9f, true, true);
                MinecraftForge.EVENT_BUS.post((Event)tEvent);
                if (this.takeDataFromEvent(tEvent)) {
                    IBlockState state = this.field_70170_p.func_180495_p(tEvent.pos);
                    Block block = state.func_177230_c();
                    int meta = block.func_176201_c(state);
                    if (!(this.field_70170_p.func_175623_d(tEvent.pos) || Item.func_150898_a((Block)block) != null && this.isBlockGlass(new ItemStack(block, 1, meta)))) {
                        if (!this.canMine(tEvent, block)) {
                            this.func_70106_y();
                        } else if (isServer) {
                            float resis = block.getExplosionResistance(this.field_70170_p, tEvent.pos, (Entity)this, new Explosion(this.field_70170_p, (Entity)this, (double)tEvent.pos.func_177958_n(), (double)tEvent.pos.func_177956_o(), (double)tEvent.pos.func_177952_p(), tEvent.power, false, false));
                            this.power -= resis / 10.0f;
                            if (this.power >= 0.0f) {
                                if (state.func_185904_a() == Material.field_151590_u) {
                                    block.onBlockExploded(this.field_70170_p, tEvent.pos, new Explosion(this.field_70170_p, (Entity)this, (double)tEvent.pos.func_177958_n(), (double)tEvent.pos.func_177956_o(), (double)tEvent.pos.func_177952_p(), 1.0f, false, false));
                                } else if (this.smelt) {
                                    if (state.func_185904_a() == Material.field_151575_d) {
                                        tEvent.dropBlock = false;
                                    } else {
                                        for (ItemStack isa : block.getDrops((IBlockAccess)this.field_70170_p, tEvent.pos, state, 0)) {
                                            ItemStack is = FurnaceRecipes.func_77602_a().func_151395_a(isa);
                                            if (is == null) continue;
                                            Block newBlock = Block.func_149634_a((Item)is.func_77973_b());
                                            if (newBlock != null && newBlock != block) {
                                                tEvent.removeBlock = false;
                                                tEvent.dropBlock = false;
                                                this.field_70170_p.func_180501_a(tEvent.pos, newBlock.func_176203_a(is.func_77973_b().func_77647_b(is.func_77960_j())), 7);
                                            } else {
                                                tEvent.dropBlock = false;
                                                float var6 = 0.7f;
                                                double var7 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                                double var9 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                                double var11 = (double)(this.field_70170_p.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
                                                EntityItem var13 = new EntityItem(this.field_70170_p, (double)tEvent.pos.func_177958_n() + var7, (double)tEvent.pos.func_177956_o() + var9, (double)tEvent.pos.func_177952_p() + var11, is.func_77946_l());
                                                var13.func_174869_p();
                                                this.field_70170_p.func_72838_d((Entity)var13);
                                            }
                                            this.power = 0.0f;
                                        }
                                    }
                                }
                                if (tEvent.removeBlock) {
                                    if (tEvent.dropBlock) {
                                        block.func_180653_a(this.field_70170_p, tEvent.pos, state, tEvent.dropChance, 0);
                                    }
                                    this.field_70170_p.func_175698_g(tEvent.pos);
                                    if (this.shooter instanceof EntityPlayer) {
                                        IC2.achievements.issueStat((EntityPlayer)this.shooter, "blocksLasered");
                                    }
                                    if (this.field_70170_p.field_73012_v.nextInt(10) == 0 && state.func_185904_a().func_76217_h()) {
                                        this.field_70170_p.func_180501_a(tEvent.pos, Blocks.field_150480_ab.func_176223_P(), 7);
                                    }
                                }
                                --this.blockBreaks;
                            }
                        }
                    }
                }
            }
        } else if (isServer) {
            this.power -= 0.5f;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.range -= 0.02f;
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
    }

    public boolean canHitPlayer(RayTraceResult result) {
        if (this.shooter instanceof EntityPlayer && result.field_72308_g instanceof EntityPlayer) {
            return ((EntityPlayer)result.field_72308_g).func_96122_a((EntityPlayer)this.shooter);
        }
        return true;
    }

    public EntityDragon getDragon(Entity entity) {
        if (entity instanceof EntityDragon) {
            return (EntityDragon)entity;
        }
        if (entity instanceof MultiPartEntityPart) {
            return this.getDragon((Entity)((MultiPartEntityPart)entity).field_70259_a);
        }
        return null;
    }

    public void explode() {
        if (IC2.platform.isSimulating()) {
            LaserEvent.LaserExplodesEvent tEvent = new LaserEvent.LaserExplodesEvent(this.field_70170_p, this, this.shooter, this.range, this.power, this.blockBreaks, this.explosive, this.smelt, 5.0f, 0.85f, 0.55f);
            MinecraftForge.EVENT_BUS.post((Event)tEvent);
            if (this.takeDataFromEvent(tEvent)) {
                ExplosionIC2 explosion = new ExplosionIC2(this.field_70170_p, null, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), 4.0f, tEvent.explosionDropRate, this.power, DamageSource.field_76377_j);
                explosion.doExplosion();
            }
        }
    }

    public boolean takeDataFromEvent(LaserEvent aEvent) {
        this.shooter = aEvent.owner;
        this.range = aEvent.range;
        this.power = aEvent.power;
        this.blockBreaks = aEvent.blockBreaks;
        this.explosive = aEvent.explosive;
        this.smelt = aEvent.smelt;
        if (aEvent.isCanceled()) {
            this.func_70106_y();
            return false;
        }
        return true;
    }

    public boolean canMine(LaserEvent.LaserHitsBlockEvent evt, Block block) {
        BlockEvent.BreakEvent event = this.getEventFromEvent(evt);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        return !unmineableBlocks.contains(block);
    }

    public BlockEvent.BreakEvent getEventFromEvent(LaserEvent.LaserHitsBlockEvent evt) {
        Object player = null;
        player = evt.owner instanceof EntityPlayer ? (EntityPlayer)evt.owner : FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)evt.getWorld()));
        return new BlockEvent.BreakEvent(evt.getWorld(), evt.pos, evt.getWorld().func_180495_p(evt.pos), player);
    }

    public boolean isBlockGlass(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        if (StackUtil.isStackEqual(item, Ic2Items.reinforcedGlass)) {
            return true;
        }
        return StackUtil.hasOreTag("blockGlass", item) || StackUtil.hasOreTag("paneGlass", item);
    }

    protected void func_70088_a() {
    }

    public double func_70033_W() {
        return 0.0;
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

