/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.logic.encoder.impl;

import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.PlannerRegistry;
import ic2.core.block.machine.med.logic.ReactorLogicBase;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.block.machine.med.logic.encoder.IEncoder;
import ic2.core.util.misc.StackUtil;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class V2Encoder
implements IEncoder {
    @Override
    public NBTTagCompound createDecodedData(String data) {
        ByteShifter shifter = new ByteShifter(data);
        if (shifter.readInt(2) != 2) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("steam", shifter.readBoolean());
        nbt.func_74768_a("size", shifter.readInt(3));
        nbt.func_74768_a("max_heat", shifter.readBoolean() ? shifter.readInt(shifter.readBoolean() ? 20 : 15) : 0);
        StringBuilder name = new StringBuilder(63);
        for (int i = shifter.readInt(6); i > 0; --i) {
            name.append((char)shifter.readChar());
        }
        nbt.func_74778_a("name", name.reverse().toString());
        ShortArrayList list = new ShortArrayList();
        int idBits = shifter.readInt(4) + 1;
        int m = shifter.readInt(6);
        for (int i = 0; i < m; ++i) {
            list.add((short)shifter.readInt(idBits));
        }
        NBTTagList slotList = new NBTTagList();
        int bits = shifter.readInt(4) + 1;
        int m2 = shifter.readInt(9);
        for (int x = 8; x >= 0; --x) {
            if ((m2 & 1 << x) == 0) continue;
            int n = shifter.readInt(6);
            for (int y = 5; y >= 0; --y) {
                if ((n & 1 << y) == 0) continue;
                short id = list.getShort(shifter.readInt(bits));
                int size = shifter.readBoolean() ? shifter.readInt(6) + 1 : 1;
                slotList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{x, y, id, size}));
            }
        }
        nbt.func_74782_a("items", (NBTBase)slotList);
        return nbt;
    }

    @Override
    public void processData(NBTTagCompound decodedData, TileEntityReactorPlanner planner) {
        planner.isSteamReactor = decodedData.func_74767_n("steam");
        planner.reactorSize = decodedData.func_74762_e("size");
        planner.setupName = decodedData.func_74779_i("name");
        planner.getUserSettings().startingHeat = decodedData.func_74762_e("max_heat");
        NBTTagList list = decodedData.func_150295_c("items", 11);
        ReactorLogicBase base = planner.getReactorLogic();
        boolean valid = false;
        int m = list.func_74745_c();
        for (int i = 0; i < m; ++i) {
            int[] array = list.func_150306_c(i);
            ItemStack stack = PlannerRegistry.getComponentFromID((short)array[2]);
            if (stack.func_190926_b()) continue;
            base.setStackInSlot(array[1] * 9 + array[0], StackUtil.copyWithSize(stack.func_77946_l(), array[3]));
            valid = true;
        }
        if (valid) {
            base.validate();
        }
    }

    @Override
    public String createEncodedData(TileEntityReactorPlanner planner) {
        short[] slotToId = new short[54];
        Arrays.fill(slotToId, (short)-1);
        int largestId = 0;
        ReactorLogicBase logic = planner.getReactorLogic();
        ShortOpenHashSet storage = new ShortOpenHashSet();
        for (int i = 0; i < 54; ++i) {
            short id;
            ItemStack stack = logic.getStackInSlot(i);
            if (stack.func_190926_b() || (id = PlannerRegistry.getID(stack)) >> this.getBitLimit() > 0) continue;
            storage.add(id);
            slotToId[i] = id;
            largestId = Math.max(id, largestId);
        }
        ShortArrayList list = new ShortArrayList((ShortCollection)storage);
        int bits = Integer.bitCount(HashCommon.nextPowerOfTwo((int)(list.size() + 1)) - 1);
        ByteShifter shifter = new ByteShifter();
        int rows = 0;
        int m = planner.reactorSize + 3;
        for (int x = 0; x < m; ++x) {
            int count = 0;
            for (int y = 0; y < 6; ++y) {
                short id;
                ItemStack stack = logic.getStackInSlot(y * 9 + x);
                if (stack.func_190926_b() || (id = slotToId[y * 9 + x]) < 0) continue;
                int size = stack.func_190916_E();
                if (size > 1) {
                    shifter.writeInteger(size - 1, 6);
                }
                shifter.writeBoolean(size > 1);
                shifter.writeInteger(list.indexOf(id), bits);
                count |= 1 << y;
            }
            if (count <= 0) continue;
            shifter.writeInteger(count, 6);
            rows |= 1 << x;
        }
        shifter.writeInteger(rows, 9);
        shifter.writeInteger(bits - 1, 4);
        int idBits = Integer.bitCount(HashCommon.nextPowerOfTwo((int)(largestId + 1)) - 1);
        for (int i = list.size() - 1; i >= 0; --i) {
            shifter.writeInteger(list.getShort(i), idBits);
        }
        shifter.writeInteger(list.size(), 6);
        shifter.writeInteger(idBits - 1, 4);
        char[] chars = planner.setupName.toCharArray();
        for (int i = 0; i < chars.length && i < 63; ++i) {
            shifter.writeCharacter(chars[i]);
        }
        shifter.writeInteger(Math.min(63, chars.length), 6);
        int heat = Math.max(0, Math.min(planner.getReactorLogic().maxHeat - 100, planner.getUserSettings().startingHeat));
        if (heat > 0) {
            int heatBitsRequired = Integer.bitCount(HashCommon.nextPowerOfTwo((int)(heat + 1)) - 1);
            shifter.writeInteger(heat, heatBitsRequired > 15 ? 20 : 15);
            shifter.writeBoolean(heatBitsRequired > 15);
        }
        shifter.writeBoolean(heat > 0);
        shifter.writeInteger(planner.reactorSize, 3);
        shifter.writeBoolean(planner.isSteamReactor);
        shifter.writeInteger(2, 2);
        return shifter.getDataCode();
    }

    @Override
    public String getName() {
        return "V2 Encoder (1.19.2)";
    }

    @Override
    public boolean hasBitLimit() {
        return true;
    }

    @Override
    public int getBitLimit() {
        return 10;
    }
}

