/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import com.mohistmc.configuration.MohistConfig;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.bukkit.Bukkit;
import org.spigotmc.RestartCommand;

public class WatchdogThread
extends Thread {
    private static WatchdogThread instance;
    private final long timeoutTime;
    private final boolean restart;
    private volatile long lastTick;
    private volatile boolean stopping;
    private final Thread primaryThread;

    private WatchdogThread(long timeoutTime, boolean restart) {
        super("Mohist Watchdog Thread");
        this.timeoutTime = timeoutTime;
        this.restart = restart;
        this.primaryThread = MinecraftServer.getServerInst().primaryThread;
    }

    public static void doStart(int timeoutTime, boolean restart) {
        if (instance == null) {
            instance = new WatchdogThread((long)timeoutTime * 1000L, restart);
            instance.start();
        }
    }

    public static void tick() {
        if (MohistConfig.instance.getBoolean("mohist.watchdog_spigot")) {
            WatchdogThread.instance.lastTick = System.currentTimeMillis();
        }
    }

    public static void doStop() {
        if (instance != null) {
            WatchdogThread.instance.stopping = true;
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            if (this.lastTick != 0L && System.currentTimeMillis() > this.lastTick + this.timeoutTime) {
                ThreadInfo[] threads;
                Logger log = Bukkit.getServer().getLogger();
                log.log(Level.SEVERE, "The server has stopped responding!");
                log.log(Level.SEVERE, "Mohist version: " + Bukkit.getServer().getVersion());
                log.log(Level.SEVERE, "Memory using: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "MB/" + Runtime.getRuntime().totalMemory() / 0x100000L + "MB/" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB");
                if (amu.haveWeSilencedAPhysicsCrash) {
                    log.log(Level.SEVERE, "------------------------------");
                    log.log(Level.SEVERE, "During the run of the server, a physics stackoverflow was supressed");
                    log.log(Level.SEVERE, "near " + amu.blockLocation);
                }
                log.log(Level.SEVERE, "------------------------------");
                log.log(Level.SEVERE, "Server thread dump (Look for plugins here before reporting to Mohist!):");
                WatchdogThread.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(this.primaryThread.getId(), Integer.MAX_VALUE), log);
                log.log(Level.SEVERE, "------------------------------");
                log.log(Level.SEVERE, "Entire Thread Dump:");
                for (ThreadInfo thread : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                    WatchdogThread.dumpThread(thread, log);
                }
                log.log(Level.SEVERE, "------------------------------");
                this.primaryThread.checkAccess();
                new Timer("WatchdogHaltTask").schedule(new TimerTask(){

                    @Override
                    public void run() {
                        FMLCommonHandler.instance().exitJava(0, true);
                    }
                }, 300000L);
                if (!this.restart) break;
                RestartCommand.restart();
                break;
            }
            try {
                WatchdogThread.sleep(10000L);
            }
            catch (InterruptedException ex2) {
                this.interrupt();
            }
        }
    }

    private static void dumpThread(ThreadInfo thread, Logger log) {
        log.log(Level.SEVERE, "------------------------------");
        log.log(Level.SEVERE, "Current Thread: " + thread.getThreadName());
        log.log(Level.SEVERE, "\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + (Object)((Object)thread.getThreadState()));
        if (thread.getLockedMonitors().length != 0) {
            log.log(Level.SEVERE, "\tThread is waiting on monitor(s):");
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                log.log(Level.SEVERE, "\t\tLocked on:" + monitor.getLockedStackFrame());
            }
        }
        log.log(Level.SEVERE, "\tStack:");
        for (StackTraceElement stack : thread.getStackTrace()) {
            log.log(Level.SEVERE, "\t\t" + stack);
        }
    }
}

