/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.core;

import info.tehnut.soulshardsrespawn.SoulShards;
import info.tehnut.soulshardsrespawn.api.BindingEvent;
import info.tehnut.soulshardsrespawn.api.ISoulWeapon;
import info.tehnut.soulshardsrespawn.core.RegistrarSoulShards;
import info.tehnut.soulshardsrespawn.core.data.Binding;
import info.tehnut.soulshardsrespawn.core.data.MultiblockPattern;
import info.tehnut.soulshardsrespawn.core.data.Tier;
import info.tehnut.soulshardsrespawn.item.ItemSoulShard;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="soulshardsrespawn")
public class EventHandler {
    @SubscribeEvent
    public static void onEntityKill(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        if (!SoulShards.CONFIG.allowFakePlayers() && event.getSource().func_76346_g() instanceof FakePlayer) {
            return;
        }
        if (!SoulShards.CONFIG.isEntityEnabled(event.getEntityLiving().getClass())) {
            return;
        }
        if (!SoulShards.CONFIG.allowBossSpawns() && !event.getEntityLiving().func_184222_aU()) {
            return;
        }
        if (!SoulShards.CONFIG.countCageBornForShard() && event.getEntityLiving().getEntityData().func_74767_n("cageBorn")) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (player instanceof FakePlayer) {
                return;
            }
            BindingEvent.GetEntityName getEntityName = new BindingEvent.GetEntityName(event.getEntityLiving());
            MinecraftForge.EVENT_BUS.post((Event)getEntityName);
            ResourceLocation entityId = getEntityName.getEntityId() == null ? EntityList.func_191301_a((Entity)event.getEntityLiving()) : getEntityName.getEntityId();
            ItemStack shardItem = EventHandler.getFirstShard(player, entityId);
            if (shardItem.func_190926_b()) {
                return;
            }
            ItemSoulShard soulShard = (ItemSoulShard)shardItem.func_77973_b();
            boolean newItem = false;
            Binding binding = soulShard.getBinding(shardItem);
            if (binding == null) {
                BindingEvent.NewBinding newBinding = new BindingEvent.NewBinding(event.getEntityLiving(), new Binding(null, 0));
                if (MinecraftForge.EVENT_BUS.post((Event)newBinding)) {
                    return;
                }
                if (shardItem.func_190916_E() > 1) {
                    shardItem = shardItem.func_77979_a(1);
                    newItem = true;
                }
                binding = (Binding)newBinding.getBinding();
            }
            ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
            int soulsGained = 1 + EnchantmentHelper.func_77506_a((Enchantment)RegistrarSoulShards.SOUL_STEALER, (ItemStack)mainHand);
            if (mainHand.func_77973_b() instanceof ISoulWeapon) {
                soulsGained += ((ISoulWeapon)mainHand.func_77973_b()).getSoulBonus(mainHand, player, event.getEntityLiving());
            }
            BindingEvent.GainSouls gainSouls = new BindingEvent.GainSouls(event.getEntityLiving(), binding, soulsGained);
            MinecraftForge.EVENT_BUS.post((Event)gainSouls);
            if (binding.getBoundEntity() == null) {
                binding.setBoundEntity(entityId);
            }
            if (binding.getOwner() == null) {
                binding.setOwner(player.func_146103_bH().getId());
            }
            soulShard.updateBinding(shardItem, binding.addKills(gainSouls.getAmount()));
            if (newItem) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)shardItem);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        MultiblockPattern pattern = SoulShards.CONFIG.getMultiblockPattern();
        ItemStack held = event.getEntityPlayer().func_184586_b(event.getHand());
        if (!ItemStack.func_179545_c((ItemStack)held, (ItemStack)pattern.getCatalyst())) {
            return;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        if (!pattern.isOriginBlock(state)) {
            return;
        }
        ActionResult<Set<BlockPos>> matched = pattern.match(event.getWorld(), event.getPos());
        if (matched.func_188397_a() != EnumActionResult.SUCCESS) {
            return;
        }
        for (BlockPos pos : (Set)matched.func_188398_b()) {
            event.getWorld().func_175655_b(pos, false);
        }
        held.func_190918_g(1);
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.getEntityPlayer(), (ItemStack)new ItemStack(RegistrarSoulShards.SOUL_SHARD));
    }

    @SubscribeEvent
    public static void onAnvil(AnvilUpdateEvent event) {
        if (!SoulShards.CONFIG.allowShardCombination()) {
            return;
        }
        if (event.getLeft().func_77973_b() instanceof ItemSoulShard && event.getRight().func_77973_b() instanceof ItemSoulShard) {
            Binding left = ((ItemSoulShard)event.getLeft().func_77973_b()).getBinding(event.getLeft());
            Binding right = ((ItemSoulShard)event.getRight().func_77973_b()).getBinding(event.getRight());
            if (left == null || right == null) {
                return;
            }
            if (left.getBoundEntity() != null && left.getBoundEntity().equals((Object)right.getBoundEntity())) {
                ItemStack output = new ItemStack(RegistrarSoulShards.SOUL_SHARD);
                ((ItemSoulShard)output.func_77973_b()).updateBinding(output, left.addKills(right.getKills()));
                event.setOutput(output);
                event.setCost(left.getTier().getIndex() * 6);
            }
        }
    }

    @SubscribeEvent
    public static void dropExperience(LivingExperienceDropEvent event) {
        if (!SoulShards.CONFIG.dropExperience() && event.getEntityLiving().getEntityData().func_74767_n("cageBorn")) {
            event.setCanceled(true);
        }
    }

    @Nonnull
    public static ItemStack getFirstShard(EntityPlayer player, ResourceLocation entityId) {
        ItemStack shardItem = player.func_184586_b(EnumHand.OFF_HAND);
        if (shardItem.func_190926_b() || !(shardItem.func_77973_b() instanceof ItemSoulShard)) {
            for (int i = 0; i < 9; ++i) {
                shardItem = player.field_71071_by.func_70301_a(i);
                if (shardItem.func_190926_b() || !(shardItem.func_77973_b() instanceof ItemSoulShard)) continue;
                Binding binding = ((ItemSoulShard)shardItem.func_77973_b()).getBinding(shardItem);
                if (binding == null || binding.getBoundEntity() == null) {
                    return shardItem;
                }
                if (!binding.getBoundEntity().equals((Object)entityId) || binding.getKills() >= Tier.maxKills) continue;
                return shardItem;
            }
        } else {
            Binding binding = ((ItemSoulShard)shardItem.func_77973_b()).getBinding(shardItem);
            if (binding == null || binding.getBoundEntity() == null) {
                return shardItem;
            }
            if (binding.getBoundEntity().equals((Object)entityId) && binding.getKills() < Tier.maxKills) {
                return shardItem;
            }
        }
        return ItemStack.field_190927_a;
    }
}

