/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.tconstruct.oredictcache.mixin;

import java.io.File;
import java.io.IOException;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.mods.tconstruct.oredictcache.UTOreDictCache;
import mod.acgaming.universaltweaks.mods.tconstruct.oredictcache.UTOreDictRecipesState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

@Mixin(value={TinkerSmeltery.class}, remap=false)
public class UTTinkerSmelteryMixin {
    @Inject(method={"registerRecipeOredictMelting"}, at={@At(value="HEAD")}, cancellable=true)
    private static void utRegisterRecipeOredictMeltingHead(CallbackInfo ci) {
        if (UTOreDictRecipesState.getCurrentState().isRead()) {
            NBTTagCompound cacheNBT = UTOreDictCache.cacheNBT;
            NBTTagList recipeList = cacheNBT.func_150295_c("Recipes", 10);
            for (NBTBase nbtBase : recipeList) {
                NBTTagCompound compound = (NBTTagCompound)nbtBase;
                ItemStack item = new ItemStack(compound.func_74775_l("item"));
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluid"));
                if (item.func_190926_b() || fluid == null) continue;
                TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((ItemStack)item, (int)fluid.amount), fluid));
            }
            ci.cancel();
        }
    }

    @Inject(method={"registerRecipeOredictMelting"}, at={@At(value="TAIL")})
    private static void utRegisterRecipeOredictMeltingTail(CallbackInfo ci) {
        if (UTOreDictRecipesState.getCurrentState().isScan()) {
            try {
                File file = UTOreDictCache.cacheFile;
                if (!file.exists()) {
                    file.createNewFile();
                }
                CompressedStreamTools.func_74795_b((NBTTagCompound)UTOreDictCache.cacheNBT, (File)UTOreDictCache.cacheFile);
            }
            catch (IOException e) {
                UniversalTweaks.LOGGER.error("UTTinkerSmeltery ::: Failed to write cache file", (Throwable)e);
            }
        }
    }

    @Redirect(method={"registerRecipeOredictMelting"}, at=@At(value="INVOKE", target="Lslimeknights/tconstruct/library/TinkerRegistry;registerMelting(Lslimeknights/tconstruct/library/smeltery/MeltingRecipe;)V"))
    private static void utRegisterMelting(MeltingRecipe recipe) {
        TinkerRegistry.registerMelting((MeltingRecipe)recipe);
        if (UTOreDictRecipesState.getCurrentState().isScan()) {
            NBTTagCompound cacheNBT = UTOreDictCache.cacheNBT;
            if (!cacheNBT.func_74764_b("Recipes")) {
                cacheNBT.func_74782_a("Recipes", (NBTBase)new NBTTagList());
            }
            NBTTagList recipeList = cacheNBT.func_150295_c("Recipes", 10);
            NBTTagCompound recipeNBT = new NBTTagCompound();
            ItemStack input = (ItemStack)recipe.input.getInputs().get(0);
            FluidStack output = recipe.output;
            if (!input.func_190926_b() && FluidRegistry.isFluidRegistered((Fluid)output.getFluid())) {
                recipeNBT.func_74782_a("item", (NBTBase)input.serializeNBT());
                recipeNBT.func_74782_a("fluid", (NBTBase)UTTinkerSmelteryMixin.fluidToNBT(output));
                recipeList.func_74742_a((NBTBase)recipeNBT);
            }
        }
    }

    @Unique
    private static NBTTagCompound fluidToNBT(FluidStack fluidStack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("FluidName", fluidStack.getFluid().getName());
        nbt.func_74768_a("Amount", fluidStack.amount);
        if (fluidStack.tag != null) {
            nbt.func_74782_a("Tag", (NBTBase)fluidStack.tag);
        }
        return nbt;
    }
}

