/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.main;

import drew6017.lr.api.Module;
import drew6017.lr.api.proto.DelayedLRProtocolResult;
import drew6017.lr.api.proto.LRProtocol;
import drew6017.lr.api.proto.LRProtocolResult;
import drew6017.lr.api.proto.Protocol;
import drew6017.lr.inf.Help;
import drew6017.lr.main.Events;
import drew6017.lr.main.LRCommand;
import drew6017.lr.main.TPS;
import drew6017.lr.main.Updater;
import drew6017.lr.util.DoubleVar;
import drew6017.lr.util.LRConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.zip.ZipFile;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LaggRemover
extends JavaPlugin
implements Listener {
    public static final String config_version = "0.1.7";
    public static final int wipeConfigLowerThan = 16;
    public static final long MEMORY_MBYTE_SIZE = 1024L;
    public static final int MAX_PING_SIZE = 10000;
    public static LaggRemover lr;
    public static String prefix;
    public static File modDir;
    private static HashMap<Module, String[]> loaded;

    public void onEnable() {
        lr = this;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new TPS(), 100L, 1L);
        Help.init();
        Protocol.init();
        LRConfig.init();
        if (this.getConfig().getBoolean("splashScreen")) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            InputStream in = LaggRemover.class.getResourceAsStream("/drew6017/lr/assets/splash.txt");
            byte[] buff = new byte[512];
            try {
                int spi;
                while ((spi = in.read(buff)) != -1) {
                    bo.write(buff, 0, spi);
                }
                in.close();
                bo.flush();
                String splashText = new String(bo.toByteArray());
                System.out.println(splashText);
            }
            catch (IOException e) {
                this.getLogger().warning("Could not load splash screen.");
            }
        }
        loaded = new HashMap();
        prefix = this.getConfig().getString("prefix").replaceAll("&", "\u00a7");
        if (LRConfig.autoChunk) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)lr, new Runnable(){

                @Override
                public void run() {
                    for (World world : LaggRemover.this.getServer().getWorlds()) {
                        if (world.getPlayers().size() != 0) continue;
                        for (Chunk chunk : world.getLoadedChunks()) {
                            world.unloadChunk(chunk);
                        }
                    }
                }
            }, 200L, 200L);
        }
        if (LRConfig.autoLagRemoval) {
            this.autoLagRemovalLoop();
        }
        if (!(modDir = new File(this.getDataFolder(), "Modules")).exists()) {
            modDir.mkdirs();
        }
        for (File f : modDir.listFiles()) {
            if (f.isDirectory() || !f.getName().endsWith(".jar")) continue;
            try {
                URL[] classes = new URL[]{f.toURI().toURL()};
                URLClassLoader loader = new URLClassLoader(classes, LaggRemover.class.getClassLoader());
                ZipFile i = new ZipFile(f);
                YamlConfiguration c = new YamlConfiguration();
                c.load((Reader)new InputStreamReader(i.getInputStream(i.getEntry("module.yml"))));
                String name = c.getString("name");
                String version = c.getString("version");
                String author = c.getString("author");
                this.getLogger().info("Loading module \"" + name + "-" + version + "\" created by \"" + author + "\"...");
                Class<?> plugin = Class.forName(c.getString("main"), true, loader);
                Module m = (Module)plugin.newInstance();
                loaded.put(m, new String[]{name, version, author});
                m.onEnable();
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InvalidConfigurationException e) {
                this.getLogger().info("LaggRemover located an invalid module named \"" + f.getName() + "\"");
            }
        }
        this.getLogger().info("Loaded " + Integer.toString(loaded.size()) + " module(s)");
        if (LRConfig.isAIActive) {
            this.getLogger().info("The LaggRemover AI is now active!");
        }
        this.getLogger().info("LaggRemover has been enabled!");
        if (this.getConfig().getBoolean("auto-update")) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    new Updater((Plugin)lr, 91200, LaggRemover.this.getFile(), Updater.UpdateType.DEFAULT, true);
                }
            }, 0L, 144000L);
        }
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)lr);
        for (Module m : loaded.keySet()) {
            m.onDisable();
        }
        lr = null;
        this.getLogger().info("LaggRemover has been disabled!");
    }

    public static String[] getModulesList() {
        StringBuilder sb = new StringBuilder();
        for (String[] s : loaded.values()) {
            sb.append(s[0]);
            sb.append(", ");
        }
        String sbs = sb.toString();
        if (!sbs.equals("")) {
            sbs = sbs.substring(0, sbs.length() - 2);
        }
        return new String[]{sbs, Integer.toString(loaded.size())};
    }

    public static String[] getProtocolList() {
        StringBuilder sb = new StringBuilder();
        Collection<LRProtocol> protocols = Protocol.getProtocols();
        for (LRProtocol p : protocols) {
            sb.append(p.id());
            sb.append(", ");
        }
        String sbs = sb.toString();
        if (!sbs.equals("")) {
            sbs = sbs.substring(0, sbs.length() - 2);
        }
        return new String[]{sbs, Integer.toString(protocols.size())};
    }

    @EventHandler
    public void onSpawn(EntitySpawnEvent e) {
        Entity ent = e.getEntity();
        if (!ent.hasMetadata("NPC") && LRConfig.thinMobs && ent.getLocation().getChunk().getEntities().length > LRConfig.thinAt) {
            e.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player p = sender instanceof Player ? (Player)sender : null;
        if (cmd.getName().equalsIgnoreCase("lr")) {
            if (args.length == 0) {
                Help.send(p, 1);
            } else if (!LRCommand.onCommand(p, args)) {
                for (Module m : loaded.keySet()) {
                    if (!m.onCommand(sender, label, args)) continue;
                    return true;
                }
                Help.sendMsg(p, "\u00a7cCommand not found! Use /lr help for a list of commands.", true);
            }
            return true;
        }
        return true;
    }

    public static void broadcast(String msg) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(msg);
        }
    }

    public static String[] getData(Module m) {
        return loaded.get(m);
    }

    private void autoLagRemovalLoop() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (LRProtocol p : LRConfig.periodic_protocols.keySet()) {
                    DoubleVar<Object[], Boolean> dat = LRConfig.periodic_protocols.get(p);
                    if (dat.getVar2().booleanValue()) {
                        Protocol.rund(p, dat.getVar1(), new DelayedLRProtocolResult(){

                            @Override
                            public void receive(LRProtocolResult result) {
                            }
                        });
                        continue;
                    }
                    p.run(dat.getVar1());
                }
                LaggRemover.this.autoLagRemovalLoop();
            }
        }, 1200L * (long)LRConfig.autoLagRemovalTime);
    }

    static {
        prefix = "\u00a76\u00a7lLaggRemover \u00a77\u00a7l>>\u00a7r ";
    }
}

