/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.api.proto.help;

import com.avaje.ebean.validation.NotNull;
import drew6017.lr.api.aparser.ProtoParse;
import drew6017.lr.util.DoubleVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HelpFormatter {
    private HashMap<HelpFormatterType, String> parts = new HashMap();

    public HelpFormatter set(HelpFormatterType type, String var) {
        if (!type.equals((Object)HelpFormatterType.RETURNS)) {
            var = var + "\n";
        }
        this.parts.put(type, var);
        return this;
    }

    @NotNull
    public String mk() throws HelpFormatException {
        if (this.parts.size() != 4) {
            throw new HelpFormatException("You must set all help fields in order to compile help information.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a7aDescription: ");
        sb.append(this.parts.get((Object)HelpFormatterType.DESCRIPTION));
        sb.append("\u00a7aCategory(s): ");
        sb.append(this.parts.get((Object)HelpFormatterType.CATEGORIES));
        sb.append("\u00a7aArgument(s): ");
        sb.append(this.parts.get((Object)HelpFormatterType.ARGUMENTS));
        sb.append("\u00a7aReturn(s): ");
        sb.append(this.parts.get((Object)HelpFormatterType.RETURNS));
        return sb.toString();
    }

    public String make() {
        try {
            return this.mk();
        }
        catch (HelpFormatException e) {
            return null;
        }
    }

    public String getInfo(HelpFormatterType type) {
        return this.parts.get((Object)type);
    }

    @NotNull
    public static String generateArgs(ProtoParse p) {
        HashMap<String, ProtoParse.ProtoParseData> var = p.getKeysToClass();
        StringBuilder sb = new StringBuilder();
        HashMap var1 = new HashMap();
        for (String s : var.keySet()) {
            ProtoParse.ProtoParseData da = var.get(s);
            ArrayList<DoubleVar<String, ProtoParse.ProtoParseData>> l = var1.containsKey(da.getIndex()) ? (List)var1.get(da.getIndex()) : new ArrayList<DoubleVar<String, ProtoParse.ProtoParseData>>();
            l.add(new DoubleVar<String, ProtoParse.ProtoParseData>(s, da));
            var1.put(da.getIndex(), l);
        }
        sb.append("\u00a7e{");
        int v1length = var1.size();
        Iterator iterator = var1.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            sb.append(i).append(": ");
            List list = (List)var1.get(i);
            int size = list.size();
            for (int ii = 0; ii < size; ++ii) {
                DoubleVar vag = (DoubleVar)list.get(ii);
                sb.append(((ProtoParse.ProtoParseData)vag.getVar2()).getClazz().getProperName()).append("(").append((String)vag.getVar1()).append(")");
                if (ii + 1 >= size) continue;
                sb.append(" | ");
            }
            if (i + 1 == v1length) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private class HelpFormatException
    extends Exception {
        private String msg;

        HelpFormatException(String msg) {
            this.msg = msg;
        }

        @Override
        public String toString() {
            return this.msg;
        }
    }

    public static enum HelpFormatterType {
        DESCRIPTION,
        CATEGORIES,
        ARGUMENTS,
        RETURNS;

    }
}

