/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.api.proto;

import drew6017.lr.api.proto.DelayedLRProtocolResult;
import drew6017.lr.api.proto.LRProtocol;
import drew6017.lr.api.proto.LRProtocolResult;
import drew6017.lr.main.LaggRemover;
import drew6017.lr.proto.bin.CCEntities;
import drew6017.lr.proto.bin.CCItems;
import drew6017.lr.proto.bin.LRGC;
import drew6017.lr.proto.bin.RunCommand;
import drew6017.lr.util.Counter;
import drew6017.lr.util.LRConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Protocol {
    private static HashMap<String, LRProtocol> protocols;

    public static int init() {
        protocols = new HashMap();
        Protocol.register(new CCEntities(), new CCItems(), new LRGC(), new RunCommand());
        return protocols.size();
    }

    public static void register(LRProtocol ... pros) {
        for (LRProtocol p : pros) {
            Protocol.register(p);
        }
    }

    public static void register(LRProtocol p) {
        p.init();
        protocols.put(p.id(), p);
    }

    public static Collection<LRProtocol> getProtocols() {
        return protocols.values();
    }

    public static boolean hasProtocol(String id) {
        return protocols.containsKey(id);
    }

    public static LRProtocol getProtocol(String name) {
        return protocols.get(name);
    }

    public static LRProtocolResult run(String p, Object[] args) {
        return protocols.get(p).run(args);
    }

    public static LRProtocolResult run(LRProtocol p, Object[] args) {
        return p.run(args);
    }

    public static Counter getCounter(LRProtocol p) {
        return Protocol.getCounter(p.id());
    }

    public static Counter getCounter(String p) {
        String var = null;
        HashMap<Long, Counter.CountAction> actions = new HashMap<Long, Counter.CountAction>();
        List args = LaggRemover.lr.getConfig().getStringList("protocol_warnings." + p + ".stages");
        for (int i = 0; i < args.size(); ++i) {
            final String[] a = ((String)args.get(i)).replaceAll("&", "\u00a7").replaceAll("%PREFIX%", LaggRemover.prefix).split(":");
            if (a[0].equalsIgnoreCase("f")) {
                var = a[1];
                continue;
            }
            actions.put(Long.parseLong(a[0]), new Counter.CountAction(Long.parseLong(a[0])){

                @Override
                public void onTrigger() {
                    LaggRemover.broadcast(a[1]);
                }
            });
        }
        final String var2 = var;
        Counter counter = new Counter(LaggRemover.lr.getConfig().getLong("protocol_warnings." + p + ".time")){

            @Override
            public void onFinish() {
                if (var2 != null) {
                    LaggRemover.broadcast(var2);
                }
            }
        };
        counter.setActions(actions);
        return counter;
    }

    public static void rund(LRProtocol p, Object[] args, DelayedLRProtocolResult res) {
        Counter c = LRConfig.counters.get(p);
        if (!c.start()) {
            return;
        }
        Protocol.delayLoop(c, res, p, args);
    }

    public static void rund(String p, Object[] args, DelayedLRProtocolResult res) {
        Protocol.rund(Protocol.getProtocol(p), args, res);
    }

    private static void delayLoop(final Counter c, final DelayedLRProtocolResult res, final LRProtocol p, final Object[] args) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LaggRemover.lr, new Runnable(){

            @Override
            public void run() {
                if (c.isActive()) {
                    Protocol.delayLoop(c, res, p, args);
                } else {
                    res.receive(Protocol.run(p, args));
                }
            }
        }, 1L);
    }
}

