/*
 * Decompiled with CFR 0.152.
 */
package drew6017.lr.api.aparser;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.EntityType;

public abstract class ProtoParse {
    public abstract HashMap<String, ProtoParseData> getKeysToClass();

    public static abstract class KeywordParser {
        public abstract Object parse(String var1);
    }

    public static enum ProtoParseKeywords {
        BOOLEAN("Boolean", new KeywordParser(){

            @Override
            public Object parse(String data) {
                return Boolean.parseBoolean(data);
            }
        }),
        INTEGER("Integer", new KeywordParser(){

            @Override
            public Object parse(String data) {
                return Integer.parseInt(data);
            }
        }),
        STRING("String", new KeywordParser(){

            @Override
            public Object parse(String data) {
                return data;
            }
        }),
        WORLD("World", new KeywordParser(){

            @Override
            public Object parse(String data) {
                return Bukkit.getWorld((String)data);
            }
        }),
        CHUNK("Chunk", new KeywordParser(){

            @Override
            public Object parse(String data) {
                String[] s = data.split(",");
                World w = Bukkit.getWorld((String)s[0]);
                return w == null ? null : w.getChunkAt(Integer.parseInt(s[1]), Integer.parseInt(s[2]));
            }
        }),
        ENTITY_TYPE_ARRAY("EntityType[]", new KeywordParser(){

            @Override
            public Object parse(String data) {
                String[] s = data.split(",");
                EntityType[] ents = new EntityType[s.length];
                for (int i = 0; i < ents.length; ++i) {
                    ents[i] = EntityType.valueOf((String)s[i]);
                }
                return ents;
            }
        });

        private KeywordParser p;
        private String s;

        private ProtoParseKeywords(String s, KeywordParser p) {
            this.p = p;
            this.s = s;
        }

        public KeywordParser getParser() {
            return this.p;
        }

        public String getProperName() {
            return this.s;
        }
    }

    public static class ProtoParseData {
        private ProtoParseKeywords clazz;
        private int index;

        public ProtoParseData(ProtoParseKeywords clazz, int index) {
            this.clazz = clazz;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public ProtoParseKeywords getClazz() {
            return this.clazz;
        }
    }
}

