/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.listeners;

import com.onarandombox.MultiverseCore.api.LocationManipulation;
import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.destination.InvalidDestination;
import com.onarandombox.MultiverseCore.enums.TeleportResult;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.PortalPlayerSession;
import com.onarandombox.MultiversePortals.destination.PortalDestination;
import com.onarandombox.MultiversePortals.enums.MoveType;
import java.util.Date;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.util.Vector;

public class MVPVehicleListener
implements Listener {
    private MultiversePortals plugin;
    private LocationManipulation locationManipulation;
    private SafeTTeleporter safeTTeleporter;

    public MVPVehicleListener(MultiversePortals plugin) {
        this.plugin = plugin;
        this.locationManipulation = this.plugin.getCore().getLocationManipulation();
        this.safeTTeleporter = this.plugin.getCore().getSafeTTeleporter();
    }

    @EventHandler
    public void vehicleMove(VehicleMoveEvent event) {
        if (event.getVehicle().getPassenger() instanceof Player) {
            Vehicle v = event.getVehicle();
            Player p = (Player)v.getPassenger();
            PortalPlayerSession ps = this.plugin.getPortalSession(p);
            ps.setStaleLocation(v.getLocation(), MoveType.VEHICLE_MOVE);
            if (ps.isStaleLocation()) {
                return;
            }
            this.teleportVehicle(p, v, event.getTo());
        } else {
            MVPortal portal = this.plugin.getPortalManager().getPortal(event.getFrom());
            if (portal != null && portal.getTeleportNonPlayers()) {
                MVDestination dest = portal.getDestination();
                if (dest == null || dest instanceof InvalidDestination) {
                    return;
                }
                if (!portal.isFrameValid(event.getVehicle().getLocation())) {
                    return;
                }
                Vector vehicleVec = event.getVehicle().getVelocity();
                Location target = dest.getLocation((Entity)event.getVehicle());
                if (dest instanceof PortalDestination) {
                    PortalDestination pd = (PortalDestination)dest;
                    vehicleVec = this.locationManipulation.getTranslatedVector(vehicleVec, pd.getOrientationString());
                }
                this.setVehicleVelocity(vehicleVec, dest, event.getVehicle());
                Entity formerPassenger = event.getVehicle().getPassenger();
                event.getVehicle().eject();
                Vehicle newVehicle = (Vehicle)target.getWorld().spawn(target, event.getVehicle().getClass());
                if (formerPassenger != null) {
                    formerPassenger.teleport(target);
                    newVehicle.setPassenger(formerPassenger);
                }
                this.setVehicleVelocity(vehicleVec, dest, newVehicle);
                event.getVehicle().remove();
            }
        }
    }

    private boolean teleportVehicle(Player p, Vehicle v, Location to) {
        PortalPlayerSession ps = this.plugin.getPortalSession(p);
        MVPortal portal = ps.getStandingInPortal();
        if (portal != null && ps.doTeleportPlayer(MoveType.VEHICLE_MOVE) && !ps.showDebugInfo()) {
            if (!ps.allowTeleportViaCooldown(new Date())) {
                p.sendMessage(ps.getFriendlyRemainingTimeMessage());
                return false;
            }
            MVDestination d = portal.getDestination();
            if (d == null || d instanceof InvalidDestination) {
                return false;
            }
            if (!portal.isFrameValid(v.getLocation())) {
                return false;
            }
            Location l = d.getLocation((Entity)p);
            Vector vehicleVec = v.getVelocity();
            if (d instanceof PortalDestination) {
                PortalDestination pd = (PortalDestination)d;
                vehicleVec = this.locationManipulation.getTranslatedVector(vehicleVec, pd.getOrientationString());
            }
            this.setVehicleVelocity(vehicleVec, d, v);
            p.setFallDistance(0.0f);
            if (!l.getWorld().equals(p.getWorld())) {
                return this.teleportVehicleSeperately(p, v, d, ps, this.safeTTeleporter);
            }
            if (this.safeTTeleporter.safelyTeleport((CommandSender)p, (Entity)v, d) == TeleportResult.SUCCESS) {
                ps.playerDidTeleport(to);
                ps.setTeleportTime(new Date());
            }
            return true;
        }
        return false;
    }

    private boolean teleportVehicleSeperately(Player p, Vehicle v, MVDestination to, PortalPlayerSession ps, SafeTTeleporter tp) {
        v.eject();
        Location toLocation = to.getLocation((Entity)v);
        to.getLocation((Entity)p).add(0.0, 0.5, 0.0);
        if (tp.safelyTeleport((CommandSender)p, (Entity)p, to) != TeleportResult.SUCCESS) {
            v.setPassenger((Entity)p);
            return false;
        }
        Vehicle newVehicle = (Vehicle)toLocation.getWorld().spawn(toLocation, v.getClass());
        this.setVehicleVelocity(v.getVelocity(), to, newVehicle);
        newVehicle.setPassenger((Entity)p);
        v.remove();
        return true;
    }

    private void setVehicleVelocity(Vector calculated, MVDestination to, Vehicle newVehicle) {
        if (!to.getVelocity().equals((Object)new Vector(0, 0, 0))) {
            newVehicle.setVelocity(to.getVelocity());
        } else {
            newVehicle.setVelocity(calculated);
        }
    }
}

