/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.capability.RLCapabilities;
import com.charles445.rltweaker.capability.TweakerProvider;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.network.MessageSendVersion;
import com.charles445.rltweaker.network.MessageUpdateAttackYaw;
import com.charles445.rltweaker.network.MessageUpdateDismountStatus;
import com.charles445.rltweaker.network.MessageUpdateEntityMovement;
import com.charles445.rltweaker.network.NetworkHandler;
import com.charles445.rltweaker.network.PacketHandler;
import com.charles445.rltweaker.network.TaskScheduler;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import meldexun.reflectionutil.ReflectionMethod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MinecraftHandler {
    private static final ReflectionMethod<Void> WRITE_PLAYER_DATA = new ReflectionMethod(PlayerList.class, "func_72391_b", "writePlayerData", EntityPlayerMP.class);
    public static Map<String, IContainerValidator> containerValidators = new ConcurrentHashMap<String, IContainerValidator>();
    public Map<UUID, BlockPos> containerEnforcedPlayers = new ConcurrentHashMap<UUID, BlockPos>();

    public MinecraftHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            World world = player.field_70170_p;
            if (!world.field_72995_K && player.field_71070_bA != null && !player.field_71070_bA.equals(player.field_71069_bz)) {
                BlockPos usedPosition;
                UUID playerId = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                IContainerValidator validator = containerValidators.get(player.field_71070_bA.getClass().getName());
                if (validator != null && !validator.isValid(player.field_71070_bA)) {
                    this.containerEnforcedPlayers.remove(playerId);
                    player.func_71053_j();
                }
                if ((usedPosition = this.containerEnforcedPlayers.get(playerId)) != null && usedPosition.func_177951_i((Vec3i)player.func_180425_c()) > 65.0) {
                    this.containerEnforcedPlayers.remove(playerId);
                    player.func_71053_j();
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (ModConfig.server.minecraft.allZombiesBreakDoors && event.getEntity() instanceof EntityZombie) {
            ((EntityZombie)event.getEntity()).func_146070_a(true);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Save event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.server.minecraft.cleanupMineshaftWorldgenFiles) {
            this.cleanMapGenStructureData(world, "Mineshaft", false, true);
        }
    }

    private void cleanMapGenStructureData(World world, String dataName, boolean checkIsUngenerated, boolean checkIsLoaded) {
        long nanoA = System.nanoTime();
        MapGenStructureData structureData = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, dataName);
        if (structureData == null) {
            return;
        }
        NBTTagCompound structureDataCompound = structureData.func_143041_a();
        ArrayList<String> toRemove = new ArrayList<String>();
        long cleanupCount = 0L;
        for (String s : structureDataCompound.func_150296_c()) {
            toRemove.add(s);
        }
        for (String remove : toRemove) {
            structureDataCompound.func_82580_o(remove);
        }
        if (toRemove.size() > 0) {
            structureData.func_76185_a();
        }
        long nanoB = System.nanoTime();
        toRemove.clear();
    }

    private List<ChunkPos> containedChunks(int xIn1, int zIn1, int xIn2, int zIn2) {
        int xStart = xIn1 >> 4;
        int zStart = zIn1 >> 4;
        int xEnd = xIn2 >> 4;
        int zEnd = zIn2 >> 4;
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        for (int i = xStart; i <= xEnd; ++i) {
            for (int j = zStart; j <= zEnd; ++j) {
                chunks.add(new ChunkPos(i, j));
            }
        }
        return chunks;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAttachCapability(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("rltweaker", "tweaker"), (ICapabilityProvider)new TweakerProvider(RLCapabilities.TWEAKER));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientScheduled(TickEvent.ClientTickEvent event) {
        TaskScheduler.processClientTick(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDismount(EntityMountEvent event) {
        EntityPlayerMP player;
        World world = event.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.server.minecraft.playerDismountSync && event.isDismounting() && event.getEntityMounting() instanceof EntityPlayerMP && event.getEntityBeingMounted() != null && NetworkHandler.isVersionAtLeast(0, 3, (EntityPlayer)(player = (EntityPlayerMP)event.getEntityMounting()))) {
            MessageUpdateDismountStatus message = new MessageUpdateDismountStatus();
            PacketHandler.instance.sendTo((IMessage)message, player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClientPlayerJoinWorldEvent(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer localPlayer = RLTweaker.proxy.getClientMinecraftPlayer();
            if (localPlayer == null) {
                return;
            }
            EntityPlayer entPlayer = (EntityPlayer)event.getEntity();
            if (entPlayer.func_146103_bH().getId().equals(localPlayer.func_146103_bH().getId()) && NetworkHandler.serverHasVersioning) {
                RLTweaker.logger.debug("Sending MessageSendVersion to server");
                PacketHandler.instance.sendToServer((IMessage)new MessageSendVersion(RLTweaker.VERSION_DELIMITER));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player != null) {
            NetworkHandler.removeClient(event.player.func_146103_bH().getId());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorldLowest(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow) {
            this.handleArrowJoinWorld((EntityArrow)event.getEntity());
        }
        if (event.getEntity() instanceof EntityPotion) {
            this.handlePotionJoinWorld((EntityPotion)event.getEntity());
        }
    }

    private void handlePotionJoinWorld(EntityPotion potion) {
        if (ModConfig.server.minecraft.witchPotionReplacements && potion.func_85052_h() instanceof EntityWitch) {
            ItemStack stack = potion.func_184543_l();
            PotionType type = PotionUtils.func_185191_c((ItemStack)stack);
            if (type == PotionTypes.field_185252_x) {
                this.swapPotionFromList(potion, stack, ModConfig.server.minecraft.witchHarmingReplacements);
            } else if (type == PotionTypes.field_185246_r) {
                this.swapPotionFromList(potion, stack, ModConfig.server.minecraft.witchSlownessReplacements);
            } else if (type == PotionTypes.field_185254_z) {
                this.swapPotionFromList(potion, stack, ModConfig.server.minecraft.witchPoisonReplacements);
            } else if (type == PotionTypes.field_185226_I) {
                this.swapPotionFromList(potion, stack, ModConfig.server.minecraft.witchWeaknessReplacements);
            }
        }
    }

    private void swapPotionFromList(EntityPotion potion, ItemStack stack, String[] potionNames) {
        PotionType toSwap;
        if (potionNames.length > 0 && (toSwap = PotionType.func_185168_a((String)potionNames[potion.field_70170_p.field_73012_v.nextInt(potionNames.length)])) != null) {
            PotionUtils.func_185188_a((ItemStack)stack, (PotionType)toSwap);
            potion.func_184541_a(stack);
        }
    }

    private void handleArrowJoinWorld(EntityArrow arrow) {
        World world = arrow.func_130014_f_();
        if (!world.field_72995_K && ModConfig.server.minecraft.playerArrowSync && arrow.field_70250_c instanceof EntityPlayer) {
            double posX = arrow.field_70165_t;
            double posY = arrow.field_70163_u;
            double posZ = arrow.field_70161_v;
            MessageUpdateEntityMovement message = new MessageUpdateEntityMovement((Entity)arrow);
            for (EntityPlayer nearbyPlayer : world.field_73010_i) {
                if (!(nearbyPlayer.func_70092_e(posX, posY, posZ) < 576.0) || !NetworkHandler.isVersionAtLeast(0, 2, nearbyPlayer)) continue;
                PacketHandler.instance.sendTo((IMessage)message, (EntityPlayerMP)nearbyPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        LootTable table;
        if (ModConfig.server.minecraft.blacksmithChestTweak && event.getName().equals((Object)LootTableList.field_186423_e) && (table = event.getTable()) != null && (pool = table.getPool("main")) != null) {
            pool.removeEntry("minecraft:diamond");
            pool.removeEntry("minecraft:iron_pickaxe");
            pool.removeEntry("minecraft:iron_sword");
            pool.removeEntry("minecraft:iron_chestplate");
            pool.removeEntry("minecraft:iron_helmet");
            pool.removeEntry("minecraft:iron_leggings");
            pool.removeEntry("minecraft:iron_boots");
            pool.removeEntry("minecraft:obsidian");
            pool.removeEntry("minecraft:iron_horse_armor");
            pool.removeEntry("minecraft:golden_horse_armor");
            pool.removeEntry("minecraft:diamond_horse_armor");
        }
    }

    @SubscribeEvent
    public void onKnockback(LivingKnockBackEvent event) {
        if (!ModConfig.server.minecraft.damageTilt) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            if (NetworkHandler.isVersionAtLeast(0, 4, player)) {
                PacketHandler.instance.sendTo((IMessage)new MessageUpdateAttackYaw((EntityLivingBase)player), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        if (event.getSound() == SoundEvents.field_187754_de && ModConfig.server.minecraft.lightningSoundChunkDistance != 10000.0) {
            event.setVolume((float)ModConfig.server.minecraft.lightningSoundChunkDistance);
        }
    }

    @SubscribeEvent
    public void onContainerOpen(PlayerContainerEvent.Open event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (event.getContainer() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        UUID playerId = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
        String containerClazz = event.getContainer().getClass().getName();
        String[] distanceClazzes = ModConfig.server.minecraft.containerDistanceClasses;
        for (int i = 0; i < distanceClazzes.length; ++i) {
            if (!containerClazz.equals(distanceClazzes[i])) continue;
            this.containerEnforcedPlayers.put(playerId, player.func_180425_c());
            return;
        }
        this.containerEnforcedPlayers.remove(playerId);
    }

    @SubscribeEvent
    public void onContainerClosed(PlayerContainerEvent.Close event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (event.getContainer() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        this.containerEnforcedPlayers.remove(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    @SubscribeEvent
    public void onLightningStruckEntity(EntityStruckByLightningEvent event) {
        if (!ModConfig.server.minecraft.lightningDestroysItems && event.getEntity() instanceof EntityItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void fixDropDisconnectLagDupe(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!ModConfig.server.minecraft.fixDropDisconnectLagDupe) {
            return;
        }
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        MinecraftServer server = event.player.func_184102_h();
        server.field_175589_i.add(new FutureTask<Object>(() -> {
            WRITE_PLAYER_DATA.invoke(server.func_184103_al(), (EntityPlayerMP)event.player);
            return null;
        }));
    }

    public static interface IContainerValidator {
        public boolean isValid(Container var1);
    }
}

